

#include "SWF.h"
#include <string.h>

namespace SWF {


size_t Rectangle::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 5;

	r += bits;

	r += bits;

	r += bits;

	r += bits;

	if( r%8 != 0 ) r += 8-(r%8);

	
	r += Item::getHeaderSize( r );
//	printf("Rectangle sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t Color::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 8;

	r += 8;

	r += 8;

	if( r%8 != 0 ) r += 8-(r%8);

	
	r += Item::getHeaderSize( r );
//	printf("Color sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t ColorRGBA::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 8;

	r += 8;

	r += 8;

	r += 8;

	if( r%8 != 0 ) r += 8-(r%8);

	
	r += Item::getHeaderSize( r );
//	printf("ColorRGBA sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t String::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += ((value ? strlen( value ) : 0)+1)*8;

	
	r += Item::getHeaderSize( r );
//	printf("String sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t Transform::getSize( Context *ctx ) {
	size_t r = 0;
	
	r++;

	if( scaled ) {
		
		
	r += 5;

	r += bitsScale;

	r += bitsScale;

	}

	r++;

	if( skewed ) {
		
		
	r += 5;

	r += bitsSkew;

	r += bitsSkew;

	}

	r += 5;

	r += bitsTranslate;

	r += bitsTranslate;

	if( r%8 != 0 ) r += 8-(r%8);

	
	r += Item::getHeaderSize( r );
//	printf("Transform sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t ColorTransform2::getSize( Context *ctx ) {
	size_t r = 0;
	
	r++;

	r++;

	r += 4;

	if( hasFactor ) {
		
		
	r += bits;

	r += bits;

	r += bits;

	r += bits;

	}

	if( hasOffset ) {
		
		
	r += bits;

	r += bits;

	r += bits;

	r += bits;

	}

	if( r%8 != 0 ) r += 8-(r%8);

	
	r += Item::getHeaderSize( r );
//	printf("ColorTransform2 sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t Header::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += size.getSize(ctx);

	r += 16;

	r += 16;

	{
		Tag* item;
		ListItem<Tag>* i;
		i = tags.first();
		while( i ) {
			item = i->data();
			if( item ) {
				r += item->getSize(ctx);
			}
			i = i->next();
		}
	}

	
	r += Item::getHeaderSize( r );
//	printf("Header sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t LineStyle::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 16;

	r += color.getSize(ctx);

	
	r += Item::getHeaderSize( r );
//	printf("LineStyle sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t StyleList::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 8;

	{
		Style* item;
		ListItem<Style>* i;
		i = fillStyles.first();
		while( i ) {
			item = i->data();
			if( item ) {
				r += item->getSize(ctx);
			}
			i = i->next();
		}
	}

	r += 8;

	{
		LineStyle* item;
		ListItem<LineStyle>* i;
		i = lineStyles.first();
		while( i ) {
			item = i->data();
			if( item ) {
				r += item->getSize(ctx);
			}
			i = i->next();
		}
	}

	
	r += Item::getHeaderSize( r );
//	printf("StyleList sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t ShapeSetup::getSize( Context *ctx ) {
	size_t r = 0;
	
	r++;

	r++;

	r++;

	r++;

	r++;

	if( hasMoveTo ) {
		
		
	r += 5;

	r += xybits;

	r += xybits;

	}

	if( hasFillStyle0 ) {
		
		
	r += ctx->fillBits;

	}

	if( hasFillStyle1 ) {
		
		
	r += ctx->fillBits;

	}

	if( hasLineStyle ) {
		
		
	r += ctx->lineBits;

	}

	if( hasNewStyles ) {
		
		
	r += styles.getSize(ctx);

	}

	
	r += ShapeItem::getHeaderSize( r );
//	printf("ShapeSetup sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t CurveTo::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 4;

	r += bits+2;

	r += bits+2;

	r += bits+2;

	r += bits+2;

	
	r += ShapeItem::getHeaderSize( r );
//	printf("CurveTo sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t Shape::getSize( Context *ctx ) {
	size_t r = 0;
	
	ctx->fillBits = fillBits;

	ctx->lineBits = lineBits;

	r += 4;

	r += 4;

	{
		ShapeItem* item;
		ListItem<ShapeItem>* i;
		i = edges.first();
		while( i ) {
			item = i->data();
			if( item ) {
				r += item->getSize(ctx);
			}
			i = i->next();
		}
	}

	
	r += Item::getHeaderSize( r );
//	printf("Shape sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t GradientItem::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 8;

	r += color.getSize(ctx);

	
	r += Item::getHeaderSize( r );
//	printf("GradientItem sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t Symbol::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 16;

	r += ((name ? strlen( name ) : 0)+1)*8;

	
	r += Item::getHeaderSize( r );
//	printf("Symbol sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t Parameter::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 8;

	r += ((name ? strlen( name ) : 0)+1)*8;

	
	r += Item::getHeaderSize( r );
//	printf("Parameter sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t UChar::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 8;

	
	r += Item::getHeaderSize( r );
//	printf("UChar sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t UShort::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 16;

	
	r += Item::getHeaderSize( r );
//	printf("UShort sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t ULong::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 32;

	
	r += Item::getHeaderSize( r );
//	printf("ULong sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t Short::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 16;

	
	r += Item::getHeaderSize( r );
//	printf("Short sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t Kerning::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 8;

	r += 8;

	
	r += Item::getHeaderSize( r );
//	printf("Kerning sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t WideKerning::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 16;

	r += 16;

	
	r += Item::getHeaderSize( r );
//	printf("WideKerning sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t TextEntry::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += ctx->glyphBits;

	r += ctx->advanceBits;

	
	r += Item::getHeaderSize( r );
//	printf("TextEntry sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t TextRecord6::getSize( Context *ctx ) {
	size_t r = 0;
	
	r++;

	if( isSetup ) {
		
		
	r += 3;

	r++;

	r++;

	r++;

	r++;

	if( hasFont ) {
		
		
	r += 16;

	}

	if( hasColor ) {
		
		
	r += color.getSize(ctx);

	}

	if( hasMoveX ) {
		
		
	r += 16;

	}

	if( hasMoveY ) {
		
		
	r += 16;

	}

	if( hasFont ) {
		
		
	r += 16;

	}

	}

	if( !isSetup ) {
		
		
	r += 7;

	{
		TextEntry* item;
		ListItem<TextEntry>* i;
		i = glyphs.first();
		while( i ) {
			item = i->data();
			if( item ) {
				r += item->getSize(ctx);
			}
			i = i->next();
		}
	}

	if( r%8 != 0 ) r += 8-(r%8);

	}

	
	r += Item::getHeaderSize( r );
//	printf("TextRecord6 sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t TextRecord7::getSize( Context *ctx ) {
	size_t r = 0;
	
	r++;

	r += 3;

	r++;

	r++;

	r++;

	r++;

	if( hasFont ) {
		
		
	r += 16;

	}

	if( hasColor ) {
		
		
	r += color.getSize(ctx);

	}

	if( hasMoveX ) {
		
		
	r += 16;

	}

	if( hasMoveY ) {
		
		
	r += 16;

	}

	if( hasFont ) {
		
		
	r += 16;

	}

	if( isSetup ) {
		
		
	r += 8;

	{
		TextEntry* item;
		ListItem<TextEntry>* i;
		i = glyphs.first();
		while( i ) {
			item = i->data();
			if( item ) {
				r += item->getSize(ctx);
			}
			i = i->next();
		}
	}

	}

	if( r%8 != 0 ) r += 8-(r%8);

	
	r += Item::getHeaderSize( r );
//	printf("TextRecord7 sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t TextRecord::getSize( Context *ctx ) {
	size_t r = 0;
	
	if( ctx->swfVersion < 7 ) {
		
	{
		TextRecord6* item;
		ListItem<TextRecord6>* i;
		i = records.first();
		while( i ) {
			item = i->data();
			if( item ) {
				r += item->getSize(ctx);
			}
			i = i->next();
		}
	}

	}

	if( ctx->swfVersion >= 7 ) {
		
	r += string.getSize(ctx);

	}

	
	r += Item::getHeaderSize( r );
//	printf("TextRecord sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t Button::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 4;

	r++;

	r++;

	r++;

	r++;

	if( hitTest || down || over || up ) {
		
	r += 16;

	r += 16;

	r += transform.getSize(ctx);

	r += colorTransform.getSize(ctx);

	}

	
	r += Item::getHeaderSize( r );
//	printf("Button sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t Condition::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 16;

	r += 7;

	r++;

	r++;

	r++;

	r++;

	r++;

	r++;

	r++;

	r++;

	r++;

	{
		Action* item;
		ListItem<Action>* i;
		i = actions.first();
		while( i ) {
			item = i->data();
			if( item ) {
				r += item->getSize(ctx);
			}
			i = i->next();
		}
	}

	
	r += Item::getHeaderSize( r );
//	printf("Condition sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t Solid::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += color.getSize(ctx);

	
	r += Style::getHeaderSize( r );
//	printf("Solid sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t LinearGradient::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += matrix.getSize(ctx);

	r += 8;

	{
		GradientItem* item;
		ListItem<GradientItem>* i;
		i = gradientColors.first();
		while( i ) {
			item = i->data();
			if( item ) {
				r += item->getSize(ctx);
			}
			i = i->next();
		}
	}

	
	r += Style::getHeaderSize( r );
//	printf("LinearGradient sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t RadialGradient::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += matrix.getSize(ctx);

	r += 8;

	{
		GradientItem* item;
		ListItem<GradientItem>* i;
		i = gradientColors.first();
		while( i ) {
			item = i->data();
			if( item ) {
				r += item->getSize(ctx);
			}
			i = i->next();
		}
	}

	
	r += Style::getHeaderSize( r );
//	printf("RadialGradient sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t TiledBitmap::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 16;

	r += matrix.getSize(ctx);

	
	r += Style::getHeaderSize( r );
//	printf("TiledBitmap sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t ClippedBitmap::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 16;

	r += matrix.getSize(ctx);

	
	r += Style::getHeaderSize( r );
//	printf("ClippedBitmap sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t UnknownTag::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += len * 8;

	
	r += Tag::getHeaderSize( r );
//	printf("UnknownTag sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t End::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Tag::getHeaderSize( r );
//	printf("End sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t ShowFrame::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Tag::getHeaderSize( r );
//	printf("ShowFrame sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t DefineShape::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 16;

	r += bounds.getSize(ctx);

	r += styles.getSize(ctx);

	r += shapes.getSize(ctx);

	if( r%8 != 0 ) r += 8-(r%8);

	
	r += Tag::getHeaderSize( r );
//	printf("DefineShape sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t RemoveObject::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 16;

	r += 16;

	
	r += Tag::getHeaderSize( r );
//	printf("RemoveObject sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t DefineBits::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 16;

	r += data.getSize(ctx);

	
	r += Tag::getHeaderSize( r );
//	printf("DefineBits sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t SetBackgroundColor::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += color.getSize(ctx);

	
	r += Tag::getHeaderSize( r );
//	printf("SetBackgroundColor sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t DefineText::getSize( Context *ctx ) {
	size_t r = 0;
	
	ctx->glyphBits = glyphBits;

	ctx->advanceBits = advanceBits;

	r += 16;

	r += bounds.getSize(ctx);

	r += transform.getSize(ctx);

	r += 8;

	r += 8;

	{
		TextRecord* item;
		ListItem<TextRecord>* i;
		i = records.first();
		while( i ) {
			item = i->data();
			if( item ) {
				r += item->getSize(ctx);
			}
			i = i->next();
		}
	}

	
	r += Tag::getHeaderSize( r );
//	printf("DefineText sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t DoAction::getSize( Context *ctx ) {
	size_t r = 0;
	
	{
		Action* item;
		ListItem<Action>* i;
		i = actions.first();
		while( i ) {
			item = i->data();
			if( item ) {
				r += item->getSize(ctx);
			}
			i = i->next();
		}
	}

	
	r += Tag::getHeaderSize( r );
//	printf("DoAction sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t DefineFontInfo::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 16;

	r += 8;

	r += nameLength * 8;

	r += 2;

	r++;

	r++;

	r++;

	r++;

	r++;

	r++;

	if( ctx->swfVersion>=6 ) {
		
	r += 8;

	}

	r += map.getSize(ctx);

	
	r += Tag::getHeaderSize( r );
//	printf("DefineFontInfo sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t DefineFontInfo2::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 16;

	r += 8;

	r += nameLength * 8;

	r += 2;

	r++;

	r++;

	r++;

	r++;

	r++;

	r++;

	if( ctx->swfVersion>=6 ) {
		
	r += 8;

	}

	r += map.getSize(ctx);

	
	r += Tag::getHeaderSize( r );
//	printf("DefineFontInfo2 sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t SoundStreamHead::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 4;

	r += 2;

	r++;

	r++;

	r += 4;

	r += 2;

	r++;

	r++;

	r += 16;

	if( compression==2 ) {
		
	r += latencySeek.getSize(ctx);

	}

	
	r += Tag::getHeaderSize( r );
//	printf("SoundStreamHead sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t DefineBitsLossless::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 16;

	r += 8;

	r += 16;

	r += 16;

	r += data.getSize(ctx);

	
	r += Tag::getHeaderSize( r );
//	printf("DefineBitsLossless sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t DefineBitsJPEG2::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 16;

	r += data.getSize(ctx);

	
	r += Tag::getHeaderSize( r );
//	printf("DefineBitsJPEG2 sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t DefineBitsLossless2::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 16;

	r += 8;

	r += 16;

	r += 16;

	r += data.getSize(ctx);

	
	r += Tag::getHeaderSize( r );
//	printf("DefineBitsLossless2 sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t PlaceObject2::getSize( Context *ctx ) {
	size_t r = 0;
	
	r++;

	r++;

	r++;

	r++;

	r++;

	r++;

	r++;

	r++;

	r += 16;

	if( hasID ) {
		
		
	r += 16;

	}

	if( hasTransform ) {
		
		
	r += transform.getSize(ctx);

	}

	if( hasColorTransform ) {
		
		
	r += colorTransform.getSize(ctx);

	}

	if( hasMorph ) {
		
		
	r += 16;

	}

	if( hasName ) {
		
		
	r += ((name ? strlen( name ) : 0)+1)*8;

	}

	if( hasClipDepth ) {
		
		
	r += 16;

	}

	if( hasEventHandler ) {
		
		
	r += events.getSize(ctx);

	}

	
	r += Tag::getHeaderSize( r );
//	printf("PlaceObject2 sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t RemoveObject2::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 16;

	
	r += Tag::getHeaderSize( r );
//	printf("RemoveObject2 sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t DefineEditText::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 16;

	r += size.getSize(ctx);

	r++;

	r++;

	r++;

	r++;

	r++;

	r++;

	r++;

	r++;

	r++;

	r++;

	r++;

	r++;

	r++;

	r++;

	r++;

	r++;

	if( hasFont ) {
		
		
	r += 16;

	r += 16;

	}

	if( hasColor ) {
		
		
	r += color.getSize(ctx);

	}

	if( hasMaxLength ) {
		
		
	r += 16;

	}

	if( hasLayout ) {
		
		
	r += 8;

	r += 16;

	r += 16;

	r += 16;

	r += 16;

	}

	r += ((variableName ? strlen( variableName ) : 0)+1)*8;

	if( hasText ) {
		
		
	r += ((initialText ? strlen( initialText ) : 0)+1)*8;

	}

	
	r += Tag::getHeaderSize( r );
//	printf("DefineEditText sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t DefineSprite::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 16;

	r += 16;

	{
		Tag* item;
		ListItem<Tag>* i;
		i = tags.first();
		while( i ) {
			item = i->data();
			if( item ) {
				r += item->getSize(ctx);
			}
			i = i->next();
		}
	}

	
	r += Tag::getHeaderSize( r );
//	printf("DefineSprite sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t FrameLabel::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += ((label ? strlen( label ) : 0)+1)*8;

	r += flags.getSize(ctx);

	
	r += Tag::getHeaderSize( r );
//	printf("FrameLabel sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t SoundStreamHead2::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 4;

	r += 2;

	r++;

	r++;

	r += 4;

	r += 2;

	r++;

	r++;

	r += 16;

	if( compression==2 ) {
		
	r += latencySeek.getSize(ctx);

	}

	
	r += Tag::getHeaderSize( r );
//	printf("SoundStreamHead2 sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t DefineFont::getSize( Context *ctx ) {
	size_t r = 0;
	
	ctx->tagVersion = 1;

	ctx->wideGlyphOffsets = 0;

	r += 16;

	r += glyphs.getSize(ctx);

	
	r += Tag::getHeaderSize( r );
//	printf("DefineFont sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t DefineFont2::getSize( Context *ctx ) {
	size_t r = 0;
	
	ctx->wideGlyphOffsets = wideGlyphOffsets;

	ctx->wideMap = wideMap;

	ctx->glyphCount = glyphCount;

	ctx->tagVersion = 2;

	r += 16;

	r++;

	r++;

	r++;

	r++;

	r++;

	r++;

	r++;

	r++;

	r += 8;

	r += ((name ? strlen( name ) : 0)+1)*8;

	r += 16;

	r += glyphs.getSize(ctx);

	if( hasLayout ) {
		
		
	r += 16;

	r += 16;

	r += 16;

	{
		Short* item;
		ListItem<Short>* i;
		i = advance.first();
		while( i ) {
			item = i->data();
			if( item ) {
				r += item->getSize(ctx);
			}
			i = i->next();
		}
	}

	{
		Rectangle* item;
		ListItem<Rectangle>* i;
		i = bounds.first();
		while( i ) {
			item = i->data();
			if( item ) {
				r += item->getSize(ctx);
			}
			i = i->next();
		}
	}

	r += 16;

	if( wideMap ) {
		
		
	{
		WideKerning* item;
		ListItem<WideKerning>* i;
		i = wideKerning.first();
		while( i ) {
			item = i->data();
			if( item ) {
				r += item->getSize(ctx);
			}
			i = i->next();
		}
	}

	}

	if( !wideMap ) {
		
		
	{
		Kerning* item;
		ListItem<Kerning>* i;
		i = kerning.first();
		while( i ) {
			item = i->data();
			if( item ) {
				r += item->getSize(ctx);
			}
			i = i->next();
		}
	}

	}

	}

	
	r += Tag::getHeaderSize( r );
//	printf("DefineFont2 sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t DefineButton2::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 16;

	r += 7;

	r++;

	r += 16;

	{
		Button* item;
		ListItem<Button>* i;
		i = buttons.first();
		while( i ) {
			item = i->data();
			if( item ) {
				r += item->getSize(ctx);
			}
			i = i->next();
		}
	}

	{
		Condition* item;
		ListItem<Condition>* i;
		i = conditions.first();
		while( i ) {
			item = i->data();
			if( item ) {
				r += item->getSize(ctx);
			}
			i = i->next();
		}
	}

	
	r += Tag::getHeaderSize( r );
//	printf("DefineButton2 sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t Export::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 16;

	{
		Symbol* item;
		ListItem<Symbol>* i;
		i = symbols.first();
		while( i ) {
			item = i->data();
			if( item ) {
				r += item->getSize(ctx);
			}
			i = i->next();
		}
	}

	
	r += Tag::getHeaderSize( r );
//	printf("Export sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t Import::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += ((url ? strlen( url ) : 0)+1)*8;

	r += 16;

	{
		Symbol* item;
		ListItem<Symbol>* i;
		i = symbols.first();
		while( i ) {
			item = i->data();
			if( item ) {
				r += item->getSize(ctx);
			}
			i = i->next();
		}
	}

	
	r += Tag::getHeaderSize( r );
//	printf("Import sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t DoInitAction::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 16;

	{
		Action* item;
		ListItem<Action>* i;
		i = actions.first();
		while( i ) {
			item = i->data();
			if( item ) {
				r += item->getSize(ctx);
			}
			i = i->next();
		}
	}

	
	r += Tag::getHeaderSize( r );
//	printf("DoInitAction sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t SoundStreamBlock::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += len * 8;

	
	r += Tag::getHeaderSize( r );
//	printf("SoundStreamBlock sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t DefineVideoStream::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 16;

	r += 16;

	r += 16;

	r += 16;

	r += 5;

	r += 2;

	r++;

	r += 8;

	
	r += Tag::getHeaderSize( r );
//	printf("DefineVideoStream sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t VideoFrame::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 16;

	r += 16;

	r += data.getSize(ctx);

	
	r += Tag::getHeaderSize( r );
//	printf("VideoFrame sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t StackString::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += ((value ? strlen( value ) : 0)+1)*8;

	
	r += StackItem::getHeaderSize( r );
//	printf("StackString sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t StackFloat::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 32;

	
	r += StackItem::getHeaderSize( r );
//	printf("StackFloat sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t StackNull::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += StackItem::getHeaderSize( r );
//	printf("StackNull sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t StackUndefined::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += StackItem::getHeaderSize( r );
//	printf("StackUndefined sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t StackRegister::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 8;

	
	r += StackItem::getHeaderSize( r );
//	printf("StackRegister sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t StackBoolean::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 8;

	
	r += StackItem::getHeaderSize( r );
//	printf("StackBoolean sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t StackDouble::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 64;

	
	r += StackItem::getHeaderSize( r );
//	printf("StackDouble sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t StackInteger::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 32;

	
	r += StackItem::getHeaderSize( r );
//	printf("StackInteger sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t StackDictionaryLookup::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 8;

	
	r += StackItem::getHeaderSize( r );
//	printf("StackDictionaryLookup sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t StackLargeDictionaryLookup::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 16;

	
	r += StackItem::getHeaderSize( r );
//	printf("StackLargeDictionaryLookup sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t UnknownAction::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += len * 8;

	
	r += Action::getHeaderSize( r );
//	printf("UnknownAction sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t EndAction::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("EndAction sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t NextFrame::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("NextFrame sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t PreviousFrame::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("PreviousFrame sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t Play::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("Play sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t Stop::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("Stop sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t ToggleQuality::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("ToggleQuality sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t StopSound::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("StopSound sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t AddCast::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("AddCast sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t Substract::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("Substract sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t Mulitply::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("Mulitply sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t Divide::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("Divide sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t EqualCast::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("EqualCast sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t LessThanCast::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("LessThanCast sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t LogicalAND::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("LogicalAND sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t LogicalOR::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("LogicalOR sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t LogicalNOT::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("LogicalNOT sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t StringEqual::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("StringEqual sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t StringLength::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("StringLength sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t SubString::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("SubString sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t Pop::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("Pop sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t IntegralPart::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("IntegralPart sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t GetVariable::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("GetVariable sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t SetVariable::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("SetVariable sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t SetTargetDynamic::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("SetTargetDynamic sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t ConcatenateString::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("ConcatenateString sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t GetProperty::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("GetProperty sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t SetProperty::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("SetProperty sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t DuplicateSprite::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("DuplicateSprite sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t RemoveSprite::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("RemoveSprite sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t Trace::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("Trace sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t StartDrag::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("StartDrag sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t StopDrag::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("StopDrag sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t StringLessThan::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("StringLessThan sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t Throw::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("Throw sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t CastObject::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("CastObject sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t Implements::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("Implements sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t Random::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("Random sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t MultibyteStringLength::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("MultibyteStringLength sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t ORD::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("ORD sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t CHR::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("CHR sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t GetTimer::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("GetTimer sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t MultibyteSubString::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("MultibyteSubString sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t MultibyteORD::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("MultibyteORD sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t MultibyteCHR::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("MultibyteCHR sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t Delete::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("Delete sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t DeleteAll::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("DeleteAll sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t SetLocalVariable::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("SetLocalVariable sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t CallFunction::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("CallFunction sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t Return::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("Return sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t Modulo::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("Modulo sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t New::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("New sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t DeclareLocalVariable::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("DeclareLocalVariable sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t DeclareArray::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("DeclareArray sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t DeclareObject::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("DeclareObject sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t TypeOf::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("TypeOf sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t GetTarget::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("GetTarget sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t Enumerate::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("Enumerate sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t AddTyped::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("AddTyped sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t LessThanTyped::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("LessThanTyped sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t EqualTyped::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("EqualTyped sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t DefineNumber::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("DefineNumber sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t DefineString::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("DefineString sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t Duplicate::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("Duplicate sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t Swap::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("Swap sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t GetMember::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("GetMember sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t SetMember::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("SetMember sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t Increment::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("Increment sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t Decrement::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("Decrement sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t CallMethod::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("CallMethod sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t NewMethod::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("NewMethod sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t InstanceOf::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("InstanceOf sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t EnumerateObject::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("EnumerateObject sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t AND::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("AND sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t OR::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("OR sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t XOR::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("XOR sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t ShiftLeft::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("ShiftLeft sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t ShiftRight::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("ShiftRight sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t ShiftRightUnsigned::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("ShiftRightUnsigned sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t StrictEqual::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("StrictEqual sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t GreaterThanTyped::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("GreaterThanTyped sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t StringGreaterThan::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("StringGreaterThan sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t Extends::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("Extends sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t GotoFrame::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 16;

	
	r += Action::getHeaderSize( r );
//	printf("GotoFrame sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t GetURL::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += ((url ? strlen( url ) : 0)+1)*8;

	r += ((target ? strlen( target ) : 0)+1)*8;

	
	r += Action::getHeaderSize( r );
//	printf("GetURL sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t StoreRegister::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 8;

	
	r += Action::getHeaderSize( r );
//	printf("StoreRegister sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t Dictionary::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 16;

	{
		String* item;
		ListItem<String>* i;
		i = strings.first();
		while( i ) {
			item = i->data();
			if( item ) {
				r += item->getSize(ctx);
			}
			i = i->next();
		}
	}

	
	r += Action::getHeaderSize( r );
//	printf("Dictionary sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t WaitForFrame::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 16;

	r += 8;

	
	r += Action::getHeaderSize( r );
//	printf("WaitForFrame sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t SetTarget::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += ((label ? strlen( label ) : 0)+1)*8;

	
	r += Action::getHeaderSize( r );
//	printf("SetTarget sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t GotoLabel::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += ((label ? strlen( label ) : 0)+1)*8;

	
	r += Action::getHeaderSize( r );
//	printf("GotoLabel sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t WaitForFrameDynamic::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 16;

	r += 8;

	
	r += Action::getHeaderSize( r );
//	printf("WaitForFrameDynamic sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t DeclareFunction2::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += ((name ? strlen( name ) : 0)+1)*8;

	r += 16;

	r += 8;

	r++;

	r++;

	r++;

	r++;

	r++;

	r++;

	r++;

	r++;

	r++;

	r += 7;

	{
		Parameter* item;
		ListItem<Parameter>* i;
		i = args.first();
		while( i ) {
			item = i->data();
			if( item ) {
				r += item->getSize(ctx);
			}
			i = i->next();
		}
	}

	r += 16;

	{
		Action* item;
		ListItem<Action>* i;
		i = actions.first();
		while( i ) {
			item = i->data();
			if( item ) {
				r += item->getSize(ctx);
			}
			i = i->next();
		}
	}

	
	r += Action::getHeaderSize( r );
//	printf("DeclareFunction2 sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t Try::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 5;

	r++;

	r++;

	r++;

	r += 16;

	r += 16;

	r += 16;

	if( catchInRegister ) {
		
		
	r += 8;

	}

	
	r += Action::getHeaderSize( r );
//	printf("Try sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t With::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 16;

	
	r += Action::getHeaderSize( r );
//	printf("With sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t PushData::getSize( Context *ctx ) {
	size_t r = 0;
	
	{
		StackItem* item;
		ListItem<StackItem>* i;
		i = items.first();
		while( i ) {
			item = i->data();
			if( item ) {
				r += item->getSize(ctx);
			}
			i = i->next();
		}
	}

	
	r += Action::getHeaderSize( r );
//	printf("PushData sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t GetURL2::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 8;

	
	r += Action::getHeaderSize( r );
//	printf("GetURL2 sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t DeclareFunction::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += ((name ? strlen( name ) : 0)+1)*8;

	r += 16;

	{
		String* item;
		ListItem<String>* i;
		i = args.first();
		while( i ) {
			item = i->data();
			if( item ) {
				r += item->getSize(ctx);
			}
			i = i->next();
		}
	}

	r += 16;

	
	r += Action::getHeaderSize( r );
//	printf("DeclareFunction sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t BranchAlways::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 16;

	
	r += Action::getHeaderSize( r );
//	printf("BranchAlways sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t BranchIfTrue::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 16;

	
	r += Action::getHeaderSize( r );
//	printf("BranchIfTrue sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t CallFrame::getSize( Context *ctx ) {
	size_t r = 0;
	
	
	r += Action::getHeaderSize( r );
//	printf("CallFrame sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}

size_t GotoExpression::getSize( Context *ctx ) {
	size_t r = 0;
	
	r += 8;

	
	r += Action::getHeaderSize( r );
//	printf("GotoExpression sz %i bits (%.2f bytes)\n", r, ((float)r)/8 );
	return r;
}


}

