

#include "SWF.h"

namespace SWF {

void print_indent( int n ) {
	for( int i=0; i<n; i++ ) printf("  ");
}


void Rectangle::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
	
	printf("Rectangle"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("bits: "); 
	printf("%i\n", bits);

	print_indent(indent);
	printf("left: "); 
	printf("%i\n", left);

	print_indent(indent);
	printf("right: "); 
	printf("%i\n", right);

	print_indent(indent);
	printf("top: "); 
	printf("%i\n", top);

	print_indent(indent);
	printf("bottom: "); 
	printf("%i\n", bottom);

}

void Color::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
	
	printf("Color"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("red: "); 
	printf("%i\n", red);

	print_indent(indent);
	printf("green: "); 
	printf("%i\n", green);

	print_indent(indent);
	printf("blue: "); 
	printf("%i\n", blue);

}

void ColorRGBA::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
	
	printf("ColorRGBA"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("red: "); 
	printf("%i\n", red);

	print_indent(indent);
	printf("green: "); 
	printf("%i\n", green);

	print_indent(indent);
	printf("blue: "); 
	printf("%i\n", blue);

	print_indent(indent);
	printf("alpha: "); 
	printf("%i\n", alpha);

}

void String::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
	
	printf("String"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("value: "); 
	printf("%s\n", value?value:"(nil)");

}

void Transform::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
	
	printf("Transform"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("scaled: "); 
	printf("%i\n", scaled);

	if( scaled ) {
		
		
	print_indent(indent);
	printf("bitsScale: "); 
	printf("%i\n", bitsScale);

	print_indent(indent);
	printf("scaleX: "); 
	printf("%E\n", scaleX);

	print_indent(indent);
	printf("scaleY: "); 
	printf("%E\n", scaleY);

	}

	print_indent(indent);
	printf("skewed: "); 
	printf("%i\n", skewed);

	if( skewed ) {
		
		
	print_indent(indent);
	printf("bitsSkew: "); 
	printf("%i\n", bitsSkew);

	print_indent(indent);
	printf("skewX: "); 
	printf("%E\n", skewX);

	print_indent(indent);
	printf("skewY: "); 
	printf("%E\n", skewY);

	}

	print_indent(indent);
	printf("bitsTranslate: "); 
	printf("%i\n", bitsTranslate);

	print_indent(indent);
	printf("transX: "); 
	printf("%i\n", transX);

	print_indent(indent);
	printf("transY: "); 
	printf("%i\n", transY);

}

void ColorTransform2::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
	
	printf("ColorTransform2"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("hasOffset: "); 
	printf("%i\n", hasOffset);

	print_indent(indent);
	printf("hasFactor: "); 
	printf("%i\n", hasFactor);

	print_indent(indent);
	printf("bits: "); 
	printf("%i\n", bits);

	if( hasFactor ) {
		
		
	print_indent(indent);
	printf("factorRed: "); 
	printf("%i\n", factorRed);

	print_indent(indent);
	printf("factorGreen: "); 
	printf("%i\n", factorGreen);

	print_indent(indent);
	printf("factorBlue: "); 
	printf("%i\n", factorBlue);

	print_indent(indent);
	printf("factorAlpha: "); 
	printf("%i\n", factorAlpha);

	}

	if( hasOffset ) {
		
		
	print_indent(indent);
	printf("offsetRed: "); 
	printf("%i\n", offsetRed);

	print_indent(indent);
	printf("offsetGreen: "); 
	printf("%i\n", offsetGreen);

	print_indent(indent);
	printf("offsetBlue: "); 
	printf("%i\n", offsetBlue);

	print_indent(indent);
	printf("offsetAlpha: "); 
	printf("%i\n", offsetAlpha);

	}

}

void Header::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
	
	printf("Header"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("size: "); 
	printf("[Rectangle]\n");
	size.dump( indent+1, ctx );

	print_indent(indent);
	printf("framerate: "); 
	printf("%i\n", framerate);

	print_indent(indent);
	printf("frames: "); 
	printf("%i\n", frames);

	print_indent(indent);
	printf("tags: "); 
	{
		printf("[list of Tags]\n");
		Tag *item;
		ListItem<Tag>* i;
		i = tags.first();
		while( i ) {
			item = i->data();
			if( item ) {
				item->dump(indent+1,ctx);
			}
			i = i->next();
		}
	}

}

void LineStyle::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
	
	printf("LineStyle"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("width: "); 
	printf("%i\n", width);

	print_indent(indent);
	printf("color: "); 
	printf("[Color]\n");
	color.dump( indent+1, ctx );

}

void StyleList::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
	
	printf("StyleList"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("n_fillStyles: "); 
	printf("%i\n", n_fillStyles);

	print_indent(indent);
	printf("fillStyles: "); 
	{
		printf("[list of Styles]\n");
		Style *item;
		ListItem<Style>* i;
		i = fillStyles.first();
		while( i ) {
			item = i->data();
			if( item ) {
				item->dump(indent+1,ctx);
			}
			i = i->next();
		}
	}

	print_indent(indent);
	printf("n_lineStyles: "); 
	printf("%i\n", n_lineStyles);

	print_indent(indent);
	printf("lineStyles: "); 
	{
		printf("[list of LineStyles]\n");
		LineStyle *item;
		ListItem<LineStyle>* i;
		i = lineStyles.first();
		while( i ) {
			item = i->data();
			if( item ) {
				item->dump(indent+1,ctx);
			}
			i = i->next();
		}
	}

}

void ShapeSetup::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
	
	printf("ShapeSetup"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("hasNewStyles: "); 
	printf("%i\n", hasNewStyles);

	print_indent(indent);
	printf("hasLineStyle: "); 
	printf("%i\n", hasLineStyle);

	print_indent(indent);
	printf("hasFillStyle1: "); 
	printf("%i\n", hasFillStyle1);

	print_indent(indent);
	printf("hasFillStyle0: "); 
	printf("%i\n", hasFillStyle0);

	print_indent(indent);
	printf("hasMoveTo: "); 
	printf("%i\n", hasMoveTo);

	if( hasMoveTo ) {
		
		
	print_indent(indent);
	printf("xybits: "); 
	printf("%i\n", xybits);

	print_indent(indent);
	printf("x: "); 
	printf("%i\n", x);

	print_indent(indent);
	printf("y: "); 
	printf("%i\n", y);

	}

	if( hasFillStyle0 ) {
		
		
	print_indent(indent);
	printf("fillStyle0: "); 
	printf("%i\n", fillStyle0);

	}

	if( hasFillStyle1 ) {
		
		
	print_indent(indent);
	printf("fillStyle1: "); 
	printf("%i\n", fillStyle1);

	}

	if( hasLineStyle ) {
		
		
	print_indent(indent);
	printf("lineStyle: "); 
	printf("%i\n", lineStyle);

	}

	if( hasNewStyles ) {
		
		
	print_indent(indent);
	printf("styles: "); 
	printf("[StyleList]\n");
	styles.dump( indent+1, ctx );

	}

}

void CurveTo::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
	
	printf("CurveTo"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("bits: "); 
	printf("%i\n", bits);

	print_indent(indent);
	printf("x1: "); 
	printf("%i\n", x1);

	print_indent(indent);
	printf("y1: "); 
	printf("%i\n", y1);

	print_indent(indent);
	printf("x2: "); 
	printf("%i\n", x2);

	print_indent(indent);
	printf("y2: "); 
	printf("%i\n", y2);

}

void Shape::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
	
	printf("Shape"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("fillBits: "); 
	printf("%i\n", fillBits);

	print_indent(indent);
	printf("lineBits: "); 
	printf("%i\n", lineBits);

	print_indent(indent);
	printf("edges: "); 
	{
		printf("[list of ShapeItems]\n");
		ShapeItem *item;
		ListItem<ShapeItem>* i;
		i = edges.first();
		while( i ) {
			item = i->data();
			if( item ) {
				item->dump(indent+1,ctx);
			}
			i = i->next();
		}
	}

}

void GradientItem::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
	
	printf("GradientItem"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("position: "); 
	printf("%i\n", position);

	print_indent(indent);
	printf("color: "); 
	printf("[Color]\n");
	color.dump( indent+1, ctx );

}

void Symbol::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
	
	printf("Symbol"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("objectID: "); 
	printf("%i\n", objectID);

	print_indent(indent);
	printf("name: "); 
	printf("%s\n", name?name:"(nil)");

}

void Parameter::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
	
	printf("Parameter"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("reg: "); 
	printf("%i\n", reg);

	print_indent(indent);
	printf("name: "); 
	printf("%s\n", name?name:"(nil)");

}

void UChar::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
	
	printf("UChar"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("value: "); 
	printf("%i\n", value);

}

void UShort::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
	
	printf("UShort"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("value: "); 
	printf("%i\n", value);

}

void ULong::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
	
	printf("ULong"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("value: "); 
	printf("%i\n", value);

}

void Short::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
	
	printf("Short"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("value: "); 
	printf("%i\n", value);

}

void Kerning::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
	
	printf("Kerning"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("a: "); 
	printf("%i\n", a);

	print_indent(indent);
	printf("b: "); 
	printf("%i\n", b);

}

void WideKerning::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
	
	printf("WideKerning"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("a: "); 
	printf("%i\n", a);

	print_indent(indent);
	printf("b: "); 
	printf("%i\n", b);

}

void TextEntry::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
	
	printf("TextEntry"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("glyph: "); 
	printf("%i\n", glyph);

	print_indent(indent);
	printf("advance: "); 
	printf("%i\n", advance);

}

void TextRecord6::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
	
	printf("TextRecord6"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("isSetup: "); 
	printf("%i\n", isSetup);

	if( isSetup ) {
		
		
	print_indent(indent);
	printf("reserved: "); 
	printf("%i\n", reserved);

	print_indent(indent);
	printf("hasFont: "); 
	printf("%i\n", hasFont);

	print_indent(indent);
	printf("hasColor: "); 
	printf("%i\n", hasColor);

	print_indent(indent);
	printf("hasMoveX: "); 
	printf("%i\n", hasMoveX);

	print_indent(indent);
	printf("hasMoveY: "); 
	printf("%i\n", hasMoveY);

	if( hasFont ) {
		
		
	print_indent(indent);
	printf("objectID: "); 
	printf("%i\n", objectID);

	}

	if( hasColor ) {
		
		
	print_indent(indent);
	printf("color: "); 
	printf("[Color]\n");
	color.dump( indent+1, ctx );

	}

	if( hasMoveX ) {
		
		
	print_indent(indent);
	printf("x: "); 
	printf("%i\n", x);

	}

	if( hasMoveY ) {
		
		
	print_indent(indent);
	printf("y: "); 
	printf("%i\n", y);

	}

	if( hasFont ) {
		
		
	print_indent(indent);
	printf("fontHeight: "); 
	printf("%i\n", fontHeight);

	}

	}

	if( !isSetup ) {
		
		
	print_indent(indent);
	printf("nGlyphs: "); 
	printf("%i\n", nGlyphs);

	print_indent(indent);
	printf("glyphs: "); 
	{
		printf("[list of TextEntrys]\n");
		TextEntry *item;
		ListItem<TextEntry>* i;
		i = glyphs.first();
		while( i ) {
			item = i->data();
			if( item ) {
				item->dump(indent+1,ctx);
			}
			i = i->next();
		}
	}

	}

}

void TextRecord7::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
	
	printf("TextRecord7"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("isSetup: "); 
	printf("%i\n", isSetup);

	print_indent(indent);
	printf("reserved: "); 
	printf("%i\n", reserved);

	print_indent(indent);
	printf("hasFont: "); 
	printf("%i\n", hasFont);

	print_indent(indent);
	printf("hasColor: "); 
	printf("%i\n", hasColor);

	print_indent(indent);
	printf("hasMoveX: "); 
	printf("%i\n", hasMoveX);

	print_indent(indent);
	printf("hasMoveY: "); 
	printf("%i\n", hasMoveY);

	if( hasFont ) {
		
		
	print_indent(indent);
	printf("objectID: "); 
	printf("%i\n", objectID);

	}

	if( hasColor ) {
		
		
	print_indent(indent);
	printf("color: "); 
	printf("[Color]\n");
	color.dump( indent+1, ctx );

	}

	if( hasMoveX ) {
		
		
	print_indent(indent);
	printf("x: "); 
	printf("%i\n", x);

	}

	if( hasMoveY ) {
		
		
	print_indent(indent);
	printf("y: "); 
	printf("%i\n", y);

	}

	if( hasFont ) {
		
		
	print_indent(indent);
	printf("fontHeight: "); 
	printf("%i\n", fontHeight);

	}

	if( isSetup ) {
		
		
	print_indent(indent);
	printf("nGlyphs: "); 
	printf("%i\n", nGlyphs);

	print_indent(indent);
	printf("glyphs: "); 
	{
		printf("[list of TextEntrys]\n");
		TextEntry *item;
		ListItem<TextEntry>* i;
		i = glyphs.first();
		while( i ) {
			item = i->data();
			if( item ) {
				item->dump(indent+1,ctx);
			}
			i = i->next();
		}
	}

	}

}

void TextRecord::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
	
	printf("TextRecord"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	if( ctx->swfVersion < 7 ) {
		
	print_indent(indent);
	printf("records: "); 
	{
		printf("[list of TextRecord6s]\n");
		TextRecord6 *item;
		ListItem<TextRecord6>* i;
		i = records.first();
		while( i ) {
			item = i->data();
			if( item ) {
				item->dump(indent+1,ctx);
			}
			i = i->next();
		}
	}

	}

	if( ctx->swfVersion >= 7 ) {
		
	print_indent(indent);
	printf("string: "); 
	printf("[TextRecord7]\n");
	string.dump( indent+1, ctx );

	}

}

void Button::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
	
	printf("Button"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("reserved: "); 
	printf("%i\n", reserved);

	print_indent(indent);
	printf("hitTest: "); 
	printf("%i\n", hitTest);

	print_indent(indent);
	printf("down: "); 
	printf("%i\n", down);

	print_indent(indent);
	printf("over: "); 
	printf("%i\n", over);

	print_indent(indent);
	printf("up: "); 
	printf("%i\n", up);

	if( hitTest || down || over || up ) {
		
	print_indent(indent);
	printf("button: "); 
	printf("%i\n", button);

	print_indent(indent);
	printf("depth: "); 
	printf("%i\n", depth);

	print_indent(indent);
	printf("transform: "); 
	printf("[Transform]\n");
	transform.dump( indent+1, ctx );

	print_indent(indent);
	printf("colorTransform: "); 
	printf("[ColorTransform2]\n");
	colorTransform.dump( indent+1, ctx );

	}

}

void Condition::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
	
	printf("Condition"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("next: "); 
	printf("%i\n", next);

	print_indent(indent);
	printf("key: "); 
	printf("%i\n", key);

	print_indent(indent);
	printf("menuLeave: "); 
	printf("%i\n", menuLeave);

	print_indent(indent);
	printf("menuEnter: "); 
	printf("%i\n", menuEnter);

	print_indent(indent);
	printf("pointerReleaseOutside: "); 
	printf("%i\n", pointerReleaseOutside);

	print_indent(indent);
	printf("pointerDragEnter: "); 
	printf("%i\n", pointerDragEnter);

	print_indent(indent);
	printf("pointerDragLeave: "); 
	printf("%i\n", pointerDragLeave);

	print_indent(indent);
	printf("pointerReleaseInside: "); 
	printf("%i\n", pointerReleaseInside);

	print_indent(indent);
	printf("pointerPush: "); 
	printf("%i\n", pointerPush);

	print_indent(indent);
	printf("pointerLeave: "); 
	printf("%i\n", pointerLeave);

	print_indent(indent);
	printf("pointerEnter: "); 
	printf("%i\n", pointerEnter);

	print_indent(indent);
	printf("actions: "); 
	{
		printf("[list of Actions]\n");
		Action *item;
		ListItem<Action>* i;
		i = actions.first();
		while( i ) {
			item = i->data();
			if( item ) {
				item->dump(indent+1,ctx);
			}
			i = i->next();
		}
	}

}

void Solid::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x00);
	
	
	printf("Solid"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("color: "); 
	printf("[Color]\n");
	color.dump( indent+1, ctx );

}

void LinearGradient::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x10);
	
	
	printf("LinearGradient"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("matrix: "); 
	printf("[Transform]\n");
	matrix.dump( indent+1, ctx );

	print_indent(indent);
	printf("count: "); 
	printf("%i\n", count);

	print_indent(indent);
	printf("gradientColors: "); 
	{
		printf("[list of GradientItems]\n");
		GradientItem *item;
		ListItem<GradientItem>* i;
		i = gradientColors.first();
		while( i ) {
			item = i->data();
			if( item ) {
				item->dump(indent+1,ctx);
			}
			i = i->next();
		}
	}

}

void RadialGradient::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x12);
	
	
	printf("RadialGradient"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("matrix: "); 
	printf("[Transform]\n");
	matrix.dump( indent+1, ctx );

	print_indent(indent);
	printf("count: "); 
	printf("%i\n", count);

	print_indent(indent);
	printf("gradientColors: "); 
	{
		printf("[list of GradientItems]\n");
		GradientItem *item;
		ListItem<GradientItem>* i;
		i = gradientColors.first();
		while( i ) {
			item = i->data();
			if( item ) {
				item->dump(indent+1,ctx);
			}
			i = i->next();
		}
	}

}

void TiledBitmap::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x40);
	
	
	printf("TiledBitmap"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("objectID: "); 
	printf("%i\n", objectID);

	print_indent(indent);
	printf("matrix: "); 
	printf("[Transform]\n");
	matrix.dump( indent+1, ctx );

}

void ClippedBitmap::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x41);
	
	
	printf("ClippedBitmap"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("objectID: "); 
	printf("%i\n", objectID);

	print_indent(indent);
	printf("matrix: "); 
	printf("[Transform]\n");
	matrix.dump( indent+1, ctx );

}

void UnknownTag::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //-1);
	
	
	printf("UnknownTag"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("data: "); 
	printf("(length %i)\n", len );
	if( len && data != NULL ) {
		int i=0;
		while( i<len ) {
			print_indent( indent+1 );
			for( int n=0; n<8 && i<len; n++ ) {
				printf(" %02X",  data[i] );
				i++;
			}
			printf("\n");
		}
	}

}

void End::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x00);
	
	
	printf("End"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void ShowFrame::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x01);
	
	
	printf("ShowFrame"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void DefineShape::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x02);
	
	
	printf("DefineShape"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("objectID: "); 
	printf("%i\n", objectID);

	print_indent(indent);
	printf("bounds: "); 
	printf("[Rectangle]\n");
	bounds.dump( indent+1, ctx );

	print_indent(indent);
	printf("styles: "); 
	printf("[StyleList]\n");
	styles.dump( indent+1, ctx );

	print_indent(indent);
	printf("shapes: "); 
	printf("[Shape]\n");
	shapes.dump( indent+1, ctx );

}

void RemoveObject::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x05);
	
	
	printf("RemoveObject"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("objectID: "); 
	printf("%i\n", objectID);

	print_indent(indent);
	printf("depth: "); 
	printf("%i\n", depth);

}

void DefineBits::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x06);
	
	
	printf("DefineBits"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("objectID: "); 
	printf("%i\n", objectID);

	print_indent(indent);
	printf("data: "); 
	printf("[Rest]\n");
	data.dump( indent+1, ctx );

}

void SetBackgroundColor::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x09);
	
	
	printf("SetBackgroundColor"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("color: "); 
	printf("[Color]\n");
	color.dump( indent+1, ctx );

}

void DefineText::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x0B);
	
	
	printf("DefineText"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("objectID: "); 
	printf("%i\n", objectID);

	print_indent(indent);
	printf("bounds: "); 
	printf("[Rectangle]\n");
	bounds.dump( indent+1, ctx );

	print_indent(indent);
	printf("transform: "); 
	printf("[Transform]\n");
	transform.dump( indent+1, ctx );

	print_indent(indent);
	printf("glyphBits: "); 
	printf("%i\n", glyphBits);

	print_indent(indent);
	printf("advanceBits: "); 
	printf("%i\n", advanceBits);

	print_indent(indent);
	printf("records: "); 
	{
		printf("[list of TextRecords]\n");
		TextRecord *item;
		ListItem<TextRecord>* i;
		i = records.first();
		while( i ) {
			item = i->data();
			if( item ) {
				item->dump(indent+1,ctx);
			}
			i = i->next();
		}
	}

}

void DoAction::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x0C);
	
	
	printf("DoAction"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("actions: "); 
	{
		printf("[list of Actions]\n");
		Action *item;
		ListItem<Action>* i;
		i = actions.first();
		while( i ) {
			item = i->data();
			if( item ) {
				item->dump(indent+1,ctx);
			}
			i = i->next();
		}
	}

}

void DefineFontInfo::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x0D);
	
	
	printf("DefineFontInfo"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("objectID: "); 
	printf("%i\n", objectID);

	print_indent(indent);
	printf("nameLength: "); 
	printf("%i\n", nameLength);

	print_indent(indent);
	printf("nameData: "); 
	printf("(length %i)\n", nameLength );
	if( nameLength && nameData != NULL ) {
		int i=0;
		while( i<nameLength ) {
			print_indent( indent+1 );
			for( int n=0; n<8 && i<nameLength; n++ ) {
				printf(" %02X",  nameData[i] );
				i++;
			}
			printf("\n");
		}
	}

	print_indent(indent);
	printf("reserved: "); 
	printf("%i\n", reserved);

	print_indent(indent);
	printf("smallTextOrUnicode: "); 
	printf("%i\n", smallTextOrUnicode);

	print_indent(indent);
	printf("isShiftJIS: "); 
	printf("%i\n", isShiftJIS);

	print_indent(indent);
	printf("isANSII: "); 
	printf("%i\n", isANSII);

	print_indent(indent);
	printf("isItalic: "); 
	printf("%i\n", isItalic);

	print_indent(indent);
	printf("isBold: "); 
	printf("%i\n", isBold);

	print_indent(indent);
	printf("isWide: "); 
	printf("%i\n", isWide);

	if( ctx->swfVersion>=6 ) {
		
	print_indent(indent);
	printf("language: "); 
	printf("%i\n", language);

	}

	print_indent(indent);
	printf("map: "); 
	printf("[Rest]\n");
	map.dump( indent+1, ctx );

}

void DefineFontInfo2::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x3E);
	
	
	printf("DefineFontInfo2"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("objectID: "); 
	printf("%i\n", objectID);

	print_indent(indent);
	printf("nameLength: "); 
	printf("%i\n", nameLength);

	print_indent(indent);
	printf("nameData: "); 
	printf("(length %i)\n", nameLength );
	if( nameLength && nameData != NULL ) {
		int i=0;
		while( i<nameLength ) {
			print_indent( indent+1 );
			for( int n=0; n<8 && i<nameLength; n++ ) {
				printf(" %02X",  nameData[i] );
				i++;
			}
			printf("\n");
		}
	}

	print_indent(indent);
	printf("reserved: "); 
	printf("%i\n", reserved);

	print_indent(indent);
	printf("smallTextOrUnicode: "); 
	printf("%i\n", smallTextOrUnicode);

	print_indent(indent);
	printf("isShiftJIS: "); 
	printf("%i\n", isShiftJIS);

	print_indent(indent);
	printf("isANSII: "); 
	printf("%i\n", isANSII);

	print_indent(indent);
	printf("isItalic: "); 
	printf("%i\n", isItalic);

	print_indent(indent);
	printf("isBold: "); 
	printf("%i\n", isBold);

	print_indent(indent);
	printf("isWide: "); 
	printf("%i\n", isWide);

	if( ctx->swfVersion>=6 ) {
		
	print_indent(indent);
	printf("language: "); 
	printf("%i\n", language);

	}

	print_indent(indent);
	printf("map: "); 
	printf("[Rest]\n");
	map.dump( indent+1, ctx );

}

void SoundStreamHead::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x12);
	
	
	printf("SoundStreamHead"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("reserved: "); 
	printf("%i\n", reserved);

	print_indent(indent);
	printf("playbackRate: "); 
	printf("%i\n", playbackRate);

	print_indent(indent);
	printf("playbackSize: "); 
	printf("%i\n", playbackSize);

	print_indent(indent);
	printf("playbackStereo: "); 
	printf("%i\n", playbackStereo);

	print_indent(indent);
	printf("compression: "); 
	printf("%i\n", compression);

	print_indent(indent);
	printf("soundRate: "); 
	printf("%i\n", soundRate);

	print_indent(indent);
	printf("soundSize: "); 
	printf("%i\n", soundSize);

	print_indent(indent);
	printf("soundStereo: "); 
	printf("%i\n", soundStereo);

	print_indent(indent);
	printf("sampleSize: "); 
	printf("%i\n", sampleSize);

	if( compression==2 ) {
		
	print_indent(indent);
	printf("latencySeek: "); 
	printf("[Rest]\n");
	latencySeek.dump( indent+1, ctx );

	}

}

void DefineBitsLossless::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x14);
	
	
	printf("DefineBitsLossless"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("objectID: "); 
	printf("%i\n", objectID);

	print_indent(indent);
	printf("format: "); 
	printf("%i\n", format);

	print_indent(indent);
	printf("width: "); 
	printf("%i\n", width);

	print_indent(indent);
	printf("height: "); 
	printf("%i\n", height);

	print_indent(indent);
	printf("data: "); 
	printf("[Rest]\n");
	data.dump( indent+1, ctx );

}

void DefineBitsJPEG2::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x15);
	
	
	printf("DefineBitsJPEG2"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("objectID: "); 
	printf("%i\n", objectID);

	print_indent(indent);
	printf("data: "); 
	printf("[Rest]\n");
	data.dump( indent+1, ctx );

}

void DefineBitsLossless2::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x24);
	
	
	printf("DefineBitsLossless2"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("objectID: "); 
	printf("%i\n", objectID);

	print_indent(indent);
	printf("format: "); 
	printf("%i\n", format);

	print_indent(indent);
	printf("width: "); 
	printf("%i\n", width);

	print_indent(indent);
	printf("height: "); 
	printf("%i\n", height);

	print_indent(indent);
	printf("data: "); 
	printf("[Rest]\n");
	data.dump( indent+1, ctx );

}

void PlaceObject2::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x1A);
	
	
	printf("PlaceObject2"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("hasEventHandler: "); 
	printf("%i\n", hasEventHandler);

	print_indent(indent);
	printf("hasClipDepth: "); 
	printf("%i\n", hasClipDepth);

	print_indent(indent);
	printf("hasName: "); 
	printf("%i\n", hasName);

	print_indent(indent);
	printf("hasMorph: "); 
	printf("%i\n", hasMorph);

	print_indent(indent);
	printf("hasColorTransform: "); 
	printf("%i\n", hasColorTransform);

	print_indent(indent);
	printf("hasTransform: "); 
	printf("%i\n", hasTransform);

	print_indent(indent);
	printf("hasID: "); 
	printf("%i\n", hasID);

	print_indent(indent);
	printf("replace: "); 
	printf("%i\n", replace);

	print_indent(indent);
	printf("depth: "); 
	printf("%i\n", depth);

	if( hasID ) {
		
		
	print_indent(indent);
	printf("objectID: "); 
	printf("%i\n", objectID);

	}

	if( hasTransform ) {
		
		
	print_indent(indent);
	printf("transform: "); 
	printf("[Transform]\n");
	transform.dump( indent+1, ctx );

	}

	if( hasColorTransform ) {
		
		
	print_indent(indent);
	printf("colorTransform: "); 
	printf("[ColorTransform2]\n");
	colorTransform.dump( indent+1, ctx );

	}

	if( hasMorph ) {
		
		
	print_indent(indent);
	printf("morph: "); 
	printf("%i\n", morph);

	}

	if( hasName ) {
		
		
	print_indent(indent);
	printf("name: "); 
	printf("%s\n", name?name:"(nil)");

	}

	if( hasClipDepth ) {
		
		
	print_indent(indent);
	printf("clipDepth: "); 
	printf("%i\n", clipDepth);

	}

	if( hasEventHandler ) {
		
		
	print_indent(indent);
	printf("events: "); 
	printf("[Rest]\n");
	events.dump( indent+1, ctx );

	}

}

void RemoveObject2::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x1C);
	
	
	printf("RemoveObject2"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("depth: "); 
	printf("%i\n", depth);

}

void DefineEditText::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x25);
	
	
	printf("DefineEditText"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("objectID: "); 
	printf("%i\n", objectID);

	print_indent(indent);
	printf("size: "); 
	printf("[Rectangle]\n");
	size.dump( indent+1, ctx );

	print_indent(indent);
	printf("hasText: "); 
	printf("%i\n", hasText);

	print_indent(indent);
	printf("wordWrap: "); 
	printf("%i\n", wordWrap);

	print_indent(indent);
	printf("multiLine: "); 
	printf("%i\n", multiLine);

	print_indent(indent);
	printf("password: "); 
	printf("%i\n", password);

	print_indent(indent);
	printf("readOnly: "); 
	printf("%i\n", readOnly);

	print_indent(indent);
	printf("hasColor: "); 
	printf("%i\n", hasColor);

	print_indent(indent);
	printf("hasMaxLength: "); 
	printf("%i\n", hasMaxLength);

	print_indent(indent);
	printf("hasFont: "); 
	printf("%i\n", hasFont);

	print_indent(indent);
	printf("reserved: "); 
	printf("%i\n", reserved);

	print_indent(indent);
	printf("autoSize: "); 
	printf("%i\n", autoSize);

	print_indent(indent);
	printf("hasLayout: "); 
	printf("%i\n", hasLayout);

	print_indent(indent);
	printf("notSelectable: "); 
	printf("%i\n", notSelectable);

	print_indent(indent);
	printf("hasBorder: "); 
	printf("%i\n", hasBorder);

	print_indent(indent);
	printf("reserved2: "); 
	printf("%i\n", reserved2);

	print_indent(indent);
	printf("isHTML: "); 
	printf("%i\n", isHTML);

	print_indent(indent);
	printf("useOutlines: "); 
	printf("%i\n", useOutlines);

	if( hasFont ) {
		
		
	print_indent(indent);
	printf("fontRef: "); 
	printf("%i\n", fontRef);

	print_indent(indent);
	printf("fontHeight: "); 
	printf("%i\n", fontHeight);

	}

	if( hasColor ) {
		
		
	print_indent(indent);
	printf("color: "); 
	printf("[ColorRGBA]\n");
	color.dump( indent+1, ctx );

	}

	if( hasMaxLength ) {
		
		
	print_indent(indent);
	printf("maxLength: "); 
	printf("%i\n", maxLength);

	}

	if( hasLayout ) {
		
		
	print_indent(indent);
	printf("align: "); 
	printf("%i\n", align);

	print_indent(indent);
	printf("leftMargin: "); 
	printf("%i\n", leftMargin);

	print_indent(indent);
	printf("rightMargin: "); 
	printf("%i\n", rightMargin);

	print_indent(indent);
	printf("indent: "); 
	printf("%i\n", indent);

	print_indent(indent);
	printf("leading: "); 
	printf("%i\n", leading);

	}

	print_indent(indent);
	printf("variableName: "); 
	printf("%s\n", variableName?variableName:"(nil)");

	if( hasText ) {
		
		
	print_indent(indent);
	printf("initialText: "); 
	printf("%s\n", initialText?initialText:"(nil)");

	}

}

void DefineSprite::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x27);
	
	
	printf("DefineSprite"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("objectID: "); 
	printf("%i\n", objectID);

	print_indent(indent);
	printf("frames: "); 
	printf("%i\n", frames);

	print_indent(indent);
	printf("tags: "); 
	{
		printf("[list of Tags]\n");
		Tag *item;
		ListItem<Tag>* i;
		i = tags.first();
		while( i ) {
			item = i->data();
			if( item ) {
				item->dump(indent+1,ctx);
			}
			i = i->next();
		}
	}

}

void FrameLabel::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x2B);
	
	
	printf("FrameLabel"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("label: "); 
	printf("%s\n", label?label:"(nil)");

	print_indent(indent);
	printf("flags: "); 
	printf("[Rest]\n");
	flags.dump( indent+1, ctx );

}

void SoundStreamHead2::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x2D);
	
	
	printf("SoundStreamHead2"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("reserved: "); 
	printf("%i\n", reserved);

	print_indent(indent);
	printf("playbackRate: "); 
	printf("%i\n", playbackRate);

	print_indent(indent);
	printf("playbackSize: "); 
	printf("%i\n", playbackSize);

	print_indent(indent);
	printf("playbackStereo: "); 
	printf("%i\n", playbackStereo);

	print_indent(indent);
	printf("compression: "); 
	printf("%i\n", compression);

	print_indent(indent);
	printf("soundRate: "); 
	printf("%i\n", soundRate);

	print_indent(indent);
	printf("soundSize: "); 
	printf("%i\n", soundSize);

	print_indent(indent);
	printf("soundStereo: "); 
	printf("%i\n", soundStereo);

	print_indent(indent);
	printf("sampleSize: "); 
	printf("%i\n", sampleSize);

	if( compression==2 ) {
		
	print_indent(indent);
	printf("latencySeek: "); 
	printf("[Rest]\n");
	latencySeek.dump( indent+1, ctx );

	}

}

void DefineFont::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x0A);
	
	
	printf("DefineFont"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("objectID: "); 
	printf("%i\n", objectID);

	print_indent(indent);
	printf("glyphs: "); 
	printf("[GlyphList]\n");
	glyphs.dump( indent+1, ctx );

}

void DefineFont2::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x30);
	
	
	printf("DefineFont2"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("objectID: "); 
	printf("%i\n", objectID);

	print_indent(indent);
	printf("hasLayout: "); 
	printf("%i\n", hasLayout);

	print_indent(indent);
	printf("isShiftJIS: "); 
	printf("%i\n", isShiftJIS);

	print_indent(indent);
	printf("isUnicode: "); 
	printf("%i\n", isUnicode);

	print_indent(indent);
	printf("isANSII: "); 
	printf("%i\n", isANSII);

	print_indent(indent);
	printf("wideGlyphOffsets: "); 
	printf("%i\n", wideGlyphOffsets);

	print_indent(indent);
	printf("wideMap: "); 
	printf("%i\n", wideMap);

	print_indent(indent);
	printf("italic: "); 
	printf("%i\n", italic);

	print_indent(indent);
	printf("bold: "); 
	printf("%i\n", bold);

	print_indent(indent);
	printf("language: "); 
	printf("%i\n", language);

	print_indent(indent);
	printf("name: "); 
	printf("%s\n", name?name:"(nil)");

	print_indent(indent);
	printf("glyphCount: "); 
	printf("%i\n", glyphCount);

	print_indent(indent);
	printf("glyphs: "); 
	printf("[GlyphList]\n");
	glyphs.dump( indent+1, ctx );

	if( hasLayout ) {
		
		
	print_indent(indent);
	printf("ascent: "); 
	printf("%i\n", ascent);

	print_indent(indent);
	printf("descent: "); 
	printf("%i\n", descent);

	print_indent(indent);
	printf("leading: "); 
	printf("%i\n", leading);

	print_indent(indent);
	printf("advance: "); 
	{
		printf("[list of Shorts]\n");
		Short *item;
		ListItem<Short>* i;
		i = advance.first();
		while( i ) {
			item = i->data();
			if( item ) {
				item->dump(indent+1,ctx);
			}
			i = i->next();
		}
	}

	print_indent(indent);
	printf("bounds: "); 
	{
		printf("[list of Rectangles]\n");
		Rectangle *item;
		ListItem<Rectangle>* i;
		i = bounds.first();
		while( i ) {
			item = i->data();
			if( item ) {
				item->dump(indent+1,ctx);
			}
			i = i->next();
		}
	}

	print_indent(indent);
	printf("kerningCount: "); 
	printf("%i\n", kerningCount);

	if( wideMap ) {
		
		
	print_indent(indent);
	printf("wideKerning: "); 
	{
		printf("[list of WideKernings]\n");
		WideKerning *item;
		ListItem<WideKerning>* i;
		i = wideKerning.first();
		while( i ) {
			item = i->data();
			if( item ) {
				item->dump(indent+1,ctx);
			}
			i = i->next();
		}
	}

	}

	if( !wideMap ) {
		
		
	print_indent(indent);
	printf("kerning: "); 
	{
		printf("[list of Kernings]\n");
		Kerning *item;
		ListItem<Kerning>* i;
		i = kerning.first();
		while( i ) {
			item = i->data();
			if( item ) {
				item->dump(indent+1,ctx);
			}
			i = i->next();
		}
	}

	}

	}

}

void DefineButton2::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x22);
	
	
	printf("DefineButton2"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("objectID: "); 
	printf("%i\n", objectID);

	print_indent(indent);
	printf("reserved: "); 
	printf("%i\n", reserved);

	print_indent(indent);
	printf("menu: "); 
	printf("%i\n", menu);

	print_indent(indent);
	printf("buttonsSize: "); 
	printf("%i\n", buttonsSize);

	print_indent(indent);
	printf("buttons: "); 
	{
		printf("[list of Buttons]\n");
		Button *item;
		ListItem<Button>* i;
		i = buttons.first();
		while( i ) {
			item = i->data();
			if( item ) {
				item->dump(indent+1,ctx);
			}
			i = i->next();
		}
	}

	print_indent(indent);
	printf("conditions: "); 
	{
		printf("[list of Conditions]\n");
		Condition *item;
		ListItem<Condition>* i;
		i = conditions.first();
		while( i ) {
			item = i->data();
			if( item ) {
				item->dump(indent+1,ctx);
			}
			i = i->next();
		}
	}

}

void Export::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x38);
	
	
	printf("Export"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("count: "); 
	printf("%i\n", count);

	print_indent(indent);
	printf("symbols: "); 
	{
		printf("[list of Symbols]\n");
		Symbol *item;
		ListItem<Symbol>* i;
		i = symbols.first();
		while( i ) {
			item = i->data();
			if( item ) {
				item->dump(indent+1,ctx);
			}
			i = i->next();
		}
	}

}

void Import::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x39);
	
	
	printf("Import"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("url: "); 
	printf("%s\n", url?url:"(nil)");

	print_indent(indent);
	printf("count: "); 
	printf("%i\n", count);

	print_indent(indent);
	printf("symbols: "); 
	{
		printf("[list of Symbols]\n");
		Symbol *item;
		ListItem<Symbol>* i;
		i = symbols.first();
		while( i ) {
			item = i->data();
			if( item ) {
				item->dump(indent+1,ctx);
			}
			i = i->next();
		}
	}

}

void DoInitAction::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x3B);
	
	
	printf("DoInitAction"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("sprite: "); 
	printf("%i\n", sprite);

	print_indent(indent);
	printf("actions: "); 
	{
		printf("[list of Actions]\n");
		Action *item;
		ListItem<Action>* i;
		i = actions.first();
		while( i ) {
			item = i->data();
			if( item ) {
				item->dump(indent+1,ctx);
			}
			i = i->next();
		}
	}

}

void SoundStreamBlock::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x13);
	
	
	printf("SoundStreamBlock"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("data: "); 
	printf("(length %i)\n", len );
	if( len && data != NULL ) {
		int i=0;
		while( i<len ) {
			print_indent( indent+1 );
			for( int n=0; n<8 && i<len; n++ ) {
				printf(" %02X",  data[i] );
				i++;
			}
			printf("\n");
		}
	}

}

void DefineVideoStream::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x3C);
	
	
	printf("DefineVideoStream"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("objectID: "); 
	printf("%i\n", objectID);

	print_indent(indent);
	printf("frames: "); 
	printf("%i\n", frames);

	print_indent(indent);
	printf("width: "); 
	printf("%i\n", width);

	print_indent(indent);
	printf("height: "); 
	printf("%i\n", height);

	print_indent(indent);
	printf("reserved: "); 
	printf("%i\n", reserved);

	print_indent(indent);
	printf("deblocking: "); 
	printf("%i\n", deblocking);

	print_indent(indent);
	printf("smoothing: "); 
	printf("%i\n", smoothing);

	print_indent(indent);
	printf("codec: "); 
	printf("%i\n", codec);

}

void VideoFrame::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x3D);
	
	
	printf("VideoFrame"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("objectID: "); 
	printf("%i\n", objectID);

	print_indent(indent);
	printf("frame: "); 
	printf("%i\n", frame);

	print_indent(indent);
	printf("data: "); 
	printf("[Rest]\n");
	data.dump( indent+1, ctx );

}

void StackString::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x00);
	
	
	printf("StackString"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("value: "); 
	printf("%s\n", value?value:"(nil)");

}

void StackFloat::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x01);
	
	
	printf("StackFloat"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("value: "); 
}

void StackNull::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x02);
	
	
	printf("StackNull"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void StackUndefined::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x03);
	
	
	printf("StackUndefined"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void StackRegister::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x04);
	
	
	printf("StackRegister"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("reg: "); 
	printf("%i\n", reg);

}

void StackBoolean::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x05);
	
	
	printf("StackBoolean"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("value: "); 
	printf("%i\n", value);

}

void StackDouble::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x06);
	
	
	printf("StackDouble"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("value: "); 
}

void StackInteger::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x07);
	
	
	printf("StackInteger"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("value: "); 
}

void StackDictionaryLookup::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x08);
	
	
	printf("StackDictionaryLookup"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("index: "); 
	printf("%i\n", index);

}

void StackLargeDictionaryLookup::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x09);
	
	
	printf("StackLargeDictionaryLookup"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("index: "); 
	printf("%i\n", index);

}

void UnknownAction::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //-1);
	
	
	printf("UnknownAction"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("data: "); 
	printf("(length %i)\n", len );
	if( len && data != NULL ) {
		int i=0;
		while( i<len ) {
			print_indent( indent+1 );
			for( int n=0; n<8 && i<len; n++ ) {
				printf(" %02X",  data[i] );
				i++;
			}
			printf("\n");
		}
	}

}

void EndAction::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x00);
	
	
	printf("EndAction"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void NextFrame::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x04);
	
	
	printf("NextFrame"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void PreviousFrame::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x05);
	
	
	printf("PreviousFrame"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void Play::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x06);
	
	
	printf("Play"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void Stop::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x07);
	
	
	printf("Stop"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void ToggleQuality::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x08);
	
	
	printf("ToggleQuality"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void StopSound::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x09);
	
	
	printf("StopSound"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void AddCast::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x0A);
	
	
	printf("AddCast"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void Substract::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x0B);
	
	
	printf("Substract"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void Mulitply::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x0C);
	
	
	printf("Mulitply"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void Divide::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x0D);
	
	
	printf("Divide"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void EqualCast::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x0E);
	
	
	printf("EqualCast"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void LessThanCast::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x0F);
	
	
	printf("LessThanCast"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void LogicalAND::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x10);
	
	
	printf("LogicalAND"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void LogicalOR::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x11);
	
	
	printf("LogicalOR"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void LogicalNOT::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x12);
	
	
	printf("LogicalNOT"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void StringEqual::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x13);
	
	
	printf("StringEqual"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void StringLength::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x14);
	
	
	printf("StringLength"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void SubString::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x15);
	
	
	printf("SubString"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void Pop::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x17);
	
	
	printf("Pop"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void IntegralPart::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x18);
	
	
	printf("IntegralPart"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void GetVariable::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x1C);
	
	
	printf("GetVariable"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void SetVariable::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x1D);
	
	
	printf("SetVariable"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void SetTargetDynamic::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x20);
	
	
	printf("SetTargetDynamic"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void ConcatenateString::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x21);
	
	
	printf("ConcatenateString"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void GetProperty::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x22);
	
	
	printf("GetProperty"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void SetProperty::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x23);
	
	
	printf("SetProperty"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void DuplicateSprite::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x24);
	
	
	printf("DuplicateSprite"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void RemoveSprite::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x25);
	
	
	printf("RemoveSprite"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void Trace::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x26);
	
	
	printf("Trace"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void StartDrag::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x27);
	
	
	printf("StartDrag"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void StopDrag::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x28);
	
	
	printf("StopDrag"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void StringLessThan::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x29);
	
	
	printf("StringLessThan"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void Throw::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x2A);
	
	
	printf("Throw"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void CastObject::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x2B);
	
	
	printf("CastObject"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void Implements::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x2C);
	
	
	printf("Implements"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void Random::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x30);
	
	
	printf("Random"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void MultibyteStringLength::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x31);
	
	
	printf("MultibyteStringLength"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void ORD::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x32);
	
	
	printf("ORD"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void CHR::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x33);
	
	
	printf("CHR"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void GetTimer::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x34);
	
	
	printf("GetTimer"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void MultibyteSubString::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x35);
	
	
	printf("MultibyteSubString"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void MultibyteORD::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x36);
	
	
	printf("MultibyteORD"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void MultibyteCHR::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x37);
	
	
	printf("MultibyteCHR"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void Delete::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x3A);
	
	
	printf("Delete"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void DeleteAll::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x3B);
	
	
	printf("DeleteAll"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void SetLocalVariable::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x3C);
	
	
	printf("SetLocalVariable"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void CallFunction::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x3D);
	
	
	printf("CallFunction"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void Return::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x3E);
	
	
	printf("Return"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void Modulo::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x3F);
	
	
	printf("Modulo"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void New::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x40);
	
	
	printf("New"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void DeclareLocalVariable::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x41);
	
	
	printf("DeclareLocalVariable"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void DeclareArray::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x42);
	
	
	printf("DeclareArray"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void DeclareObject::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x43);
	
	
	printf("DeclareObject"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void TypeOf::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x44);
	
	
	printf("TypeOf"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void GetTarget::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x45);
	
	
	printf("GetTarget"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void Enumerate::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x46);
	
	
	printf("Enumerate"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void AddTyped::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x47);
	
	
	printf("AddTyped"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void LessThanTyped::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x48);
	
	
	printf("LessThanTyped"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void EqualTyped::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x49);
	
	
	printf("EqualTyped"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void DefineNumber::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x4A);
	
	
	printf("DefineNumber"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void DefineString::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x4B);
	
	
	printf("DefineString"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void Duplicate::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x4C);
	
	
	printf("Duplicate"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void Swap::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x4D);
	
	
	printf("Swap"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void GetMember::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x4E);
	
	
	printf("GetMember"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void SetMember::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x4F);
	
	
	printf("SetMember"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void Increment::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x50);
	
	
	printf("Increment"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void Decrement::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x51);
	
	
	printf("Decrement"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void CallMethod::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x52);
	
	
	printf("CallMethod"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void NewMethod::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x53);
	
	
	printf("NewMethod"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void InstanceOf::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x54);
	
	
	printf("InstanceOf"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void EnumerateObject::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x55);
	
	
	printf("EnumerateObject"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void AND::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x60);
	
	
	printf("AND"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void OR::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x61);
	
	
	printf("OR"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void XOR::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x62);
	
	
	printf("XOR"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void ShiftLeft::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x63);
	
	
	printf("ShiftLeft"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void ShiftRight::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x64);
	
	
	printf("ShiftRight"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void ShiftRightUnsigned::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x65);
	
	
	printf("ShiftRightUnsigned"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void StrictEqual::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x66);
	
	
	printf("StrictEqual"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void GreaterThanTyped::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x67);
	
	
	printf("GreaterThanTyped"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void StringGreaterThan::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x68);
	
	
	printf("StringGreaterThan"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void Extends::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x69);
	
	
	printf("Extends"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void GotoFrame::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x81);
	
	
	printf("GotoFrame"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("frame: "); 
	printf("%i\n", frame);

}

void GetURL::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x83);
	
	
	printf("GetURL"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("url: "); 
	printf("%s\n", url?url:"(nil)");

	print_indent(indent);
	printf("target: "); 
	printf("%s\n", target?target:"(nil)");

}

void StoreRegister::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x87);
	
	
	printf("StoreRegister"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("reg: "); 
	printf("%i\n", reg);

}

void Dictionary::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x88);
	
	
	printf("Dictionary"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("length: "); 
	printf("%i\n", length);

	print_indent(indent);
	printf("strings: "); 
	{
		printf("[list of Strings]\n");
		String *item;
		ListItem<String>* i;
		i = strings.first();
		while( i ) {
			item = i->data();
			if( item ) {
				item->dump(indent+1,ctx);
			}
			i = i->next();
		}
	}

}

void WaitForFrame::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x8A);
	
	
	printf("WaitForFrame"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("frame: "); 
	printf("%i\n", frame);

	print_indent(indent);
	printf("skip: "); 
	printf("%i\n", skip);

}

void SetTarget::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x8B);
	
	
	printf("SetTarget"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("label: "); 
	printf("%s\n", label?label:"(nil)");

}

void GotoLabel::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x8C);
	
	
	printf("GotoLabel"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("label: "); 
	printf("%s\n", label?label:"(nil)");

}

void WaitForFrameDynamic::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x8D);
	
	
	printf("WaitForFrameDynamic"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("frame: "); 
	printf("%i\n", frame);

	print_indent(indent);
	printf("skip: "); 
	printf("%i\n", skip);

}

void DeclareFunction2::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x8E);
	
	
	printf("DeclareFunction2"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("name: "); 
	printf("%s\n", name?name:"(nil)");

	print_indent(indent);
	printf("argc: "); 
	printf("%i\n", argc);

	print_indent(indent);
	printf("regc: "); 
	printf("%i\n", regc);

	print_indent(indent);
	printf("preloadThis: "); 
	printf("%i\n", preloadThis);

	print_indent(indent);
	printf("suppressThis: "); 
	printf("%i\n", suppressThis);

	print_indent(indent);
	printf("preloadArguments: "); 
	printf("%i\n", preloadArguments);

	print_indent(indent);
	printf("suppressArguments: "); 
	printf("%i\n", suppressArguments);

	print_indent(indent);
	printf("preloadSuper: "); 
	printf("%i\n", preloadSuper);

	print_indent(indent);
	printf("suppressSuper: "); 
	printf("%i\n", suppressSuper);

	print_indent(indent);
	printf("preloadRoot: "); 
	printf("%i\n", preloadRoot);

	print_indent(indent);
	printf("preloadParent: "); 
	printf("%i\n", preloadParent);

	print_indent(indent);
	printf("preloadGlobal: "); 
	printf("%i\n", preloadGlobal);

	print_indent(indent);
	printf("reserved: "); 
	printf("%i\n", reserved);

	print_indent(indent);
	printf("args: "); 
	{
		printf("[list of Parameters]\n");
		Parameter *item;
		ListItem<Parameter>* i;
		i = args.first();
		while( i ) {
			item = i->data();
			if( item ) {
				item->dump(indent+1,ctx);
			}
			i = i->next();
		}
	}

	print_indent(indent);
	printf("length: "); 
	printf("%i\n", length);

	print_indent(indent);
	printf("actions: "); 
	{
		printf("[list of Actions]\n");
		Action *item;
		ListItem<Action>* i;
		i = actions.first();
		while( i ) {
			item = i->data();
			if( item ) {
				item->dump(indent+1,ctx);
			}
			i = i->next();
		}
	}

}

void Try::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x8F);
	
	
	printf("Try"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("reserved: "); 
	printf("%i\n", reserved);

	print_indent(indent);
	printf("catchInRegister: "); 
	printf("%i\n", catchInRegister);

	print_indent(indent);
	printf("doFinally: "); 
	printf("%i\n", doFinally);

	print_indent(indent);
	printf("doCatch: "); 
	printf("%i\n", doCatch);

	print_indent(indent);
	printf("trySize: "); 
	printf("%i\n", trySize);

	print_indent(indent);
	printf("catchSize: "); 
	printf("%i\n", catchSize);

	print_indent(indent);
	printf("finallySize: "); 
	printf("%i\n", finallySize);

	if( catchInRegister ) {
		
		
	print_indent(indent);
	printf("reg: "); 
	printf("%i\n", reg);

	}

}

void With::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x94);
	
	
	printf("With"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("size: "); 
	printf("%i\n", size);

}

void PushData::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x96);
	
	
	printf("PushData"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("items: "); 
	{
		printf("[list of StackItems]\n");
		StackItem *item;
		ListItem<StackItem>* i;
		i = items.first();
		while( i ) {
			item = i->data();
			if( item ) {
				item->dump(indent+1,ctx);
			}
			i = i->next();
		}
	}

}

void GetURL2::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x9A);
	
	
	printf("GetURL2"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("method: "); 
	printf("%i\n", method);

}

void DeclareFunction::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x9B);
	
	
	printf("DeclareFunction"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("name: "); 
	printf("%s\n", name?name:"(nil)");

	print_indent(indent);
	printf("argc: "); 
	printf("%i\n", argc);

	print_indent(indent);
	printf("args: "); 
	{
		printf("[list of Strings]\n");
		String *item;
		ListItem<String>* i;
		i = args.first();
		while( i ) {
			item = i->data();
			if( item ) {
				item->dump(indent+1,ctx);
			}
			i = i->next();
		}
	}

	print_indent(indent);
	printf("length: "); 
	printf("%i\n", length);

}

void BranchAlways::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x99);
	
	
	printf("BranchAlways"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("byteOffset: "); 
	printf("%i\n", byteOffset);

}

void BranchIfTrue::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x9D);
	
	
	printf("BranchIfTrue"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("byteOffset: "); 
	printf("%i\n", byteOffset);

}

void CallFrame::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x9E);
	
	
	printf("CallFrame"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
}

void GotoExpression::dump( int indent, Context *ctx ) {
	print_indent(indent);
	
		printf("[%02X] ", type ); //0x9F);
	
	
	printf("GotoExpression"); // (sz %i)", getSize( ctx ) );
	
	printf("\n");
	indent++;
	
	print_indent(indent);
	printf("play: "); 
	printf("%i\n", play);

}


}

