
#ifndef SWF_H
#define SWF_H

#include <SWFReader.h>
#include <SWFTag.h>
#include <SWFAction.h>
#include <SWFFilter.h>
#include <SWFList.h>
#include <SWFStyle.h>
#include <SWFShapeItem.h>
#include <SWFStackItem.h>
#include <SWFGlyphList.h>

namespace SWF {

struct Context {
	public:
		Context();
	
		int swfVersion;
		bool transientPropsToXML;
		bool debugTrace;
		bool exportAssets;
		bool quiet;
		
		bool isLast;
		char tagVersion;
		bool alpha;
		bool many_shapes;
		
		int fillBits;
		int lineBits;
		unsigned char glyphBits;
		unsigned char advanceBits;
		unsigned char glyphBits2;
		unsigned char advanceBits2;
		bool wideGlyphOffsets;
		bool wideMap;
		unsigned short glyphCount;
		
};


class Rectangle : public Item {
	public:
		Rectangle();
		~Rectangle();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Rectangle* get( Reader *r, int end, Context *ctx );
		static Rectangle* getByName( const char *name );

		int getbits();
			void setbits( int );
	int getleft();
			void setleft( int );
	int getright();
			void setright( int );
	int gettop();
			void settop( int );
	int getbottom();
			void setbottom( int );
	

	protected:
		int bits; // integer
int left; // integer
int right; // integer
int top; // integer
int bottom; // integer

};

class Color : public Item {
	public:
		Color();
		~Color();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Color* get( Reader *r, int end, Context *ctx );
		static Color* getByName( const char *name );

		unsigned char getred();
			void setred( unsigned char );
	unsigned char getgreen();
			void setgreen( unsigned char );
	unsigned char getblue();
			void setblue( unsigned char );
	unsigned char getalpha();
			void setalpha( unsigned char );
	

	protected:
		unsigned char red; // byte
unsigned char green; // byte
unsigned char blue; // byte
unsigned char alpha; // byte

};

class String : public Item {
	public:
		String();
		~String();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static String* get( Reader *r, int end, Context *ctx );
		static String* getByName( const char *name );

		char * getvalue();
			void setvalue( char * );
	

	protected:
		char * value; // string

};

class Transform : public Item {
	public:
		Transform();
		~Transform();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Transform* get( Reader *r, int end, Context *ctx );
		static Transform* getByName( const char *name );

		bool getscaled();
			void setscaled( bool );
	int getbitsScale();
			void setbitsScale( int );
	float getscaleX();
			void setscaleX( float );
	float getscaleY();
			void setscaleY( float );
	bool getskewed();
			void setskewed( bool );
	int getbitsSkew();
			void setbitsSkew( int );
	float getskewX();
			void setskewX( float );
	float getskewY();
			void setskewY( float );
	int getbitsTranslate();
			void setbitsTranslate( int );
	int gettransX();
			void settransX( int );
	int gettransY();
			void settransY( int );
	

	protected:
		bool scaled; // bit
int bitsScale; // integer
float scaleX; // fixedpoint
float scaleY; // fixedpoint
bool skewed; // bit
int bitsSkew; // integer
float skewX; // fixedpoint
float skewY; // fixedpoint
int bitsTranslate; // integer
int transX; // integer
int transY; // integer

};

class ColorTransform2 : public Item {
	public:
		ColorTransform2();
		~ColorTransform2();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static ColorTransform2* get( Reader *r, int end, Context *ctx );
		static ColorTransform2* getByName( const char *name );

		bool gethasOffset();
			void sethasOffset( bool );
	bool gethasFactor();
			void sethasFactor( bool );
	int getbits();
			void setbits( int );
	int getfactorRed();
			void setfactorRed( int );
	int getfactorGreen();
			void setfactorGreen( int );
	int getfactorBlue();
			void setfactorBlue( int );
	int getfactorAlpha();
			void setfactorAlpha( int );
	int getoffsetRed();
			void setoffsetRed( int );
	int getoffsetGreen();
			void setoffsetGreen( int );
	int getoffsetBlue();
			void setoffsetBlue( int );
	int getoffsetAlpha();
			void setoffsetAlpha( int );
	

	protected:
		bool hasOffset; // bit
bool hasFactor; // bit
int bits; // integer
int factorRed; // integer
int factorGreen; // integer
int factorBlue; // integer
int factorAlpha; // integer
int offsetRed; // integer
int offsetGreen; // integer
int offsetBlue; // integer
int offsetAlpha; // integer

};

class Header : public Item {
	public:
		Header();
		~Header();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Header* get( Reader *r, int end, Context *ctx );
		static Header* getByName( const char *name );

		Rectangle *getsize();
	int getframerate();
			void setframerate( int );
	unsigned short getframes();
			void setframes( unsigned short );
	List<Tag> *gettags();
	

	protected:
		Rectangle size; // object
int framerate; // integer
unsigned short frames; // word
List<Tag> tags; // list

};

class LineStyle : public Item {
	public:
		LineStyle();
		~LineStyle();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static LineStyle* get( Reader *r, int end, Context *ctx );
		static LineStyle* getByName( const char *name );

		unsigned short getwidth();
			void setwidth( unsigned short );
	Color *getcolor();
	

	protected:
		unsigned short width; // word
Color color; // object

};

class StyleList : public Item {
	public:
		StyleList();
		~StyleList();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static StyleList* get( Reader *r, int end, Context *ctx );
		static StyleList* getByName( const char *name );

		unsigned short getn_fillStyles();
			void setn_fillStyles( unsigned short );
	List<Style> *getfillStyles();
	unsigned short getn_lineStyles();
			void setn_lineStyles( unsigned short );
	List<LineStyle> *getlineStyles();
	int getfillBits();
			void setfillBits( int );
	int getlineBits();
			void setlineBits( int );
	

	protected:
		unsigned short n_fillStyles; // byteOrWord
List<Style> fillStyles; // list
unsigned short n_lineStyles; // byteOrWord
List<LineStyle> lineStyles; // list
int fillBits; // integer
int lineBits; // integer

};

class ShapeSetup : public ShapeItem {
	public:
		ShapeSetup();
		~ShapeSetup();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static ShapeSetup* get( Reader *r, int end, Context *ctx );
		static ShapeSetup* getByName( const char *name );

		bool gethasNewStyles();
			void sethasNewStyles( bool );
	bool gethasLineStyle();
			void sethasLineStyle( bool );
	bool gethasFillStyle1();
			void sethasFillStyle1( bool );
	bool gethasFillStyle0();
			void sethasFillStyle0( bool );
	bool gethasMoveTo();
			void sethasMoveTo( bool );
	int getxybits();
			void setxybits( int );
	int getx();
			void setx( int );
	int gety();
			void sety( int );
	int getfillStyle0();
			void setfillStyle0( int );
	int getfillStyle1();
			void setfillStyle1( int );
	int getlineStyle();
			void setlineStyle( int );
	StyleList *getstyles();
	

	protected:
		bool hasNewStyles; // bit
bool hasLineStyle; // bit
bool hasFillStyle1; // bit
bool hasFillStyle0; // bit
bool hasMoveTo; // bit
int xybits; // integer
int x; // integer
int y; // integer
int fillStyle0; // integer
int fillStyle1; // integer
int lineStyle; // integer
StyleList styles; // object

};

class CurveTo : public ShapeItem {
	public:
		CurveTo();
		~CurveTo();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static CurveTo* get( Reader *r, int end, Context *ctx );
		static CurveTo* getByName( const char *name );

		int getbits();
			void setbits( int );
	int getx1();
			void setx1( int );
	int gety1();
			void sety1( int );
	int getx2();
			void setx2( int );
	int gety2();
			void sety2( int );
	

	protected:
		int bits; // integer
int x1; // integer
int y1; // integer
int x2; // integer
int y2; // integer

};

class Shape : public Item {
	public:
		Shape();
		~Shape();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Shape* get( Reader *r, int end, Context *ctx );
		static Shape* getByName( const char *name );

		List<ShapeItem> *getedges();
	

	protected:
		List<ShapeItem> edges; // list

};

class GlyphShape : public Item {
	public:
		GlyphShape();
		~GlyphShape();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static GlyphShape* get( Reader *r, int end, Context *ctx );
		static GlyphShape* getByName( const char *name );

		int getfillBits();
			void setfillBits( int );
	int getlineBits();
			void setlineBits( int );
	List<ShapeItem> *getedges();
	

	protected:
		int fillBits; // integer
int lineBits; // integer
List<ShapeItem> edges; // list

};

class GradientItem : public Item {
	public:
		GradientItem();
		~GradientItem();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static GradientItem* get( Reader *r, int end, Context *ctx );
		static GradientItem* getByName( const char *name );

		unsigned char getposition();
			void setposition( unsigned char );
	Color *getcolor();
	

	protected:
		unsigned char position; // byte
Color color; // object

};

class Symbol : public Item {
	public:
		Symbol();
		~Symbol();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Symbol* get( Reader *r, int end, Context *ctx );
		static Symbol* getByName( const char *name );

		unsigned short getobjectID();
			void setobjectID( unsigned short );
	char * getname();
			void setname( char * );
	

	protected:
		unsigned short objectID; // word
char * name; // string

};

class Parameter : public Item {
	public:
		Parameter();
		~Parameter();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Parameter* get( Reader *r, int end, Context *ctx );
		static Parameter* getByName( const char *name );

		unsigned char getreg();
			void setreg( unsigned char );
	char * getname();
			void setname( char * );
	

	protected:
		unsigned char reg; // byte
char * name; // string

};

class UChar : public Item {
	public:
		UChar();
		~UChar();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static UChar* get( Reader *r, int end, Context *ctx );
		static UChar* getByName( const char *name );

		unsigned char getvalue();
			void setvalue( unsigned char );
	

	protected:
		unsigned char value; // byte

};

class UShort : public Item {
	public:
		UShort();
		~UShort();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static UShort* get( Reader *r, int end, Context *ctx );
		static UShort* getByName( const char *name );

		unsigned short getvalue();
			void setvalue( unsigned short );
	

	protected:
		unsigned short value; // word

};

class ULong : public Item {
	public:
		ULong();
		~ULong();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static ULong* get( Reader *r, int end, Context *ctx );
		static ULong* getByName( const char *name );

		int getvalue();
			void setvalue( int );
	

	protected:
		int value; // integer

};

class Short : public Item {
	public:
		Short();
		~Short();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Short* get( Reader *r, int end, Context *ctx );
		static Short* getByName( const char *name );

		unsigned short getvalue();
			void setvalue( unsigned short );
	

	protected:
		unsigned short value; // word

};

class Float : public Item {
	public:
		Float();
		~Float();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Float* get( Reader *r, int end, Context *ctx );
		static Float* getByName( const char *name );

		float getvalue();
			void setvalue( float );
	

	protected:
		float value; // float

};

class Kerning : public Item {
	public:
		Kerning();
		~Kerning();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Kerning* get( Reader *r, int end, Context *ctx );
		static Kerning* getByName( const char *name );

		unsigned char geta();
			void seta( unsigned char );
	unsigned char getb();
			void setb( unsigned char );
	int getadjustment();
			void setadjustment( int );
	

	protected:
		unsigned char a; // byte
unsigned char b; // byte
int adjustment; // integer

};

class WideKerning : public Item {
	public:
		WideKerning();
		~WideKerning();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static WideKerning* get( Reader *r, int end, Context *ctx );
		static WideKerning* getByName( const char *name );

		unsigned short geta();
			void seta( unsigned short );
	unsigned short getb();
			void setb( unsigned short );
	unsigned short getadjustment();
			void setadjustment( unsigned short );
	

	protected:
		unsigned short a; // word
unsigned short b; // word
unsigned short adjustment; // word

};

class TextEntry : public Item {
	public:
		TextEntry();
		~TextEntry();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static TextEntry* get( Reader *r, int end, Context *ctx );
		static TextEntry* getByName( const char *name );

		int getglyph();
			void setglyph( int );
	int getadvance();
			void setadvance( int );
	

	protected:
		int glyph; // integer
int advance; // integer

};

class TextEntry2 : public Item {
	public:
		TextEntry2();
		~TextEntry2();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static TextEntry2* get( Reader *r, int end, Context *ctx );
		static TextEntry2* getByName( const char *name );

		int getglyph();
			void setglyph( int );
	int getadvance();
			void setadvance( int );
	

	protected:
		int glyph; // integer
int advance; // integer

};

class TextRecord6 : public Item {
	public:
		TextRecord6();
		~TextRecord6();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static TextRecord6* get( Reader *r, int end, Context *ctx );
		static TextRecord6* getByName( const char *name );

		bool getisSetup();
			void setisSetup( bool );
	int getreserved();
			void setreserved( int );
	bool gethasFont();
			void sethasFont( bool );
	bool gethasColor();
			void sethasColor( bool );
	bool gethasMoveX();
			void sethasMoveX( bool );
	bool gethasMoveY();
			void sethasMoveY( bool );
	unsigned short getobjectID();
			void setobjectID( unsigned short );
	Color *getcolor();
	unsigned short getx();
			void setx( unsigned short );
	unsigned short gety();
			void sety( unsigned short );
	unsigned short getfontHeight();
			void setfontHeight( unsigned short );
	int getnGlyphs();
			void setnGlyphs( int );
	List<TextEntry> *getglyphs();
	

	protected:
		bool isSetup; // bit
int reserved; // integer
bool hasFont; // bit
bool hasColor; // bit
bool hasMoveX; // bit
bool hasMoveY; // bit
unsigned short objectID; // word
Color color; // object
unsigned short x; // word
unsigned short y; // word
unsigned short fontHeight; // word
int nGlyphs; // integer
List<TextEntry> glyphs; // list

};

class TextRecord62 : public Item {
	public:
		TextRecord62();
		~TextRecord62();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static TextRecord62* get( Reader *r, int end, Context *ctx );
		static TextRecord62* getByName( const char *name );

		bool getisSetup();
			void setisSetup( bool );
	int getreserved();
			void setreserved( int );
	bool gethasFont();
			void sethasFont( bool );
	bool gethasColor();
			void sethasColor( bool );
	bool gethasMoveX();
			void sethasMoveX( bool );
	bool gethasMoveY();
			void sethasMoveY( bool );
	unsigned short getobjectID();
			void setobjectID( unsigned short );
	Color *getcolor();
	unsigned short getx();
			void setx( unsigned short );
	unsigned short gety();
			void sety( unsigned short );
	unsigned short getfontHeight();
			void setfontHeight( unsigned short );
	int getnGlyphs();
			void setnGlyphs( int );
	List<TextEntry2> *getglyphs();
	

	protected:
		bool isSetup; // bit
int reserved; // integer
bool hasFont; // bit
bool hasColor; // bit
bool hasMoveX; // bit
bool hasMoveY; // bit
unsigned short objectID; // word
Color color; // object
unsigned short x; // word
unsigned short y; // word
unsigned short fontHeight; // word
int nGlyphs; // integer
List<TextEntry2> glyphs; // list

};

class TextRecord7 : public Item {
	public:
		TextRecord7();
		~TextRecord7();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static TextRecord7* get( Reader *r, int end, Context *ctx );
		static TextRecord7* getByName( const char *name );

		bool getisSetup();
			void setisSetup( bool );
	int getreserved();
			void setreserved( int );
	bool gethasFont();
			void sethasFont( bool );
	bool gethasColor();
			void sethasColor( bool );
	bool gethasMoveX();
			void sethasMoveX( bool );
	bool gethasMoveY();
			void sethasMoveY( bool );
	unsigned short getobjectID();
			void setobjectID( unsigned short );
	Color *getcolor();
	unsigned short getx();
			void setx( unsigned short );
	unsigned short gety();
			void sety( unsigned short );
	unsigned short getfontHeight();
			void setfontHeight( unsigned short );
	unsigned char getnGlyphs();
			void setnGlyphs( unsigned char );
	List<TextEntry> *getglyphs();
	

	protected:
		bool isSetup; // bit
int reserved; // integer
bool hasFont; // bit
bool hasColor; // bit
bool hasMoveX; // bit
bool hasMoveY; // bit
unsigned short objectID; // word
Color color; // object
unsigned short x; // word
unsigned short y; // word
unsigned short fontHeight; // word
unsigned char nGlyphs; // byte
List<TextEntry> glyphs; // list

};

class TextRecord72 : public Item {
	public:
		TextRecord72();
		~TextRecord72();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static TextRecord72* get( Reader *r, int end, Context *ctx );
		static TextRecord72* getByName( const char *name );

		bool getisSetup();
			void setisSetup( bool );
	int getreserved();
			void setreserved( int );
	bool gethasFont();
			void sethasFont( bool );
	bool gethasColor();
			void sethasColor( bool );
	bool gethasMoveX();
			void sethasMoveX( bool );
	bool gethasMoveY();
			void sethasMoveY( bool );
	unsigned short getfontRef();
			void setfontRef( unsigned short );
	Color *getcolor();
	unsigned short getx();
			void setx( unsigned short );
	unsigned short gety();
			void sety( unsigned short );
	unsigned short getfontHeight();
			void setfontHeight( unsigned short );
	unsigned char getnGlyphs();
			void setnGlyphs( unsigned char );
	List<TextEntry2> *getglyphs();
	

	protected:
		bool isSetup; // bit
int reserved; // integer
bool hasFont; // bit
bool hasColor; // bit
bool hasMoveX; // bit
bool hasMoveY; // bit
unsigned short fontRef; // word
Color color; // object
unsigned short x; // word
unsigned short y; // word
unsigned short fontHeight; // word
unsigned char nGlyphs; // byte
List<TextEntry2> glyphs; // list

};

class TextRecord : public Item {
	public:
		TextRecord();
		~TextRecord();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static TextRecord* get( Reader *r, int end, Context *ctx );
		static TextRecord* getByName( const char *name );

		List<TextRecord6> *getrecords();
	TextRecord7 *getstring();
	

	protected:
		List<TextRecord6> records; // list
TextRecord7 string; // object

};

class TextRecord2 : public Item {
	public:
		TextRecord2();
		~TextRecord2();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static TextRecord2* get( Reader *r, int end, Context *ctx );
		static TextRecord2* getByName( const char *name );

		List<TextRecord62> *getrecords();
	TextRecord72 *gettextString();
	

	protected:
		List<TextRecord62> records; // list
TextRecord72 textString; // object

};

class Button : public Item {
	public:
		Button();
		~Button();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Button* get( Reader *r, int end, Context *ctx );
		static Button* getByName( const char *name );

		int getreserved();
			void setreserved( int );
	bool gethitTest();
			void sethitTest( bool );
	bool getdown();
			void setdown( bool );
	bool getover();
			void setover( bool );
	bool getup();
			void setup( bool );
	unsigned short getobjectID();
			void setobjectID( unsigned short );
	unsigned short getdepth();
			void setdepth( unsigned short );
	Transform *gettransform();
	ColorTransform2 *getcolorTransform();
	

	protected:
		int reserved; // integer
bool hitTest; // bit
bool down; // bit
bool over; // bit
bool up; // bit
unsigned short objectID; // word
unsigned short depth; // word
Transform transform; // object
ColorTransform2 colorTransform; // object

};

class Event : public Item {
	public:
		Event();
		~Event();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Event* get( Reader *r, int end, Context *ctx );
		static Event* getByName( const char *name );

		unsigned short getflags1();
			void setflags1( unsigned short );
	unsigned short getflags2();
			void setflags2( unsigned short );
	unsigned int getactionLength();
			void setactionLength( unsigned int );
	List<Action> *getactions();
	

	protected:
		unsigned short flags1; // word
unsigned short flags2; // word
unsigned int actionLength; // uint32
List<Action> actions; // list

};

class Condition : public Item {
	public:
		Condition();
		~Condition();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Condition* get( Reader *r, int end, Context *ctx );
		static Condition* getByName( const char *name );

		unsigned short getnext();
			void setnext( unsigned short );
	bool getmenuEnter();
			void setmenuEnter( bool );
	bool getpointerReleaseOutside();
			void setpointerReleaseOutside( bool );
	bool getpointerDragEnter();
			void setpointerDragEnter( bool );
	bool getpointerDragLeave();
			void setpointerDragLeave( bool );
	bool getpointerReleaseInside();
			void setpointerReleaseInside( bool );
	bool getpointerPush();
			void setpointerPush( bool );
	bool getpointerLeave();
			void setpointerLeave( bool );
	bool getpointerEnter();
			void setpointerEnter( bool );
	int getkey();
			void setkey( int );
	bool getmenuLeave();
			void setmenuLeave( bool );
	List<Action> *getactions();
	

	protected:
		unsigned short next; // word
bool menuEnter; // bit
bool pointerReleaseOutside; // bit
bool pointerDragEnter; // bit
bool pointerDragLeave; // bit
bool pointerReleaseInside; // bit
bool pointerPush; // bit
bool pointerLeave; // bit
bool pointerEnter; // bit
int key; // integer
bool menuLeave; // bit
List<Action> actions; // list

};

class UnknownFilter : public Filter {
	public:
		UnknownFilter();
		~UnknownFilter();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static UnknownFilter* get( Reader *r, int end, Context *ctx );
		static UnknownFilter* getByName( const char *name );

		
			void getdata( unsigned char **dst, int *size );
			void setdata( const unsigned char *src, int size );
	

	protected:
		unsigned char * data; // data

			static int id;
		
};

class DropShadow : public Filter {
	public:
		DropShadow();
		~DropShadow();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DropShadow* get( Reader *r, int end, Context *ctx );
		static DropShadow* getByName( const char *name );

		Color *getcolor();
	float getblurX();
			void setblurX( float );
	float getblurY();
			void setblurY( float );
	float getangle();
			void setangle( float );
	float getdistance();
			void setdistance( float );
	float getstrength();
			void setstrength( float );
	bool getinnerShadow();
			void setinnerShadow( bool );
	bool getknockout();
			void setknockout( bool );
	bool getcompositeSource();
			void setcompositeSource( bool );
	int getpasses();
			void setpasses( int );
	

	protected:
		Color color; // object
float blurX; // fixedpoint2
float blurY; // fixedpoint2
float angle; // fixedpoint2
float distance; // fixedpoint2
float strength; // fixedpoint2
bool innerShadow; // bit
bool knockout; // bit
bool compositeSource; // bit
int passes; // integer

			static int id;
		
};

class Blur : public Filter {
	public:
		Blur();
		~Blur();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Blur* get( Reader *r, int end, Context *ctx );
		static Blur* getByName( const char *name );

		float getblurX();
			void setblurX( float );
	float getblurY();
			void setblurY( float );
	int getpasses();
			void setpasses( int );
	int getreserved1();
			void setreserved1( int );
	

	protected:
		float blurX; // fixedpoint2
float blurY; // fixedpoint2
int passes; // integer
int reserved1; // integer

			static int id;
		
};

class Glow : public Filter {
	public:
		Glow();
		~Glow();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Glow* get( Reader *r, int end, Context *ctx );
		static Glow* getByName( const char *name );

		Color *getcolor();
	float getblurX();
			void setblurX( float );
	float getblurY();
			void setblurY( float );
	float getstrength();
			void setstrength( float );
	bool getinnerGlow();
			void setinnerGlow( bool );
	bool getknockout();
			void setknockout( bool );
	bool getcompositeSource();
			void setcompositeSource( bool );
	int getpasses();
			void setpasses( int );
	

	protected:
		Color color; // object
float blurX; // fixedpoint2
float blurY; // fixedpoint2
float strength; // fixedpoint2
bool innerGlow; // bit
bool knockout; // bit
bool compositeSource; // bit
int passes; // integer

			static int id;
		
};

class Bevel : public Filter {
	public:
		Bevel();
		~Bevel();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Bevel* get( Reader *r, int end, Context *ctx );
		static Bevel* getByName( const char *name );

		Color *getshadowColor();
	Color *gethighlightColor();
	float getblurX();
			void setblurX( float );
	float getblurY();
			void setblurY( float );
	float getangle();
			void setangle( float );
	float getdistance();
			void setdistance( float );
	float getstrength();
			void setstrength( float );
	bool getinnerShadow();
			void setinnerShadow( bool );
	bool getknockout();
			void setknockout( bool );
	bool getcompositeSource();
			void setcompositeSource( bool );
	bool getonTop();
			void setonTop( bool );
	int getpasses();
			void setpasses( int );
	

	protected:
		Color shadowColor; // object
Color highlightColor; // object
float blurX; // fixedpoint2
float blurY; // fixedpoint2
float angle; // fixedpoint2
float distance; // fixedpoint2
float strength; // fixedpoint2
bool innerShadow; // bit
bool knockout; // bit
bool compositeSource; // bit
bool onTop; // bit
int passes; // integer

			static int id;
		
};

class GradientGlow : public Filter {
	public:
		GradientGlow();
		~GradientGlow();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static GradientGlow* get( Reader *r, int end, Context *ctx );
		static GradientGlow* getByName( const char *name );

		unsigned char getnumColors();
			void setnumColors( unsigned char );
	List<Color> *getcolors();
	List<UChar> *getratio();
	float getblurX();
			void setblurX( float );
	float getblurY();
			void setblurY( float );
	float getangle();
			void setangle( float );
	float getdistance();
			void setdistance( float );
	float getstrength();
			void setstrength( float );
	bool getinnerGlow();
			void setinnerGlow( bool );
	bool getknockout();
			void setknockout( bool );
	bool getcompositeSource();
			void setcompositeSource( bool );
	bool getonTop();
			void setonTop( bool );
	int getpasses();
			void setpasses( int );
	

	protected:
		unsigned char numColors; // byte
List<Color> colors; // list
List<UChar> ratio; // list
float blurX; // fixedpoint2
float blurY; // fixedpoint2
float angle; // fixedpoint2
float distance; // fixedpoint2
float strength; // fixedpoint2
bool innerGlow; // bit
bool knockout; // bit
bool compositeSource; // bit
bool onTop; // bit
int passes; // integer

			static int id;
		
};

class Convolution : public Filter {
	public:
		Convolution();
		~Convolution();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Convolution* get( Reader *r, int end, Context *ctx );
		static Convolution* getByName( const char *name );

		unsigned char getmatrixX();
			void setmatrixX( unsigned char );
	unsigned char getmatrixY();
			void setmatrixY( unsigned char );
	float getdivizor();
			void setdivizor( float );
	float getbias();
			void setbias( float );
	List<Float> *getmatrix();
	Color *getdefaultColor();
	int getreserved();
			void setreserved( int );
	bool getclamp();
			void setclamp( bool );
	bool getpreserveAlpha();
			void setpreserveAlpha( bool );
	

	protected:
		unsigned char matrixX; // byte
unsigned char matrixY; // byte
float divizor; // float
float bias; // float
List<Float> matrix; // list
Color defaultColor; // object
int reserved; // integer
bool clamp; // bit
bool preserveAlpha; // bit

			static int id;
		
};

class ColorMatrix : public Filter {
	public:
		ColorMatrix();
		~ColorMatrix();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static ColorMatrix* get( Reader *r, int end, Context *ctx );
		static ColorMatrix* getByName( const char *name );

		List<Float> *getmatrix();
	

	protected:
		List<Float> matrix; // list

			static int id;
		
};

class GradientBevel : public Filter {
	public:
		GradientBevel();
		~GradientBevel();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static GradientBevel* get( Reader *r, int end, Context *ctx );
		static GradientBevel* getByName( const char *name );

		unsigned char getnumColors();
			void setnumColors( unsigned char );
	List<Color> *getcolors();
	List<UChar> *getratio();
	float getblurX();
			void setblurX( float );
	float getblurY();
			void setblurY( float );
	float getangle();
			void setangle( float );
	float getdistance();
			void setdistance( float );
	float getstrength();
			void setstrength( float );
	bool getinnerGlow();
			void setinnerGlow( bool );
	bool getknockout();
			void setknockout( bool );
	bool getcompositeSource();
			void setcompositeSource( bool );
	bool getonTop();
			void setonTop( bool );
	int getpasses();
			void setpasses( int );
	

	protected:
		unsigned char numColors; // byte
List<Color> colors; // list
List<UChar> ratio; // list
float blurX; // fixedpoint2
float blurY; // fixedpoint2
float angle; // fixedpoint2
float distance; // fixedpoint2
float strength; // fixedpoint2
bool innerGlow; // bit
bool knockout; // bit
bool compositeSource; // bit
bool onTop; // bit
int passes; // integer

			static int id;
		
};

class Solid : public Style {
	public:
		Solid();
		~Solid();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Solid* get( Reader *r, int end, Context *ctx );
		static Solid* getByName( const char *name );

		Color *getcolor();
	

	protected:
		Color color; // object

			static int id;
		
};

class LinearGradient : public Style {
	public:
		LinearGradient();
		~LinearGradient();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static LinearGradient* get( Reader *r, int end, Context *ctx );
		static LinearGradient* getByName( const char *name );

		Transform *getmatrix();
	unsigned char getcount();
			void setcount( unsigned char );
	List<GradientItem> *getgradientColors();
	

	protected:
		Transform matrix; // object
unsigned char count; // byte
List<GradientItem> gradientColors; // list

			static int id;
		
};

class RadialGradient : public Style {
	public:
		RadialGradient();
		~RadialGradient();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static RadialGradient* get( Reader *r, int end, Context *ctx );
		static RadialGradient* getByName( const char *name );

		Transform *getmatrix();
	unsigned char getcount();
			void setcount( unsigned char );
	List<GradientItem> *getgradientColors();
	

	protected:
		Transform matrix; // object
unsigned char count; // byte
List<GradientItem> gradientColors; // list

			static int id;
		
};

class TiledBitmap : public Style {
	public:
		TiledBitmap();
		~TiledBitmap();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static TiledBitmap* get( Reader *r, int end, Context *ctx );
		static TiledBitmap* getByName( const char *name );

		unsigned short getobjectID();
			void setobjectID( unsigned short );
	Transform *getmatrix();
	

	protected:
		unsigned short objectID; // word
Transform matrix; // object

			static int id;
		
};

class ClippedBitmap : public Style {
	public:
		ClippedBitmap();
		~ClippedBitmap();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static ClippedBitmap* get( Reader *r, int end, Context *ctx );
		static ClippedBitmap* getByName( const char *name );

		unsigned short getobjectID();
			void setobjectID( unsigned short );
	Transform *getmatrix();
	

	protected:
		unsigned short objectID; // word
Transform matrix; // object

			static int id;
		
};

class TiledBitmap2 : public Style {
	public:
		TiledBitmap2();
		~TiledBitmap2();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static TiledBitmap2* get( Reader *r, int end, Context *ctx );
		static TiledBitmap2* getByName( const char *name );

		unsigned short getobjectID();
			void setobjectID( unsigned short );
	Transform *getmatrix();
	

	protected:
		unsigned short objectID; // word
Transform matrix; // object

			static int id;
		
};

class ClippedBitmap2 : public Style {
	public:
		ClippedBitmap2();
		~ClippedBitmap2();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static ClippedBitmap2* get( Reader *r, int end, Context *ctx );
		static ClippedBitmap2* getByName( const char *name );

		unsigned short getobjectID();
			void setobjectID( unsigned short );
	Transform *getmatrix();
	

	protected:
		unsigned short objectID; // word
Transform matrix; // object

			static int id;
		
};

class UnknownTag : public Tag {
	public:
		UnknownTag();
		~UnknownTag();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static UnknownTag* get( Reader *r, int end, Context *ctx );
		static UnknownTag* getByName( const char *name );

		
			void getdata( unsigned char **dst, int *size );
			void setdata( const unsigned char *src, int size );
	

	protected:
		unsigned char * data; // data

			static int id;
		
};

class End : public Tag {
	public:
		End();
		~End();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static End* get( Reader *r, int end, Context *ctx );
		static End* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class ShowFrame : public Tag {
	public:
		ShowFrame();
		~ShowFrame();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static ShowFrame* get( Reader *r, int end, Context *ctx );
		static ShowFrame* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class DefineShape : public Tag {
	public:
		DefineShape();
		~DefineShape();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineShape* get( Reader *r, int end, Context *ctx );
		static DefineShape* getByName( const char *name );

		unsigned short getobjectID();
			void setobjectID( unsigned short );
	Rectangle *getbounds();
	StyleList *getstyles();
	Shape *getshapes();
	

	protected:
		unsigned short objectID; // word
Rectangle bounds; // object
StyleList styles; // object
Shape shapes; // object

			static int id;
		
};

class RemoveObject : public Tag {
	public:
		RemoveObject();
		~RemoveObject();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static RemoveObject* get( Reader *r, int end, Context *ctx );
		static RemoveObject* getByName( const char *name );

		unsigned short getobjectID();
			void setobjectID( unsigned short );
	unsigned short getdepth();
			void setdepth( unsigned short );
	

	protected:
		unsigned short objectID; // word
unsigned short depth; // word

			static int id;
		
};

class DefineBits : public Tag {
	public:
		DefineBits();
		~DefineBits();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineBits* get( Reader *r, int end, Context *ctx );
		static DefineBits* getByName( const char *name );

		unsigned short getobjectID();
			void setobjectID( unsigned short );
	Rest *getdata();
	

	protected:
		unsigned short objectID; // word
Rest data; // object

			static int id;
		
};

class SetBackgroundColor : public Tag {
	public:
		SetBackgroundColor();
		~SetBackgroundColor();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static SetBackgroundColor* get( Reader *r, int end, Context *ctx );
		static SetBackgroundColor* getByName( const char *name );

		Color *getcolor();
	

	protected:
		Color color; // object

			static int id;
		
};

class DefineText : public Tag {
	public:
		DefineText();
		~DefineText();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineText* get( Reader *r, int end, Context *ctx );
		static DefineText* getByName( const char *name );

		unsigned short getobjectID();
			void setobjectID( unsigned short );
	Rectangle *getbounds();
	Transform *gettransform();
	unsigned char getglyphBits();
			void setglyphBits( unsigned char );
	unsigned char getadvanceBits();
			void setadvanceBits( unsigned char );
	List<TextRecord> *getrecords();
	

	protected:
		unsigned short objectID; // word
Rectangle bounds; // object
Transform transform; // object
unsigned char glyphBits; // byte
unsigned char advanceBits; // byte
List<TextRecord> records; // list

			static int id;
		
};

class DefineText2 : public Tag {
	public:
		DefineText2();
		~DefineText2();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineText2* get( Reader *r, int end, Context *ctx );
		static DefineText2* getByName( const char *name );

		unsigned short getobjectID();
			void setobjectID( unsigned short );
	Rectangle *getbounds();
	Transform *gettransform();
	unsigned char getglyphBits2();
			void setglyphBits2( unsigned char );
	unsigned char getadvanceBits2();
			void setadvanceBits2( unsigned char );
	List<TextRecord2> *getrecords();
	

	protected:
		unsigned short objectID; // word
Rectangle bounds; // object
Transform transform; // object
unsigned char glyphBits2; // byte
unsigned char advanceBits2; // byte
List<TextRecord2> records; // list

			static int id;
		
};

class DoAction : public Tag {
	public:
		DoAction();
		~DoAction();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DoAction* get( Reader *r, int end, Context *ctx );
		static DoAction* getByName( const char *name );

		List<Action> *getactions();
	

	protected:
		List<Action> actions; // list

			static int id;
		
};

class DefineFontInfo : public Tag {
	public:
		DefineFontInfo();
		~DefineFontInfo();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineFontInfo* get( Reader *r, int end, Context *ctx );
		static DefineFontInfo* getByName( const char *name );

		unsigned short getobjectID();
			void setobjectID( unsigned short );
	unsigned char getnameLength();
			void setnameLength( unsigned char );
	
			void getnameData( unsigned char **dst, int *size );
			void setnameData( const unsigned char *src, int size );
	int getreserved();
			void setreserved( int );
	bool getsmallTextOrUnicode();
			void setsmallTextOrUnicode( bool );
	bool getisShiftJIS();
			void setisShiftJIS( bool );
	bool getisANSII();
			void setisANSII( bool );
	bool getisItalic();
			void setisItalic( bool );
	bool getisBold();
			void setisBold( bool );
	bool getisWide();
			void setisWide( bool );
	unsigned char getlanguage();
			void setlanguage( unsigned char );
	Rest *getmap();
	

	protected:
		unsigned short objectID; // word
unsigned char nameLength; // byte
unsigned char * nameData; // data
int reserved; // integer
bool smallTextOrUnicode; // bit
bool isShiftJIS; // bit
bool isANSII; // bit
bool isItalic; // bit
bool isBold; // bit
bool isWide; // bit
unsigned char language; // byte
Rest map; // object

			static int id;
		
};

class DefineSound : public Tag {
	public:
		DefineSound();
		~DefineSound();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineSound* get( Reader *r, int end, Context *ctx );
		static DefineSound* getByName( const char *name );

		unsigned short getobjectID();
			void setobjectID( unsigned short );
	int getformat();
			void setformat( int );
	int getrate();
			void setrate( int );
	bool getis16bit();
			void setis16bit( bool );
	bool getstereo();
			void setstereo( bool );
	unsigned int getsamples();
			void setsamples( unsigned int );
	Rest *getdata();
	

	protected:
		unsigned short objectID; // word
int format; // integer
int rate; // integer
bool is16bit; // bit
bool stereo; // bit
unsigned int samples; // uint32
Rest data; // object

			static int id;
		
};

class StartSound : public Tag {
	public:
		StartSound();
		~StartSound();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static StartSound* get( Reader *r, int end, Context *ctx );
		static StartSound* getByName( const char *name );

		unsigned short getobjectID();
			void setobjectID( unsigned short );
	int getreserved();
			void setreserved( int );
	bool getstopPlayback();
			void setstopPlayback( bool );
	bool getnoMultiple();
			void setnoMultiple( bool );
	bool gethasEnvelope();
			void sethasEnvelope( bool );
	bool gethasLoop();
			void sethasLoop( bool );
	bool gethasOutPoint();
			void sethasOutPoint( bool );
	bool gethasInPoint();
			void sethasInPoint( bool );
	unsigned int getinPoint();
			void setinPoint( unsigned int );
	unsigned int getoutPoint();
			void setoutPoint( unsigned int );
	unsigned short getloop();
			void setloop( unsigned short );
	unsigned char getenvelopeCount();
			void setenvelopeCount( unsigned char );
	Rest *getenvelopeData();
	

	protected:
		unsigned short objectID; // word
int reserved; // integer
bool stopPlayback; // bit
bool noMultiple; // bit
bool hasEnvelope; // bit
bool hasLoop; // bit
bool hasOutPoint; // bit
bool hasInPoint; // bit
unsigned int inPoint; // uint32
unsigned int outPoint; // uint32
unsigned short loop; // word
unsigned char envelopeCount; // byte
Rest envelopeData; // object

			static int id;
		
};

class DefineShape2 : public Tag {
	public:
		DefineShape2();
		~DefineShape2();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineShape2* get( Reader *r, int end, Context *ctx );
		static DefineShape2* getByName( const char *name );

		unsigned short getobjectID();
			void setobjectID( unsigned short );
	Rectangle *getbounds();
	StyleList *getstyles();
	Shape *getshapes();
	

	protected:
		unsigned short objectID; // word
Rectangle bounds; // object
StyleList styles; // object
Shape shapes; // object

			static int id;
		
};

class DefineShape3 : public Tag {
	public:
		DefineShape3();
		~DefineShape3();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineShape3* get( Reader *r, int end, Context *ctx );
		static DefineShape3* getByName( const char *name );

		unsigned short getobjectID();
			void setobjectID( unsigned short );
	Rectangle *getbounds();
	StyleList *getstyles();
	Shape *getshapes();
	

	protected:
		unsigned short objectID; // word
Rectangle bounds; // object
StyleList styles; // object
Shape shapes; // object

			static int id;
		
};

class DefineShape4 : public Tag {
	public:
		DefineShape4();
		~DefineShape4();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineShape4* get( Reader *r, int end, Context *ctx );
		static DefineShape4* getByName( const char *name );

		unsigned short getobjectID();
			void setobjectID( unsigned short );
	Rest *getdata();
	

	protected:
		unsigned short objectID; // word
Rest data; // object

			static int id;
		
};

class DefineShape5 : public Tag {
	public:
		DefineShape5();
		~DefineShape5();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineShape5* get( Reader *r, int end, Context *ctx );
		static DefineShape5* getByName( const char *name );

		unsigned short getobjectID();
			void setobjectID( unsigned short );
	Rest *getdata();
	

	protected:
		unsigned short objectID; // word
Rest data; // object

			static int id;
		
};

class DefineMorphShape : public Tag {
	public:
		DefineMorphShape();
		~DefineMorphShape();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineMorphShape* get( Reader *r, int end, Context *ctx );
		static DefineMorphShape* getByName( const char *name );

		unsigned short getobjectID();
			void setobjectID( unsigned short );
	Rest *getdata();
	

	protected:
		unsigned short objectID; // word
Rest data; // object

			static int id;
		
};

class DefineFontInfo2 : public Tag {
	public:
		DefineFontInfo2();
		~DefineFontInfo2();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineFontInfo2* get( Reader *r, int end, Context *ctx );
		static DefineFontInfo2* getByName( const char *name );

		unsigned short getobjectID();
			void setobjectID( unsigned short );
	unsigned char getnameLength();
			void setnameLength( unsigned char );
	
			void getnameData( unsigned char **dst, int *size );
			void setnameData( const unsigned char *src, int size );
	int getreserved();
			void setreserved( int );
	bool getsmallTextOrUnicode();
			void setsmallTextOrUnicode( bool );
	bool getisShiftJIS();
			void setisShiftJIS( bool );
	bool getisANSII();
			void setisANSII( bool );
	bool getisItalic();
			void setisItalic( bool );
	bool getisBold();
			void setisBold( bool );
	bool getisWide();
			void setisWide( bool );
	unsigned char getlanguage();
			void setlanguage( unsigned char );
	Rest *getmap();
	

	protected:
		unsigned short objectID; // word
unsigned char nameLength; // byte
unsigned char * nameData; // data
int reserved; // integer
bool smallTextOrUnicode; // bit
bool isShiftJIS; // bit
bool isANSII; // bit
bool isItalic; // bit
bool isBold; // bit
bool isWide; // bit
unsigned char language; // byte
Rest map; // object

			static int id;
		
};

class SoundStreamHead : public Tag {
	public:
		SoundStreamHead();
		~SoundStreamHead();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static SoundStreamHead* get( Reader *r, int end, Context *ctx );
		static SoundStreamHead* getByName( const char *name );

		int getreserved();
			void setreserved( int );
	int getplaybackRate();
			void setplaybackRate( int );
	bool getplaybackSize();
			void setplaybackSize( bool );
	bool getplaybackStereo();
			void setplaybackStereo( bool );
	int getcompression();
			void setcompression( int );
	int getsoundRate();
			void setsoundRate( int );
	bool getsoundSize();
			void setsoundSize( bool );
	bool getsoundStereo();
			void setsoundStereo( bool );
	unsigned short getsampleSize();
			void setsampleSize( unsigned short );
	Rest *getlatencySeek();
	

	protected:
		int reserved; // integer
int playbackRate; // integer
bool playbackSize; // bit
bool playbackStereo; // bit
int compression; // integer
int soundRate; // integer
bool soundSize; // bit
bool soundStereo; // bit
unsigned short sampleSize; // word
Rest latencySeek; // object

			static int id;
		
};

class DefineBitsLossless : public Tag {
	public:
		DefineBitsLossless();
		~DefineBitsLossless();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineBitsLossless* get( Reader *r, int end, Context *ctx );
		static DefineBitsLossless* getByName( const char *name );

		unsigned short getobjectID();
			void setobjectID( unsigned short );
	unsigned char getformat();
			void setformat( unsigned char );
	unsigned short getwidth();
			void setwidth( unsigned short );
	unsigned short getheight();
			void setheight( unsigned short );
	Rest *getdata();
	

	protected:
		unsigned short objectID; // word
unsigned char format; // byte
unsigned short width; // word
unsigned short height; // word
Rest data; // object

			static int id;
		
};

class DefineBitsJPEG2 : public Tag {
	public:
		DefineBitsJPEG2();
		~DefineBitsJPEG2();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineBitsJPEG2* get( Reader *r, int end, Context *ctx );
		static DefineBitsJPEG2* getByName( const char *name );

		unsigned short getobjectID();
			void setobjectID( unsigned short );
	Rest *getdata();
	

	protected:
		unsigned short objectID; // word
Rest data; // object

			static int id;
		
};

class DefineBitsJPEG3 : public Tag {
	public:
		DefineBitsJPEG3();
		~DefineBitsJPEG3();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineBitsJPEG3* get( Reader *r, int end, Context *ctx );
		static DefineBitsJPEG3* getByName( const char *name );

		unsigned short getobjectID();
			void setobjectID( unsigned short );
	unsigned int getoffset_to_alpha();
			void setoffset_to_alpha( unsigned int );
	Rest *getdata();
	

	protected:
		unsigned short objectID; // word
unsigned int offset_to_alpha; // uint32
Rest data; // object

			static int id;
		
};

class DefineBitsLossless2 : public Tag {
	public:
		DefineBitsLossless2();
		~DefineBitsLossless2();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineBitsLossless2* get( Reader *r, int end, Context *ctx );
		static DefineBitsLossless2* getByName( const char *name );

		unsigned short getobjectID();
			void setobjectID( unsigned short );
	unsigned char getformat();
			void setformat( unsigned char );
	unsigned short getwidth();
			void setwidth( unsigned short );
	unsigned short getheight();
			void setheight( unsigned short );
	unsigned char getn_colormap();
			void setn_colormap( unsigned char );
	Rest *getdata();
	

	protected:
		unsigned short objectID; // word
unsigned char format; // byte
unsigned short width; // word
unsigned short height; // word
unsigned char n_colormap; // byte
Rest data; // object

			static int id;
		
};

class PlaceObject2 : public Tag {
	public:
		PlaceObject2();
		~PlaceObject2();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static PlaceObject2* get( Reader *r, int end, Context *ctx );
		static PlaceObject2* getByName( const char *name );

		bool gethasEventHandler();
			void sethasEventHandler( bool );
	bool gethasClipDepth();
			void sethasClipDepth( bool );
	bool gethasName();
			void sethasName( bool );
	bool gethasMorph();
			void sethasMorph( bool );
	bool gethasColorTransform();
			void sethasColorTransform( bool );
	bool gethasTransform();
			void sethasTransform( bool );
	bool gethasID();
			void sethasID( bool );
	bool getreplace();
			void setreplace( bool );
	unsigned short getdepth();
			void setdepth( unsigned short );
	unsigned short getobjectID();
			void setobjectID( unsigned short );
	Transform *gettransform();
	ColorTransform2 *getcolorTransform();
	unsigned short getmorph();
			void setmorph( unsigned short );
	char * getname();
			void setname( char * );
	unsigned short getclipDepth();
			void setclipDepth( unsigned short );
	unsigned short getreserved();
			void setreserved( unsigned short );
	unsigned short getallflags1();
			void setallflags1( unsigned short );
	unsigned short getallflags2();
			void setallflags2( unsigned short );
	List<Event> *getevents();
	

	protected:
		bool hasEventHandler; // bit
bool hasClipDepth; // bit
bool hasName; // bit
bool hasMorph; // bit
bool hasColorTransform; // bit
bool hasTransform; // bit
bool hasID; // bit
bool replace; // bit
unsigned short depth; // word
unsigned short objectID; // word
Transform transform; // object
ColorTransform2 colorTransform; // object
unsigned short morph; // word
char * name; // string
unsigned short clipDepth; // word
unsigned short reserved; // word
unsigned short allflags1; // word
unsigned short allflags2; // word
List<Event> events; // list

			static int id;
		
};

class RemoveObject2 : public Tag {
	public:
		RemoveObject2();
		~RemoveObject2();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static RemoveObject2* get( Reader *r, int end, Context *ctx );
		static RemoveObject2* getByName( const char *name );

		unsigned short getdepth();
			void setdepth( unsigned short );
	

	protected:
		unsigned short depth; // word

			static int id;
		
};

class DefineEditText : public Tag {
	public:
		DefineEditText();
		~DefineEditText();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineEditText* get( Reader *r, int end, Context *ctx );
		static DefineEditText* getByName( const char *name );

		unsigned short getobjectID();
			void setobjectID( unsigned short );
	Rectangle *getsize();
	bool gethasText();
			void sethasText( bool );
	bool getwordWrap();
			void setwordWrap( bool );
	bool getmultiLine();
			void setmultiLine( bool );
	bool getpassword();
			void setpassword( bool );
	bool getreadOnly();
			void setreadOnly( bool );
	bool gethasColor();
			void sethasColor( bool );
	bool gethasMaxLength();
			void sethasMaxLength( bool );
	bool gethasFont();
			void sethasFont( bool );
	bool getreserved();
			void setreserved( bool );
	bool getautoSize();
			void setautoSize( bool );
	bool gethasLayout();
			void sethasLayout( bool );
	bool getnotSelectable();
			void setnotSelectable( bool );
	bool gethasBorder();
			void sethasBorder( bool );
	bool getreserved2();
			void setreserved2( bool );
	bool getisHTML();
			void setisHTML( bool );
	bool getuseOutlines();
			void setuseOutlines( bool );
	unsigned short getfontRef();
			void setfontRef( unsigned short );
	unsigned short getfontHeight();
			void setfontHeight( unsigned short );
	Color *getcolor();
	unsigned short getmaxLength();
			void setmaxLength( unsigned short );
	unsigned char getalign();
			void setalign( unsigned char );
	unsigned short getleftMargin();
			void setleftMargin( unsigned short );
	unsigned short getrightMargin();
			void setrightMargin( unsigned short );
	unsigned short getindent();
			void setindent( unsigned short );
	unsigned short getleading();
			void setleading( unsigned short );
	char * getvariableName();
			void setvariableName( char * );
	char * getinitialText();
			void setinitialText( char * );
	

	protected:
		unsigned short objectID; // word
Rectangle size; // object
bool hasText; // bit
bool wordWrap; // bit
bool multiLine; // bit
bool password; // bit
bool readOnly; // bit
bool hasColor; // bit
bool hasMaxLength; // bit
bool hasFont; // bit
bool reserved; // bit
bool autoSize; // bit
bool hasLayout; // bit
bool notSelectable; // bit
bool hasBorder; // bit
bool reserved2; // bit
bool isHTML; // bit
bool useOutlines; // bit
unsigned short fontRef; // word
unsigned short fontHeight; // word
Color color; // object
unsigned short maxLength; // word
unsigned char align; // byte
unsigned short leftMargin; // word
unsigned short rightMargin; // word
unsigned short indent; // word
unsigned short leading; // word
char * variableName; // string
char * initialText; // string

			static int id;
		
};

class DefineSprite : public Tag {
	public:
		DefineSprite();
		~DefineSprite();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineSprite* get( Reader *r, int end, Context *ctx );
		static DefineSprite* getByName( const char *name );

		unsigned short getobjectID();
			void setobjectID( unsigned short );
	unsigned short getframes();
			void setframes( unsigned short );
	List<Tag> *gettags();
	

	protected:
		unsigned short objectID; // word
unsigned short frames; // word
List<Tag> tags; // list

			static int id;
		
};

class FrameLabel : public Tag {
	public:
		FrameLabel();
		~FrameLabel();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static FrameLabel* get( Reader *r, int end, Context *ctx );
		static FrameLabel* getByName( const char *name );

		char * getlabel();
			void setlabel( char * );
	Rest *getflags();
	

	protected:
		char * label; // string
Rest flags; // object

			static int id;
		
};

class SoundStreamHead2 : public Tag {
	public:
		SoundStreamHead2();
		~SoundStreamHead2();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static SoundStreamHead2* get( Reader *r, int end, Context *ctx );
		static SoundStreamHead2* getByName( const char *name );

		int getreserved();
			void setreserved( int );
	int getplaybackRate();
			void setplaybackRate( int );
	bool getplaybackSize();
			void setplaybackSize( bool );
	bool getplaybackStereo();
			void setplaybackStereo( bool );
	int getcompression();
			void setcompression( int );
	int getsoundRate();
			void setsoundRate( int );
	bool getsoundSize();
			void setsoundSize( bool );
	bool getsoundStereo();
			void setsoundStereo( bool );
	unsigned short getsampleSize();
			void setsampleSize( unsigned short );
	Rest *getlatencySeek();
	

	protected:
		int reserved; // integer
int playbackRate; // integer
bool playbackSize; // bit
bool playbackStereo; // bit
int compression; // integer
int soundRate; // integer
bool soundSize; // bit
bool soundStereo; // bit
unsigned short sampleSize; // word
Rest latencySeek; // object

			static int id;
		
};

class DefineFont : public Tag {
	public:
		DefineFont();
		~DefineFont();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineFont* get( Reader *r, int end, Context *ctx );
		static DefineFont* getByName( const char *name );

		unsigned short getobjectID();
			void setobjectID( unsigned short );
	Rest *getdata();
	

	protected:
		unsigned short objectID; // word
Rest data; // object

			static int id;
		
};

class DefineFont2 : public Tag {
	public:
		DefineFont2();
		~DefineFont2();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineFont2* get( Reader *r, int end, Context *ctx );
		static DefineFont2* getByName( const char *name );

		unsigned short getobjectID();
			void setobjectID( unsigned short );
	bool gethasLayout();
			void sethasLayout( bool );
	bool getisShiftJIS();
			void setisShiftJIS( bool );
	bool getisUnicode();
			void setisUnicode( bool );
	bool getisANSII();
			void setisANSII( bool );
	bool getwideGlyphOffsets();
			void setwideGlyphOffsets( bool );
	bool getwideMap();
			void setwideMap( bool );
	bool getitalic();
			void setitalic( bool );
	bool getbold();
			void setbold( bool );
	unsigned char getlanguage();
			void setlanguage( unsigned char );
	char * getname();
			void setname( char * );
	unsigned short getglyphCount();
			void setglyphCount( unsigned short );
	GlyphList *getglyphs();
	unsigned short getascent();
			void setascent( unsigned short );
	unsigned short getdescent();
			void setdescent( unsigned short );
	unsigned short getleading();
			void setleading( unsigned short );
	List<Short> *getadvance();
	List<Rectangle> *getbounds();
	unsigned short getkerningCount();
			void setkerningCount( unsigned short );
	List<WideKerning> *getwideKerning();
	List<Kerning> *getkerning();
	

	protected:
		unsigned short objectID; // word
bool hasLayout; // bit
bool isShiftJIS; // bit
bool isUnicode; // bit
bool isANSII; // bit
bool wideGlyphOffsets; // bit
bool wideMap; // bit
bool italic; // bit
bool bold; // bit
unsigned char language; // byte
char * name; // string
unsigned short glyphCount; // word
GlyphList glyphs; // object
unsigned short ascent; // word
unsigned short descent; // word
unsigned short leading; // word
List<Short> advance; // list
List<Rectangle> bounds; // list
unsigned short kerningCount; // word
List<WideKerning> wideKerning; // list
List<Kerning> kerning; // list

			static int id;
		
};

class DefineButton : public Tag {
	public:
		DefineButton();
		~DefineButton();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineButton* get( Reader *r, int end, Context *ctx );
		static DefineButton* getByName( const char *name );

		unsigned short getobjectID();
			void setobjectID( unsigned short );
	List<Button> *getbuttons();
	List<Action> *getactions();
	

	protected:
		unsigned short objectID; // word
List<Button> buttons; // list
List<Action> actions; // list

			static int id;
		
};

class DefineButton2 : public Tag {
	public:
		DefineButton2();
		~DefineButton2();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineButton2* get( Reader *r, int end, Context *ctx );
		static DefineButton2* getByName( const char *name );

		unsigned short getobjectID();
			void setobjectID( unsigned short );
	int getreserved();
			void setreserved( int );
	bool getmenu();
			void setmenu( bool );
	unsigned short getbuttonsSize();
			void setbuttonsSize( unsigned short );
	List<Button> *getbuttons();
	List<Condition> *getconditions();
	

	protected:
		unsigned short objectID; // word
int reserved; // integer
bool menu; // bit
unsigned short buttonsSize; // word
List<Button> buttons; // list
List<Condition> conditions; // list

			static int id;
		
};

class Export : public Tag {
	public:
		Export();
		~Export();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Export* get( Reader *r, int end, Context *ctx );
		static Export* getByName( const char *name );

		unsigned short getcount();
			void setcount( unsigned short );
	List<Symbol> *getsymbols();
	

	protected:
		unsigned short count; // word
List<Symbol> symbols; // list

			static int id;
		
};

class Import : public Tag {
	public:
		Import();
		~Import();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Import* get( Reader *r, int end, Context *ctx );
		static Import* getByName( const char *name );

		char * geturl();
			void seturl( char * );
	unsigned short getcount();
			void setcount( unsigned short );
	List<Symbol> *getsymbols();
	

	protected:
		char * url; // string
unsigned short count; // word
List<Symbol> symbols; // list

			static int id;
		
};

class DoInitAction : public Tag {
	public:
		DoInitAction();
		~DoInitAction();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DoInitAction* get( Reader *r, int end, Context *ctx );
		static DoInitAction* getByName( const char *name );

		unsigned short getsprite();
			void setsprite( unsigned short );
	List<Action> *getactions();
	

	protected:
		unsigned short sprite; // word
List<Action> actions; // list

			static int id;
		
};

class SoundStreamBlock : public Tag {
	public:
		SoundStreamBlock();
		~SoundStreamBlock();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static SoundStreamBlock* get( Reader *r, int end, Context *ctx );
		static SoundStreamBlock* getByName( const char *name );

		
			void getdata( unsigned char **dst, int *size );
			void setdata( const unsigned char *src, int size );
	

	protected:
		unsigned char * data; // data

			static int id;
		
};

class DefineVideoStream : public Tag {
	public:
		DefineVideoStream();
		~DefineVideoStream();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineVideoStream* get( Reader *r, int end, Context *ctx );
		static DefineVideoStream* getByName( const char *name );

		unsigned short getobjectID();
			void setobjectID( unsigned short );
	unsigned short getframes();
			void setframes( unsigned short );
	unsigned short getwidth();
			void setwidth( unsigned short );
	unsigned short getheight();
			void setheight( unsigned short );
	int getreserved();
			void setreserved( int );
	int getdeblocking();
			void setdeblocking( int );
	bool getsmoothing();
			void setsmoothing( bool );
	unsigned char getcodec();
			void setcodec( unsigned char );
	

	protected:
		unsigned short objectID; // word
unsigned short frames; // word
unsigned short width; // word
unsigned short height; // word
int reserved; // integer
int deblocking; // integer
bool smoothing; // bit
unsigned char codec; // byte

			static int id;
		
};

class VideoFrame : public Tag {
	public:
		VideoFrame();
		~VideoFrame();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static VideoFrame* get( Reader *r, int end, Context *ctx );
		static VideoFrame* getByName( const char *name );

		unsigned short getobjectID();
			void setobjectID( unsigned short );
	unsigned short getframe();
			void setframe( unsigned short );
	Rest *getdata();
	

	protected:
		unsigned short objectID; // word
unsigned short frame; // word
Rest data; // object

			static int id;
		
};

class ScriptLimits : public Tag {
	public:
		ScriptLimits();
		~ScriptLimits();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static ScriptLimits* get( Reader *r, int end, Context *ctx );
		static ScriptLimits* getByName( const char *name );

		unsigned short getmaxRecursionDepth();
			void setmaxRecursionDepth( unsigned short );
	unsigned short gettimeout();
			void settimeout( unsigned short );
	

	protected:
		unsigned short maxRecursionDepth; // word
unsigned short timeout; // word

			static int id;
		
};

class SetTabIndex : public Tag {
	public:
		SetTabIndex();
		~SetTabIndex();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static SetTabIndex* get( Reader *r, int end, Context *ctx );
		static SetTabIndex* getByName( const char *name );

		unsigned short getdepth();
			void setdepth( unsigned short );
	unsigned short gettabIndex();
			void settabIndex( unsigned short );
	

	protected:
		unsigned short depth; // word
unsigned short tabIndex; // word

			static int id;
		
};

class PlaceObject3 : public Tag {
	public:
		PlaceObject3();
		~PlaceObject3();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static PlaceObject3* get( Reader *r, int end, Context *ctx );
		static PlaceObject3* getByName( const char *name );

		bool gethasEventHandler();
			void sethasEventHandler( bool );
	bool gethasClipDepth();
			void sethasClipDepth( bool );
	bool gethasName();
			void sethasName( bool );
	bool gethasMorph();
			void sethasMorph( bool );
	bool gethasColorTransform();
			void sethasColorTransform( bool );
	bool gethasTransform();
			void sethasTransform( bool );
	bool gethasID();
			void sethasID( bool );
	bool getreplace();
			void setreplace( bool );
	int getreserved1();
			void setreserved1( int );
	bool gethasCacheAsBitmap();
			void sethasCacheAsBitmap( bool );
	bool gethasBlendMode();
			void sethasBlendMode( bool );
	bool gethasFilterList();
			void sethasFilterList( bool );
	unsigned short getdepth();
			void setdepth( unsigned short );
	unsigned short getobjectID();
			void setobjectID( unsigned short );
	Transform *gettransform();
	ColorTransform2 *getcolorTransform();
	unsigned short getmorph();
			void setmorph( unsigned short );
	char * getname();
			void setname( char * );
	unsigned short getclipDepth();
			void setclipDepth( unsigned short );
	unsigned char getnumFilters();
			void setnumFilters( unsigned char );
	List<Filter> *getfilters();
	unsigned char getblendMode();
			void setblendMode( unsigned char );
	unsigned char getbitmapCaching();
			void setbitmapCaching( unsigned char );
	unsigned short getreserved();
			void setreserved( unsigned short );
	unsigned short getallflags1();
			void setallflags1( unsigned short );
	unsigned short getallflags2();
			void setallflags2( unsigned short );
	List<Event> *getevents();
	

	protected:
		bool hasEventHandler; // bit
bool hasClipDepth; // bit
bool hasName; // bit
bool hasMorph; // bit
bool hasColorTransform; // bit
bool hasTransform; // bit
bool hasID; // bit
bool replace; // bit
int reserved1; // integer
bool hasCacheAsBitmap; // bit
bool hasBlendMode; // bit
bool hasFilterList; // bit
unsigned short depth; // word
unsigned short objectID; // word
Transform transform; // object
ColorTransform2 colorTransform; // object
unsigned short morph; // word
char * name; // string
unsigned short clipDepth; // word
unsigned char numFilters; // byte
List<Filter> filters; // list
unsigned char blendMode; // byte
unsigned char bitmapCaching; // byte
unsigned short reserved; // word
unsigned short allflags1; // word
unsigned short allflags2; // word
List<Event> events; // list

			static int id;
		
};

class ImportAssets2 : public Tag {
	public:
		ImportAssets2();
		~ImportAssets2();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static ImportAssets2* get( Reader *r, int end, Context *ctx );
		static ImportAssets2* getByName( const char *name );

		char * geturl();
			void seturl( char * );
	unsigned char getreserved1();
			void setreserved1( unsigned char );
	unsigned char getreserved2();
			void setreserved2( unsigned char );
	unsigned short getcount();
			void setcount( unsigned short );
	List<Symbol> *getsymbols();
	

	protected:
		char * url; // string
unsigned char reserved1; // byte
unsigned char reserved2; // byte
unsigned short count; // word
List<Symbol> symbols; // list

			static int id;
		
};

class FileAttributes : public Tag {
	public:
		FileAttributes();
		~FileAttributes();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static FileAttributes* get( Reader *r, int end, Context *ctx );
		static FileAttributes* getByName( const char *name );

		int getreserved1();
			void setreserved1( int );
	bool gethasMetaData();
			void sethasMetaData( bool );
	int getreserved2();
			void setreserved2( int );
	bool getuseNetwork();
			void setuseNetwork( bool );
	int getreserved3();
			void setreserved3( int );
	

	protected:
		int reserved1; // integer
bool hasMetaData; // bit
int reserved2; // integer
bool useNetwork; // bit
int reserved3; // integer

			static int id;
		
};

class DefineFontInfo3 : public Tag {
	public:
		DefineFontInfo3();
		~DefineFontInfo3();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineFontInfo3* get( Reader *r, int end, Context *ctx );
		static DefineFontInfo3* getByName( const char *name );

		unsigned short getobjectID();
			void setobjectID( unsigned short );
	Rest *getdata();
	

	protected:
		unsigned short objectID; // word
Rest data; // object

			static int id;
		
};

class CSMTextSettings : public Tag {
	public:
		CSMTextSettings();
		~CSMTextSettings();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static CSMTextSettings* get( Reader *r, int end, Context *ctx );
		static CSMTextSettings* getByName( const char *name );

		unsigned short getobjectID();
			void setobjectID( unsigned short );
	int getuseFlashType();
			void setuseFlashType( int );
	int getgridFit();
			void setgridFit( int );
	int getreserved1();
			void setreserved1( int );
	float getthickness();
			void setthickness( float );
	float getsharpness();
			void setsharpness( float );
	unsigned char getreserved2();
			void setreserved2( unsigned char );
	

	protected:
		unsigned short objectID; // word
int useFlashType; // integer
int gridFit; // integer
int reserved1; // integer
float thickness; // float
float sharpness; // float
unsigned char reserved2; // byte

			static int id;
		
};

class DefineFont3 : public Tag {
	public:
		DefineFont3();
		~DefineFont3();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineFont3* get( Reader *r, int end, Context *ctx );
		static DefineFont3* getByName( const char *name );

		unsigned short getobjectID();
			void setobjectID( unsigned short );
	Rest *getdata();
	

	protected:
		unsigned short objectID; // word
Rest data; // object

			static int id;
		
};

class Metadata : public Tag {
	public:
		Metadata();
		~Metadata();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Metadata* get( Reader *r, int end, Context *ctx );
		static Metadata* getByName( const char *name );

		char * getRDF();
			void setRDF( char * );
	

	protected:
		char * RDF; // xml

			static int id;
		
};

class DefineScalingGrid : public Tag {
	public:
		DefineScalingGrid();
		~DefineScalingGrid();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineScalingGrid* get( Reader *r, int end, Context *ctx );
		static DefineScalingGrid* getByName( const char *name );

		unsigned short getobjectID();
			void setobjectID( unsigned short );
	Rectangle *getsplitter();
	

	protected:
		unsigned short objectID; // word
Rectangle splitter; // object

			static int id;
		
};

class StackString : public StackItem {
	public:
		StackString();
		~StackString();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static StackString* get( Reader *r, int end, Context *ctx );
		static StackString* getByName( const char *name );

		char * getvalue();
			void setvalue( char * );
	

	protected:
		char * value; // string

			static int id;
		
};

class StackFloat : public StackItem {
	public:
		StackFloat();
		~StackFloat();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static StackFloat* get( Reader *r, int end, Context *ctx );
		static StackFloat* getByName( const char *name );

		float getvalue();
			void setvalue( float );
	

	protected:
		float value; // float

			static int id;
		
};

class StackNull : public StackItem {
	public:
		StackNull();
		~StackNull();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static StackNull* get( Reader *r, int end, Context *ctx );
		static StackNull* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class StackUndefined : public StackItem {
	public:
		StackUndefined();
		~StackUndefined();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static StackUndefined* get( Reader *r, int end, Context *ctx );
		static StackUndefined* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class StackRegister : public StackItem {
	public:
		StackRegister();
		~StackRegister();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static StackRegister* get( Reader *r, int end, Context *ctx );
		static StackRegister* getByName( const char *name );

		unsigned char getreg();
			void setreg( unsigned char );
	

	protected:
		unsigned char reg; // byte

			static int id;
		
};

class StackBoolean : public StackItem {
	public:
		StackBoolean();
		~StackBoolean();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static StackBoolean* get( Reader *r, int end, Context *ctx );
		static StackBoolean* getByName( const char *name );

		unsigned char getvalue();
			void setvalue( unsigned char );
	

	protected:
		unsigned char value; // byte

			static int id;
		
};

class StackDouble : public StackItem {
	public:
		StackDouble();
		~StackDouble();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static StackDouble* get( Reader *r, int end, Context *ctx );
		static StackDouble* getByName( const char *name );

		double getvalue();
			void setvalue( double );
	

	protected:
		double value; // double

			static int id;
		
};

class StackInteger : public StackItem {
	public:
		StackInteger();
		~StackInteger();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static StackInteger* get( Reader *r, int end, Context *ctx );
		static StackInteger* getByName( const char *name );

		unsigned int getvalue();
			void setvalue( unsigned int );
	

	protected:
		unsigned int value; // uint32

			static int id;
		
};

class StackDictionaryLookup : public StackItem {
	public:
		StackDictionaryLookup();
		~StackDictionaryLookup();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static StackDictionaryLookup* get( Reader *r, int end, Context *ctx );
		static StackDictionaryLookup* getByName( const char *name );

		unsigned char getindex();
			void setindex( unsigned char );
	

	protected:
		unsigned char index; // byte

			static int id;
		
};

class StackLargeDictionaryLookup : public StackItem {
	public:
		StackLargeDictionaryLookup();
		~StackLargeDictionaryLookup();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static StackLargeDictionaryLookup* get( Reader *r, int end, Context *ctx );
		static StackLargeDictionaryLookup* getByName( const char *name );

		unsigned short getindex();
			void setindex( unsigned short );
	

	protected:
		unsigned short index; // word

			static int id;
		
};

class UnknownAction : public Action {
	public:
		UnknownAction();
		~UnknownAction();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static UnknownAction* get( Reader *r, int end, Context *ctx );
		static UnknownAction* getByName( const char *name );

		
			void getdata( unsigned char **dst, int *size );
			void setdata( const unsigned char *src, int size );
	

	protected:
		unsigned char * data; // data

			static int id;
		
};

class EndAction : public Action {
	public:
		EndAction();
		~EndAction();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static EndAction* get( Reader *r, int end, Context *ctx );
		static EndAction* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class NextFrame : public Action {
	public:
		NextFrame();
		~NextFrame();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static NextFrame* get( Reader *r, int end, Context *ctx );
		static NextFrame* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class PreviousFrame : public Action {
	public:
		PreviousFrame();
		~PreviousFrame();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static PreviousFrame* get( Reader *r, int end, Context *ctx );
		static PreviousFrame* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class Play : public Action {
	public:
		Play();
		~Play();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Play* get( Reader *r, int end, Context *ctx );
		static Play* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class Stop : public Action {
	public:
		Stop();
		~Stop();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Stop* get( Reader *r, int end, Context *ctx );
		static Stop* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class ToggleQuality : public Action {
	public:
		ToggleQuality();
		~ToggleQuality();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static ToggleQuality* get( Reader *r, int end, Context *ctx );
		static ToggleQuality* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class StopSound : public Action {
	public:
		StopSound();
		~StopSound();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static StopSound* get( Reader *r, int end, Context *ctx );
		static StopSound* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class AddCast : public Action {
	public:
		AddCast();
		~AddCast();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static AddCast* get( Reader *r, int end, Context *ctx );
		static AddCast* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class Substract : public Action {
	public:
		Substract();
		~Substract();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Substract* get( Reader *r, int end, Context *ctx );
		static Substract* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class Mulitply : public Action {
	public:
		Mulitply();
		~Mulitply();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Mulitply* get( Reader *r, int end, Context *ctx );
		static Mulitply* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class Divide : public Action {
	public:
		Divide();
		~Divide();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Divide* get( Reader *r, int end, Context *ctx );
		static Divide* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class EqualCast : public Action {
	public:
		EqualCast();
		~EqualCast();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static EqualCast* get( Reader *r, int end, Context *ctx );
		static EqualCast* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class LessThanCast : public Action {
	public:
		LessThanCast();
		~LessThanCast();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static LessThanCast* get( Reader *r, int end, Context *ctx );
		static LessThanCast* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class LogicalAND : public Action {
	public:
		LogicalAND();
		~LogicalAND();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static LogicalAND* get( Reader *r, int end, Context *ctx );
		static LogicalAND* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class LogicalOR : public Action {
	public:
		LogicalOR();
		~LogicalOR();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static LogicalOR* get( Reader *r, int end, Context *ctx );
		static LogicalOR* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class LogicalNOT : public Action {
	public:
		LogicalNOT();
		~LogicalNOT();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static LogicalNOT* get( Reader *r, int end, Context *ctx );
		static LogicalNOT* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class StringEqual : public Action {
	public:
		StringEqual();
		~StringEqual();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static StringEqual* get( Reader *r, int end, Context *ctx );
		static StringEqual* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class StringLength : public Action {
	public:
		StringLength();
		~StringLength();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static StringLength* get( Reader *r, int end, Context *ctx );
		static StringLength* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class SubString : public Action {
	public:
		SubString();
		~SubString();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static SubString* get( Reader *r, int end, Context *ctx );
		static SubString* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class Pop : public Action {
	public:
		Pop();
		~Pop();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Pop* get( Reader *r, int end, Context *ctx );
		static Pop* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class IntegralPart : public Action {
	public:
		IntegralPart();
		~IntegralPart();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static IntegralPart* get( Reader *r, int end, Context *ctx );
		static IntegralPart* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class GetVariable : public Action {
	public:
		GetVariable();
		~GetVariable();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static GetVariable* get( Reader *r, int end, Context *ctx );
		static GetVariable* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class SetVariable : public Action {
	public:
		SetVariable();
		~SetVariable();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static SetVariable* get( Reader *r, int end, Context *ctx );
		static SetVariable* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class SetTargetDynamic : public Action {
	public:
		SetTargetDynamic();
		~SetTargetDynamic();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static SetTargetDynamic* get( Reader *r, int end, Context *ctx );
		static SetTargetDynamic* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class ConcatenateString : public Action {
	public:
		ConcatenateString();
		~ConcatenateString();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static ConcatenateString* get( Reader *r, int end, Context *ctx );
		static ConcatenateString* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class GetProperty : public Action {
	public:
		GetProperty();
		~GetProperty();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static GetProperty* get( Reader *r, int end, Context *ctx );
		static GetProperty* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class SetProperty : public Action {
	public:
		SetProperty();
		~SetProperty();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static SetProperty* get( Reader *r, int end, Context *ctx );
		static SetProperty* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class DuplicateSprite : public Action {
	public:
		DuplicateSprite();
		~DuplicateSprite();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DuplicateSprite* get( Reader *r, int end, Context *ctx );
		static DuplicateSprite* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class RemoveSprite : public Action {
	public:
		RemoveSprite();
		~RemoveSprite();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static RemoveSprite* get( Reader *r, int end, Context *ctx );
		static RemoveSprite* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class Trace : public Action {
	public:
		Trace();
		~Trace();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Trace* get( Reader *r, int end, Context *ctx );
		static Trace* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class StartDrag : public Action {
	public:
		StartDrag();
		~StartDrag();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static StartDrag* get( Reader *r, int end, Context *ctx );
		static StartDrag* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class StopDrag : public Action {
	public:
		StopDrag();
		~StopDrag();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static StopDrag* get( Reader *r, int end, Context *ctx );
		static StopDrag* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class StringLessThan : public Action {
	public:
		StringLessThan();
		~StringLessThan();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static StringLessThan* get( Reader *r, int end, Context *ctx );
		static StringLessThan* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class Throw : public Action {
	public:
		Throw();
		~Throw();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Throw* get( Reader *r, int end, Context *ctx );
		static Throw* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class CastObject : public Action {
	public:
		CastObject();
		~CastObject();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static CastObject* get( Reader *r, int end, Context *ctx );
		static CastObject* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class Implements : public Action {
	public:
		Implements();
		~Implements();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Implements* get( Reader *r, int end, Context *ctx );
		static Implements* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class Random : public Action {
	public:
		Random();
		~Random();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Random* get( Reader *r, int end, Context *ctx );
		static Random* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class MultibyteStringLength : public Action {
	public:
		MultibyteStringLength();
		~MultibyteStringLength();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static MultibyteStringLength* get( Reader *r, int end, Context *ctx );
		static MultibyteStringLength* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class ORD : public Action {
	public:
		ORD();
		~ORD();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static ORD* get( Reader *r, int end, Context *ctx );
		static ORD* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class CHR : public Action {
	public:
		CHR();
		~CHR();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static CHR* get( Reader *r, int end, Context *ctx );
		static CHR* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class GetTimer : public Action {
	public:
		GetTimer();
		~GetTimer();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static GetTimer* get( Reader *r, int end, Context *ctx );
		static GetTimer* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class MultibyteSubString : public Action {
	public:
		MultibyteSubString();
		~MultibyteSubString();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static MultibyteSubString* get( Reader *r, int end, Context *ctx );
		static MultibyteSubString* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class MultibyteORD : public Action {
	public:
		MultibyteORD();
		~MultibyteORD();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static MultibyteORD* get( Reader *r, int end, Context *ctx );
		static MultibyteORD* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class MultibyteCHR : public Action {
	public:
		MultibyteCHR();
		~MultibyteCHR();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static MultibyteCHR* get( Reader *r, int end, Context *ctx );
		static MultibyteCHR* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class Delete : public Action {
	public:
		Delete();
		~Delete();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Delete* get( Reader *r, int end, Context *ctx );
		static Delete* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class DeleteAll : public Action {
	public:
		DeleteAll();
		~DeleteAll();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DeleteAll* get( Reader *r, int end, Context *ctx );
		static DeleteAll* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class SetLocalVariable : public Action {
	public:
		SetLocalVariable();
		~SetLocalVariable();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static SetLocalVariable* get( Reader *r, int end, Context *ctx );
		static SetLocalVariable* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class CallFunction : public Action {
	public:
		CallFunction();
		~CallFunction();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static CallFunction* get( Reader *r, int end, Context *ctx );
		static CallFunction* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class Return : public Action {
	public:
		Return();
		~Return();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Return* get( Reader *r, int end, Context *ctx );
		static Return* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class Modulo : public Action {
	public:
		Modulo();
		~Modulo();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Modulo* get( Reader *r, int end, Context *ctx );
		static Modulo* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class New : public Action {
	public:
		New();
		~New();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static New* get( Reader *r, int end, Context *ctx );
		static New* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class DeclareLocalVariable : public Action {
	public:
		DeclareLocalVariable();
		~DeclareLocalVariable();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DeclareLocalVariable* get( Reader *r, int end, Context *ctx );
		static DeclareLocalVariable* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class DeclareArray : public Action {
	public:
		DeclareArray();
		~DeclareArray();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DeclareArray* get( Reader *r, int end, Context *ctx );
		static DeclareArray* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class DeclareObject : public Action {
	public:
		DeclareObject();
		~DeclareObject();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DeclareObject* get( Reader *r, int end, Context *ctx );
		static DeclareObject* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class TypeOf : public Action {
	public:
		TypeOf();
		~TypeOf();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static TypeOf* get( Reader *r, int end, Context *ctx );
		static TypeOf* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class GetTarget : public Action {
	public:
		GetTarget();
		~GetTarget();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static GetTarget* get( Reader *r, int end, Context *ctx );
		static GetTarget* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class Enumerate : public Action {
	public:
		Enumerate();
		~Enumerate();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Enumerate* get( Reader *r, int end, Context *ctx );
		static Enumerate* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class AddTyped : public Action {
	public:
		AddTyped();
		~AddTyped();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static AddTyped* get( Reader *r, int end, Context *ctx );
		static AddTyped* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class LessThanTyped : public Action {
	public:
		LessThanTyped();
		~LessThanTyped();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static LessThanTyped* get( Reader *r, int end, Context *ctx );
		static LessThanTyped* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class EqualTyped : public Action {
	public:
		EqualTyped();
		~EqualTyped();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static EqualTyped* get( Reader *r, int end, Context *ctx );
		static EqualTyped* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class DefineNumber : public Action {
	public:
		DefineNumber();
		~DefineNumber();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineNumber* get( Reader *r, int end, Context *ctx );
		static DefineNumber* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class DefineString : public Action {
	public:
		DefineString();
		~DefineString();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DefineString* get( Reader *r, int end, Context *ctx );
		static DefineString* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class Duplicate : public Action {
	public:
		Duplicate();
		~Duplicate();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Duplicate* get( Reader *r, int end, Context *ctx );
		static Duplicate* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class Swap : public Action {
	public:
		Swap();
		~Swap();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Swap* get( Reader *r, int end, Context *ctx );
		static Swap* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class GetMember : public Action {
	public:
		GetMember();
		~GetMember();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static GetMember* get( Reader *r, int end, Context *ctx );
		static GetMember* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class SetMember : public Action {
	public:
		SetMember();
		~SetMember();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static SetMember* get( Reader *r, int end, Context *ctx );
		static SetMember* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class Increment : public Action {
	public:
		Increment();
		~Increment();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Increment* get( Reader *r, int end, Context *ctx );
		static Increment* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class Decrement : public Action {
	public:
		Decrement();
		~Decrement();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Decrement* get( Reader *r, int end, Context *ctx );
		static Decrement* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class CallMethod : public Action {
	public:
		CallMethod();
		~CallMethod();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static CallMethod* get( Reader *r, int end, Context *ctx );
		static CallMethod* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class NewMethod : public Action {
	public:
		NewMethod();
		~NewMethod();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static NewMethod* get( Reader *r, int end, Context *ctx );
		static NewMethod* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class InstanceOf : public Action {
	public:
		InstanceOf();
		~InstanceOf();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static InstanceOf* get( Reader *r, int end, Context *ctx );
		static InstanceOf* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class EnumerateObject : public Action {
	public:
		EnumerateObject();
		~EnumerateObject();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static EnumerateObject* get( Reader *r, int end, Context *ctx );
		static EnumerateObject* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class AND : public Action {
	public:
		AND();
		~AND();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static AND* get( Reader *r, int end, Context *ctx );
		static AND* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class OR : public Action {
	public:
		OR();
		~OR();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static OR* get( Reader *r, int end, Context *ctx );
		static OR* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class XOR : public Action {
	public:
		XOR();
		~XOR();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static XOR* get( Reader *r, int end, Context *ctx );
		static XOR* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class ShiftLeft : public Action {
	public:
		ShiftLeft();
		~ShiftLeft();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static ShiftLeft* get( Reader *r, int end, Context *ctx );
		static ShiftLeft* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class ShiftRight : public Action {
	public:
		ShiftRight();
		~ShiftRight();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static ShiftRight* get( Reader *r, int end, Context *ctx );
		static ShiftRight* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class ShiftRightUnsigned : public Action {
	public:
		ShiftRightUnsigned();
		~ShiftRightUnsigned();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static ShiftRightUnsigned* get( Reader *r, int end, Context *ctx );
		static ShiftRightUnsigned* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class StrictEqual : public Action {
	public:
		StrictEqual();
		~StrictEqual();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static StrictEqual* get( Reader *r, int end, Context *ctx );
		static StrictEqual* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class GreaterThanTyped : public Action {
	public:
		GreaterThanTyped();
		~GreaterThanTyped();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static GreaterThanTyped* get( Reader *r, int end, Context *ctx );
		static GreaterThanTyped* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class StringGreaterThan : public Action {
	public:
		StringGreaterThan();
		~StringGreaterThan();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static StringGreaterThan* get( Reader *r, int end, Context *ctx );
		static StringGreaterThan* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class Extends : public Action {
	public:
		Extends();
		~Extends();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Extends* get( Reader *r, int end, Context *ctx );
		static Extends* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class GotoFrame : public Action {
	public:
		GotoFrame();
		~GotoFrame();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static GotoFrame* get( Reader *r, int end, Context *ctx );
		static GotoFrame* getByName( const char *name );

		unsigned short getframe();
			void setframe( unsigned short );
	

	protected:
		unsigned short frame; // word

			static int id;
		
};

class GetURL : public Action {
	public:
		GetURL();
		~GetURL();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static GetURL* get( Reader *r, int end, Context *ctx );
		static GetURL* getByName( const char *name );

		char * geturl();
			void seturl( char * );
	char * gettarget();
			void settarget( char * );
	

	protected:
		char * url; // string
char * target; // string

			static int id;
		
};

class StoreRegister : public Action {
	public:
		StoreRegister();
		~StoreRegister();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static StoreRegister* get( Reader *r, int end, Context *ctx );
		static StoreRegister* getByName( const char *name );

		unsigned char getreg();
			void setreg( unsigned char );
	

	protected:
		unsigned char reg; // byte

			static int id;
		
};

class Dictionary : public Action {
	public:
		Dictionary();
		~Dictionary();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Dictionary* get( Reader *r, int end, Context *ctx );
		static Dictionary* getByName( const char *name );

		unsigned short getlength();
			void setlength( unsigned short );
	List<String> *getstrings();
	

	protected:
		unsigned short length; // word
List<String> strings; // list

			static int id;
		
};

class WaitForFrame : public Action {
	public:
		WaitForFrame();
		~WaitForFrame();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static WaitForFrame* get( Reader *r, int end, Context *ctx );
		static WaitForFrame* getByName( const char *name );

		unsigned short getframe();
			void setframe( unsigned short );
	unsigned char getskip();
			void setskip( unsigned char );
	

	protected:
		unsigned short frame; // word
unsigned char skip; // byte

			static int id;
		
};

class SetTarget : public Action {
	public:
		SetTarget();
		~SetTarget();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static SetTarget* get( Reader *r, int end, Context *ctx );
		static SetTarget* getByName( const char *name );

		char * getlabel();
			void setlabel( char * );
	

	protected:
		char * label; // string

			static int id;
		
};

class GotoLabel : public Action {
	public:
		GotoLabel();
		~GotoLabel();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static GotoLabel* get( Reader *r, int end, Context *ctx );
		static GotoLabel* getByName( const char *name );

		char * getlabel();
			void setlabel( char * );
	

	protected:
		char * label; // string

			static int id;
		
};

class WaitForFrameDynamic : public Action {
	public:
		WaitForFrameDynamic();
		~WaitForFrameDynamic();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static WaitForFrameDynamic* get( Reader *r, int end, Context *ctx );
		static WaitForFrameDynamic* getByName( const char *name );

		unsigned short getframe();
			void setframe( unsigned short );
	unsigned char getskip();
			void setskip( unsigned char );
	

	protected:
		unsigned short frame; // word
unsigned char skip; // byte

			static int id;
		
};

class DeclareFunction2 : public Action {
	public:
		DeclareFunction2();
		~DeclareFunction2();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DeclareFunction2* get( Reader *r, int end, Context *ctx );
		static DeclareFunction2* getByName( const char *name );

		char * getname();
			void setname( char * );
	unsigned short getargc();
			void setargc( unsigned short );
	unsigned char getregc();
			void setregc( unsigned char );
	bool getpreloadThis();
			void setpreloadThis( bool );
	bool getsuppressThis();
			void setsuppressThis( bool );
	bool getpreloadArguments();
			void setpreloadArguments( bool );
	bool getsuppressArguments();
			void setsuppressArguments( bool );
	bool getpreloadSuper();
			void setpreloadSuper( bool );
	bool getsuppressSuper();
			void setsuppressSuper( bool );
	bool getpreloadRoot();
			void setpreloadRoot( bool );
	bool getpreloadParent();
			void setpreloadParent( bool );
	bool getpreloadGlobal();
			void setpreloadGlobal( bool );
	int getreserved();
			void setreserved( int );
	List<Parameter> *getargs();
	unsigned short getlength();
			void setlength( unsigned short );
	List<Action> *getactions();
	

	protected:
		char * name; // string
unsigned short argc; // word
unsigned char regc; // byte
bool preloadThis; // bit
bool suppressThis; // bit
bool preloadArguments; // bit
bool suppressArguments; // bit
bool preloadSuper; // bit
bool suppressSuper; // bit
bool preloadRoot; // bit
bool preloadParent; // bit
bool preloadGlobal; // bit
int reserved; // integer
List<Parameter> args; // list
unsigned short length; // word
List<Action> actions; // list

			static int id;
		
};

class Try : public Action {
	public:
		Try();
		~Try();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static Try* get( Reader *r, int end, Context *ctx );
		static Try* getByName( const char *name );

		int getreserved();
			void setreserved( int );
	bool getcatchInRegister();
			void setcatchInRegister( bool );
	bool getdoFinally();
			void setdoFinally( bool );
	bool getdoCatch();
			void setdoCatch( bool );
	unsigned short gettrySize();
			void settrySize( unsigned short );
	unsigned short getcatchSize();
			void setcatchSize( unsigned short );
	unsigned short getfinallySize();
			void setfinallySize( unsigned short );
	unsigned char getreg();
			void setreg( unsigned char );
	

	protected:
		int reserved; // integer
bool catchInRegister; // bit
bool doFinally; // bit
bool doCatch; // bit
unsigned short trySize; // word
unsigned short catchSize; // word
unsigned short finallySize; // word
unsigned char reg; // byte

			static int id;
		
};

class With : public Action {
	public:
		With();
		~With();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static With* get( Reader *r, int end, Context *ctx );
		static With* getByName( const char *name );

		unsigned short getsize();
			void setsize( unsigned short );
	

	protected:
		unsigned short size; // word

			static int id;
		
};

class PushData : public Action {
	public:
		PushData();
		~PushData();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static PushData* get( Reader *r, int end, Context *ctx );
		static PushData* getByName( const char *name );

		List<StackItem> *getitems();
	

	protected:
		List<StackItem> items; // list

			static int id;
		
};

class GetURL2 : public Action {
	public:
		GetURL2();
		~GetURL2();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static GetURL2* get( Reader *r, int end, Context *ctx );
		static GetURL2* getByName( const char *name );

		unsigned char getmethod();
			void setmethod( unsigned char );
	

	protected:
		unsigned char method; // byte

			static int id;
		
};

class DeclareFunction : public Action {
	public:
		DeclareFunction();
		~DeclareFunction();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static DeclareFunction* get( Reader *r, int end, Context *ctx );
		static DeclareFunction* getByName( const char *name );

		char * getname();
			void setname( char * );
	unsigned short getargc();
			void setargc( unsigned short );
	List<String> *getargs();
	unsigned short getlength();
			void setlength( unsigned short );
	

	protected:
		char * name; // string
unsigned short argc; // word
List<String> args; // list
unsigned short length; // word

			static int id;
		
};

class BranchAlways : public Action {
	public:
		BranchAlways();
		~BranchAlways();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static BranchAlways* get( Reader *r, int end, Context *ctx );
		static BranchAlways* getByName( const char *name );

		unsigned short getbyteOffset();
			void setbyteOffset( unsigned short );
	

	protected:
		unsigned short byteOffset; // word

			static int id;
		
};

class BranchIfTrue : public Action {
	public:
		BranchIfTrue();
		~BranchIfTrue();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static BranchIfTrue* get( Reader *r, int end, Context *ctx );
		static BranchIfTrue* getByName( const char *name );

		unsigned short getbyteOffset();
			void setbyteOffset( unsigned short );
	

	protected:
		unsigned short byteOffset; // word

			static int id;
		
};

class CallFrame : public Action {
	public:
		CallFrame();
		~CallFrame();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static CallFrame* get( Reader *r, int end, Context *ctx );
		static CallFrame* getByName( const char *name );

		

	protected:
		
			static int id;
		
};

class GotoExpression : public Action {
	public:
		GotoExpression();
		~GotoExpression();
		
		virtual bool parse( Reader *r, int end, Context *ctx );
		virtual void dump( int indent, Context *ctx );
		virtual size_t calcSize( Context *ctx, int start_at );
		virtual void write( Writer *w, Context *ctx );
		virtual void writeXML( xmlNodePtr xml, Context *ctx );
		virtual void parseXML( xmlNodePtr xml, Context *ctx );
		
		static GotoExpression* get( Reader *r, int end, Context *ctx );
		static GotoExpression* getByName( const char *name );

		unsigned char getplay();
			void setplay( unsigned char );
	

	protected:
		unsigned char play; // byte

			static int id;
		
};


}
#endif
