#include "xslt.h"
const char *xslt_library = 
"<?xml version=\"1.0\"?>\n"
"<xsl:stylesheet	xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" \n"
"				xmlns:swft=\"http://subsignal.org/swfml/swft\"\n"
"				extension-element-prefixes=\"swft\"\n"
"				version='1.0'>\n"
"\n"
"<xsl:output method=\"xml\" indent=\"yes\"/>\n"
"\n"
"<!-- basic SWF setup -->\n"
"<xsl:template match=\"movie\">\n"
"	<!-- set defaults for movie -->\n"
"	<xsl:variable name=\"version\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@version\"><xsl:value-of select=\"@version\"/></xsl:when>\n"
"			<xsl:otherwise>7</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"compressed\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@compressed\"><xsl:value-of select=\"@compressed\"/></xsl:when>\n"
"			<xsl:otherwise>1</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"framerate\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@framerate\"><xsl:value-of select=\"@framerate\"/></xsl:when>\n"
"			<xsl:otherwise>12</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"frames\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@frames\"><xsl:value-of select=\"@frames\"/></xsl:when>\n"
"			<xsl:otherwise>1</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"left\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@left\"><xsl:value-of select=\"@left * 20\"/></xsl:when>\n"
"			<xsl:otherwise>0</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"top\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@top\"><xsl:value-of select=\"@top * 20\"/></xsl:when>\n"
"			<xsl:otherwise>0</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"right\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@width\"><xsl:value-of select=\"$left + (@width * 20)\"/></xsl:when>\n"
"			<xsl:otherwise>6400</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"bottom\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@height\"><xsl:value-of select=\"$top + (@height * 20)\"/></xsl:when>\n"
"			<xsl:otherwise>4800</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"\n"
"	<swf version=\"{$version}\" compressed=\"{$compressed}\">\n"
"		<Header framerate=\"{$framerate}\" frames=\"{$frames}\">\n"
"			<size>\n"
"				<Rectangle left=\"{$left}\" right=\"{$right}\" top=\"{$top}\" bottom=\"{$bottom}\"/>\n"
"			</size>\n"
"			<tags>\n"
"				<xsl:apply-templates/>\n"
"				\n"
"				<ShowFrame/>\n"
"				<End/>\n"
"			</tags>\n"
"		</Header>\n"
"	</swf>\n"
"</xsl:template>\n"
"\n"
"<!-- background color -->\n"
"<xsl:template match=\"background\">\n"
"	<xsl:variable name=\"red\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@red\"><xsl:value-of select=\"@red\"/></xsl:when>\n"
"			<xsl:when test=\"@color\">0x<xsl:value-of select=\"substring(@color,2,2)\"/></xsl:when>\n"
"			<xsl:otherwise>200</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"green\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@green\"><xsl:value-of select=\"@green\"/></xsl:when>\n"
"			<xsl:when test=\"@color\">0x<xsl:value-of select=\"substring(@color,4,2)\"/></xsl:when>\n"
"			<xsl:otherwise>200</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"blue\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@blue\"><xsl:value-of select=\"@blue\"/></xsl:when>\n"
"			<xsl:when test=\"@color\">0x<xsl:value-of select=\"substring(@color,6)\"/></xsl:when>\n"
"			<xsl:otherwise>200</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"\n"
"	<SetBackgroundColor>\n"
"		<color>\n"
"			<Color red=\"{$red}\" green=\"{$green}\" blue=\"{$blue}\"/>\n"
"		</color>\n"
"	</SetBackgroundColor>\n"
"</xsl:template>\n"
"\n"
"<!-- library just passes thru, children decide wether to expord by themselves -->\n"
"<xsl:template match=\"library\">\n"
"	<xsl:apply-templates/>\n"
"</xsl:template>\n"
"\n"
"<!-- linkage export -->\n"
"<xsl:template match=\"@id\" mode=\"export\">\n"
"	<xsl:param name=\"id\"/>\n"
"	<Export count=\"1\">\n"
"		<symbols>\n"
"			<Symbol objectID=\"{$id}\">\n"
"				<xsl:attribute name=\"name\"><xsl:value-of select=\".\"/></xsl:attribute>\n"
"			</Symbol>\n"
"		</symbols>\n"
"	</Export>\n"
"</xsl:template>\n"
"<xsl:template match=\"@*\" mode=\"export\" priority=\"-1\"/>\n"
"\n"
"<!-- place -->\n"
"<xsl:template match=\"place\">\n"
"	<xsl:variable name=\"id\">\n"
"		<xsl:value-of select=\"swft:map-id(@id)\"/>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"x\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@x\"><xsl:value-of select=\"@x * 20\"/></xsl:when>\n"
"			<xsl:otherwise>0</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"y\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@y\"><xsl:value-of select=\"@y * 20\"/></xsl:when>\n"
"			<xsl:otherwise>0</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"scale\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@scale\"><xsl:value-of select=\"@scale\"/></xsl:when>\n"
"			<xsl:otherwise>1</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"depth\"><xsl:value-of select=\"@depth\"/></xsl:variable>\n"
"	\n"
"	<!-- if we have a former place with the same depth, use morph=\"1\" replace=\"0\"\n"
"		 using morph=\"0\" and replace=\"1\" only works for the same objectID\n"
"		 that is already placed in layer (depth) -->\n"
"	<xsl:variable name=\"replace\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"preceding-sibling::place[@depth=$depth]\">1</xsl:when>\n"
"			<xsl:otherwise>0</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:if test=\"$replace = '1'\">\n"
"		<RemoveObject2 depth=\"{@depth}\"/>\n"
"	</xsl:if>\n"
"	<PlaceObject2 replace=\"0\" morph=\"{$replace}\" depth=\"{$depth}\" objectID=\"{$id}\">\n"
"		<transform>\n"
"			<Transform transX=\"{$x}\" transY=\"{$y}\" scaleX=\"{$scale}\" scaleY=\"{$scale}\"/>\n"
"		</transform>\n"
"	</PlaceObject2>\n"
"</xsl:template>\n"
"\n"
"<!-- transform -->\n"
"<xsl:template match=\"transform\">\n"
"	<xsl:variable name=\"id\">\n"
"		<xsl:value-of select=\"swft:map-id(@id)\"/>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"myid\">\n"
"		<xsl:value-of select=\"@id\"/>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"x\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@x\"><xsl:value-of select=\"@x * 20\"/></xsl:when>\n"
"			<xsl:otherwise>0</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"y\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@y\"><xsl:value-of select=\"@y * 20\"/></xsl:when>\n"
"			<xsl:otherwise>0</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"scale\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@scale\"><xsl:value-of select=\"@scale\"/></xsl:when>\n"
"			<xsl:otherwise>1</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"depth\">\n"
"		<xsl:value-of select=\"preceding-sibling::place[@id=$myid]/@depth\"/>\n"
"	</xsl:variable>\n"
"	\n"
"	<PlaceObject2 replace=\"1\" depth=\"{$depth}\" objectID=\"{$id}\">\n"
"		<transform>\n"
"			<Transform transX=\"{$x}\" transY=\"{$y}\" scaleX=\"{$scale}\" scaleY=\"{$scale}\"/>\n"
"		</transform>\n"
"	</PlaceObject2>\n"
"</xsl:template>\n"
"\n"
"<!-- texfield -->\n"
"<xsl:template match=\"textfield\">\n"
"	<xsl:variable name=\"id\">\n"
"		<xsl:value-of select=\"swft:map-id(@id)\"/>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"x\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@x\"><xsl:value-of select=\"@x * 20\"/></xsl:when>\n"
"			<xsl:otherwise>0</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"y\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@y\"><xsl:value-of select=\"@y * 20\"/></xsl:when>\n"
"			<xsl:otherwise>0</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"width\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@width\"><xsl:value-of select=\"@width * 20\"/></xsl:when>\n"
"			<xsl:otherwise>100</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"height\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@height\"><xsl:value-of select=\"@height * 20\"/></xsl:when>\n"
"			<xsl:otherwise>100</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"size\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@size\"><xsl:value-of select=\"@size * 20\"/></xsl:when>\n"
"			<xsl:otherwise>240</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"\n"
"	<DefineEditText objectID=\"{$id}\" wordWrap=\"1\" multiLine=\"1\" password=\"0\" readOnly=\"0\" autoSize=\"0\" hasLayout=\"1\"\n"
"		notSelectable=\"0\" hasBorder=\"0\" isHTML=\"0\" useOutlines=\"1\" \n"
"		fontRef=\"{swft:map-id(@font)}\" fontHeight=\"{$size}\"\n"
"		align=\"0\" leftMargin=\"0\" rightMargin=\"0\" indent=\"0\" leading=\"40\" \n"
"		variableName=\"{@name}\" initialText=\"{@text}\">\n"
"		<size>\n"
"			<Rectangle left=\"{$x}\" right=\"{$x + $width}\" top=\"{$y}\" bottom=\"{$y + $height}\"/>\n"
"		</size>\n"
"		<color>\n"
"			<ColorRGBA red=\"51\" green=\"51\" blue=\"51\" alpha=\"255\"/>\n"
"		</color>\n"
"	</DefineEditText>\n"
"\n"
"</xsl:template>\n"
"\n"
"<!-- clip -->\n"
"<xsl:template match=\"clip[@import]\">\n"
"	<xsl:variable name=\"id\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@id\">\n"
"				<xsl:value-of select=\"swft:map-id(@id)\"/>\n"
"			</xsl:when>\n"
"			<xsl:otherwise>\n"
"				<xsl:value-of select=\"swft:next-id()\"/>\n"
"			</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"file\">\n"
"		<xsl:value-of select=\"@import\"/>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"ext\">\n"
"		<xsl:value-of select=\"translate(substring-after(@import,'.'),'ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz')\"/>\n"
"	</xsl:variable>\n"
"	<xsl:choose>\n"
"		<xsl:when test=\"$ext = 'jpg' or $ext = 'jpeg'\">\n"
"			<xsl:apply-templates select=\"swft:import-jpeg($file)\" mode=\"makeswf\">\n"
"				<xsl:with-param name=\"id\"><xsl:value-of select=\"$id\"/></xsl:with-param>\n"
"			</xsl:apply-templates>\n"
"		</xsl:when>\n"
"		<xsl:when test=\"$ext = 'png'\">\n"
"			<xsl:apply-templates select=\"swft:import-png($file)\" mode=\"makeswf\">\n"
"				<xsl:with-param name=\"id\"><xsl:value-of select=\"$id\"/></xsl:with-param>\n"
"			</xsl:apply-templates>\n"
"		</xsl:when>\n"
"		<xsl:when test=\"$ext = 'swf'\">\n"
"			<xsl:apply-templates select=\"swft:document($file)\" mode=\"makeswf\">\n"
"				<xsl:with-param name=\"id\"><xsl:value-of select=\"$id\"/></xsl:with-param>\n"
"			</xsl:apply-templates>\n"
"		</xsl:when>\n"
"		<xsl:when test=\"$ext = 'ttf'\">\n"
"			<xsl:apply-templates select=\"swft:import-ttf($file,@glyphs)\" mode=\"makeswf\">\n"
"				<xsl:with-param name=\"id\"><xsl:value-of select=\"$id\"/></xsl:with-param>\n"
"			</xsl:apply-templates>\n"
"		</xsl:when>\n"
"	</xsl:choose>\n"
"	<xsl:if test=\"ancestor::library\">\n"
"		<xsl:apply-templates select=\"*|@*\" mode=\"export\">\n"
"			<xsl:with-param name=\"id\"><xsl:value-of select=\"$id\"/></xsl:with-param>\n"
"		</xsl:apply-templates>\n"
"	</xsl:if>\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"font[@import]\">\n"
"	<xsl:variable name=\"id\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@id\">\n"
"				<xsl:value-of select=\"swft:map-id(@id)\"/>\n"
"			</xsl:when>\n"
"			<xsl:otherwise>\n"
"				<xsl:value-of select=\"swft:next-id()\"/>\n"
"			</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"	<xsl:variable name=\"file\">\n"
"		<xsl:value-of select=\"@import\"/>\n"
"	</xsl:variable>\n"
"	\n"
"	<xsl:apply-templates select=\"swft:import-ttf($file,@glyphs)\" mode=\"makeswf\">\n"
"		<xsl:with-param name=\"id\"><xsl:value-of select=\"$id\"/></xsl:with-param>\n"
"	</xsl:apply-templates>\n"
"</xsl:template>\n"
"\n"
"<!-- JPEG import -->\n"
"<xsl:template match=\"jpeg\" mode=\"makeswf\">\n"
"	<xsl:param name=\"id\"/>\n"
"	<xsl:variable name=\"bitmapID\"><xsl:value-of select=\"swft:next-id()\"/></xsl:variable> \n"
"	<xsl:variable name=\"shapeID\"><xsl:value-of select=\"swft:next-id()\"/></xsl:variable> \n"
"	<DefineBitsJPEG2 objectID=\"{$bitmapID}\">\n"
"		<data>\n"
"			<xsl:copy-of select=\"data\"/>\n"
"		</data>\n"
"	</DefineBitsJPEG2>\n"
"	<DefineShape objectID=\"{$shapeID}\">\n"
"		<bounds>\n"
"			<Rectangle left=\"0\" right=\"{@width}\" top=\"0\" bottom=\"{@width}\"/>\n"
"		</bounds>\n"
"		<styles>\n"
"			<StyleList>\n"
"				<fillStyles>\n"
"					<ClippedBitmap objectID=\"{$bitmapID}\">\n"
"						<matrix>\n"
"							<Transform transX=\"0\" transY=\"0\"/>\n"
"						</matrix>\n"
"					</ClippedBitmap>\n"
"				</fillStyles>\n"
"				<lineStyles/>\n"
"			</StyleList>\n"
"		</styles>\n"
"		<shapes>\n"
"			<Shape>\n"
"				<edges>\n"
"					<ShapeSetup x=\"{@width}\" y=\"{@height}\" fillStyle1=\"1\"/>\n"
"					<LineTo x=\"-{@width}\" y=\"0\"/>\n"
"					<LineTo x=\"0\" y=\"-{@height}\"/>\n"
"					<LineTo x=\"{@width}\" y=\"0\"/>\n"
"					<LineTo x=\"0\" y=\"{@height}\"/>\n"
"					<ShapeSetup/>\n"
"				</edges>\n"
"			</Shape>\n"
"		</shapes>\n"
"	</DefineShape>\n"
"	<DefineSprite objectID=\"{$id}\" frames=\"1\">\n"
"		<tags>\n"
"			<PlaceObject2 replace=\"0\" depth=\"1\" objectID=\"{$shapeID}\">\n"
"				<transform>\n"
"					<Transform transX=\"0\" transY=\"0\" scaleX=\"20\" scaleY=\"20\"/>\n"
"				</transform>\n"
"			</PlaceObject2>\n"
"			<ShowFrame/>\n"
"			<End/>\n"
"		</tags>\n"
"	</DefineSprite>\n"
"</xsl:template>\n"
"\n"
"<!-- PNG import -->\n"
"<xsl:template match=\"png\" mode=\"makeswf\">\n"
"	<xsl:param name=\"id\"/>\n"
"	<xsl:variable name=\"bitmapID\"><xsl:value-of select=\"swft:next-id()\"/></xsl:variable> \n"
"	<xsl:variable name=\"shapeID\"><xsl:value-of select=\"swft:next-id()\"/></xsl:variable> \n"
"	<DefineBitsLossless2 format=\"{@format}\" width=\"{@width}\" height=\"{@height}\" objectID=\"{$bitmapID}\">\n"
"		<data>\n"
"			<xsl:copy-of select=\"data\"/>\n"
"		</data>\n"
"	</DefineBitsLossless2>\n"
"	<DefineShape objectID=\"{$shapeID}\">\n"
"		<bounds>\n"
"			<Rectangle left=\"0\" right=\"{@width}\" top=\"0\" bottom=\"{@width}\"/>\n"
"		</bounds>\n"
"		<styles>\n"
"			<StyleList>\n"
"				<fillStyles>\n"
"					<ClippedBitmap objectID=\"{$bitmapID}\">\n"
"						<matrix>\n"
"							<Transform transX=\"0\" transY=\"0\"/>\n"
"						</matrix>\n"
"					</ClippedBitmap>\n"
"				</fillStyles>\n"
"				<lineStyles/>\n"
"			</StyleList>\n"
"		</styles>\n"
"		<shapes>\n"
"			<Shape>\n"
"				<edges>\n"
"					<ShapeSetup x=\"{@width}\" y=\"{@height}\" fillStyle1=\"1\"/>\n"
"					<LineTo x=\"-{@width}\" y=\"0\"/>\n"
"					<LineTo x=\"0\" y=\"-{@height}\"/>\n"
"					<LineTo x=\"{@width}\" y=\"0\"/>\n"
"					<LineTo x=\"0\" y=\"{@height}\"/>\n"
"					<ShapeSetup/>\n"
"				</edges>\n"
"			</Shape>\n"
"		</shapes>\n"
"	</DefineShape>\n"
"	<DefineSprite objectID=\"{$id}\" frames=\"1\">\n"
"		<tags>\n"
"			<PlaceObject2 replace=\"0\" depth=\"1\" objectID=\"{$shapeID}\">\n"
"				<transform>\n"
"					<Transform transX=\"0\" transY=\"0\" scaleX=\"20\" scaleY=\"20\"/>\n"
"				</transform>\n"
"			</PlaceObject2>\n"
"			<ShowFrame/>\n"
"			<End/>\n"
"		</tags>\n"
"	</DefineSprite>\n"
"</xsl:template>\n"
"\n"
"\n"
"<!-- SWF import -->\n"
"<xsl:template match=\"swf\" mode=\"makeswf\">\n"
"	<swft:push-map/>\n"
"	<xsl:param name=\"id\"/>\n"
"	<xsl:variable name=\"swfID\"><xsl:value-of select=\"swft:next-id()\"/></xsl:variable> \n"
"	\n"
"	<xsl:apply-templates select=\"Header/tags/*\" mode=\"sprite-global\"/>\n"
"		\n"
"	<DefineSprite objectID=\"{$swfID}\" frames=\"{count(Header/tags/ShowFrame)}\">\n"
"		<tags>\n"
"			<xsl:apply-templates select=\"Header/tags/*\" mode=\"sprite-local\"/>\n"
"		</tags>\n"
"	</DefineSprite>\n"
"	<DefineSprite objectID=\"{$id}\" frames=\"1\">\n"
"		<tags>\n"
"			<PlaceObject2 replace=\"0\" depth=\"1\" objectID=\"{$swfID}\">\n"
"				<transform>\n"
"					<Transform transX=\"0\" transY=\"0\" />\n"
"				</transform>\n"
"			</PlaceObject2>\n"
"			<ShowFrame/>\n"
"			<End/>\n"
"		</tags>\n"
"	</DefineSprite>\n"
"	<swft:pop-map/>\n"
"</xsl:template>\n"
"\n"
"<!-- global id remapping -->\n"
"<xsl:template match=\"@objectID|@fontRef\" mode=\"idmap\">\n"
"	<xsl:attribute name=\"{name()}\"><xsl:value-of select=\"swft:map-id(.)\"/></xsl:attribute>\n"
"</xsl:template>\n"
"<xsl:template match=\"*|@*|text()\" mode=\"idmap\" priority=\"-1\">\n"
"	<xsl:copy select=\".\">\n"
"		<xsl:apply-templates select=\"*|@*|text()\" mode=\"idmap\"/>\n"
"	</xsl:copy>\n"
"</xsl:template>\n"
"\n"
"<!-- for tags that are \"globalized\" -->\n"
"<xsl:template match=\"SetBackgroundColor\" mode=\"sprite-global\"/>\n"
"<xsl:template match=\"DoAction|End|FrameLabel|PlaceObject|PlaceObject2|RemoveObject|RemoveObject2|ShowFrame|SoundStreamBlock|SoundStreamHead|StartSound\" mode=\"sprite-global\"/>\n"
"<xsl:template match=\"*|@*|text()\" mode=\"sprite-global\" priority=\"-1\">\n"
"	<xsl:apply-templates select=\".\" mode=\"idmap\"/>\n"
"</xsl:template>\n"
"\n"
"<!-- for tags that move into the DefineSprite -->\n"
"<xsl:template match=\"DoAction|End|FrameLabel|PlaceObject|PlaceObject2|RemoveObject|RemoveObject2|ShowFrame|SoundStreamBlock|SoundStreamHead|StartSound\" mode=\"sprite-local\">\n"
"	<xsl:apply-templates select=\".\" mode=\"idmap\"/>\n"
"</xsl:template>\n"
"<xsl:template match=\"*|@*|text()\" mode=\"sprite-local\" priority=\"-1\"/>\n"
"\n"
"\n"
"<!-- import SWF as shared library -->\n"
"<!--\n"
"<xsl:template match=\"swf\">\n"
"	<xsl:variable name=\"id\">\n"
"		<xsl:choose>\n"
"			<xsl:when test=\"@id\">\n"
"				<xsl:value-of select=\"swft:map-id(@id)\"/>\n"
"			</xsl:when>\n"
"			<xsl:otherwise>\n"
"				<xsl:value-of select=\"swft:next-id()\"/>\n"
"			</xsl:otherwise>\n"
"		</xsl:choose>\n"
"	</xsl:variable>\n"
"\n"
"	<xsl:apply-templates select=\"swft:document(@file)\" mode=\"makeswf\">\n"
"		<xsl:with-param name=\"id\"><xsl:value-of select=\"$id\"/></xsl:with-param>\n"
"	</xsl:apply-templates>\n"
"	\n"
"	<xsl:apply-templates select=\"*|@*\" mode=\"export\">\n"
"		<xsl:with-param name=\"id\"><xsl:value-of select=\"$id\"/></xsl:with-param>\n"
"	</xsl:apply-templates>\n"
"\n"
"</xsl:template>\n"
"\n"
"<xsl:template match=\"swf\" mode=\"makeswf\">\n"
"	<swft:push-map/>\n"
"	<xsl:param name=\"id\"/>\n"
"	<xsl:variable name=\"swfID\"><xsl:value-of select=\"swft:next-id()\"/></xsl:variable> \n"
"	\n"
"	<xsl:apply-templates select=\"Header/tags/*\" mode=\"sprite-global\"/>\n"
"		\n"
"	<DefineSprite objectID=\"{$swfID}\" frames=\"{count(Header/tags/ShowFrame)}\">\n"
"		<tags>\n"
"			<xsl:apply-templates select=\"Header/tags/*\" mode=\"sprite-local\"/>\n"
"		</tags>\n"
"	</DefineSprite>\n"
"	<DefineSprite objectID=\"{$id}\" frames=\"1\">\n"
"		<tags>\n"
"			<PlaceObject2 replace=\"0\" depth=\"1\" objectID=\"{$swfID}\">\n"
"				<transform>\n"
"					<Transform transX=\"0\" transY=\"0\" />\n"
"				</transform>\n"
"			</PlaceObject2>\n"
"			<ShowFrame/>\n"
"			<End/>\n"
"		</tags>\n"
"	</DefineSprite>\n"
"	<swft:pop-map/>\n"
"</xsl:template>\n"
"-->\n"
"\n"
"<!-- TTF import -->\n"
"<xsl:template match=\"ttf\" mode=\"makeswf\">\n"
"	<xsl:param name=\"id\"/>\n"
"	<DefineFont2 objectID=\"{$id}\" name=\"{@name}\">\n"
"		<xsl:apply-templates select=\"DefineFont2/*|DefineFont2/@*[name() != 'objectID']\"/>\n"
"	</DefineFont2>\n"
"</xsl:template>\n"
"\n"
"\n"
"<!-- HTML wrapper -->\n"
"<xsl:template match=\"html-wrapper\">\n"
"	<xsl:document href=\"{@name}\">\n"
"<html>\n"
"	<body>\n"
"	<object classid=\"clsid:d27cdb6e-ae6d-11cf-96b8-444553540000\" \n"
"			codebase=\"http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=7,0,0,0\" \n"
"			width=\"{/movie/@width}\" height=\"{/movie/@width}\" id=\"video\" align=\"middle\">\n"
"		<param name=\"allowScriptAccess\" value=\"sameDomain\" />\n"
"		<param name=\"movie\" value=\"{@swf}\" />\n"
"		<param name=\"quality\" value=\"high\" />\n"
"		<embed src=\"{@swf}\" quality=\"high\" \n"
"			width=\"{/movie/@width}\" height=\"{/movie/@height}\" name=\"video\" align=\"middle\" allowScriptAccess=\"sameDomain\" \n"
"			type=\"application/x-shockwave-flash\" pluginspage=\"http://www.macromedia.com/go/getflashplayer\" />\n"
"	</object>\n"
"	</body>\n"
"</html>\n"
"	</xsl:document>\n"
"</xsl:template>\n"
"\n"
"<!-- copy anything else -->\n"
"<xsl:template match=\"*|@*|text()\" priority=\"-1\">\n"
"	<xsl:copy select=\".\">\n"
"		<xsl:apply-templates select=\"*|@*|text()\"/>\n"
"	</xsl:copy>\n"
"</xsl:template>\n"
"\n"
"</xsl:stylesheet>\n"
;
