

#include "SWF.h"
#include "SWFItem.h"
#include "SWFList.h"

namespace SWF {


//////////////////////////////////// Rectangle

void Rectangle::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE Rectangle @%i\n", start/8 );
		dump(1,ctx);
	}
	
	w->putNBitInt(bits,5);
	w->putNBitInt(left,bits,true);
	w->putNBitInt(right,bits,true);
	w->putNBitInt(top,bits,true);
	w->putNBitInt(bottom,bits,true);
	
	w->byteAlign();


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: Rectangle has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// Color

void Color::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE Color @%i\n", start/8 );
		dump(1,ctx);
	}
	
	w->putByte(red);
	w->putByte(green);
	w->putByte(blue);
	
	w->byteAlign();


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: Color has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// ColorRGBA

void ColorRGBA::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE ColorRGBA @%i\n", start/8 );
		dump(1,ctx);
	}
	
	w->putByte(red);
	w->putByte(green);
	w->putByte(blue);
	w->putByte(alpha);
	
	w->byteAlign();


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: ColorRGBA has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// String

void String::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE String @%i\n", start/8 );
		dump(1,ctx);
	}
	
	w->putString(value);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: String has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// Transform

void Transform::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE Transform @%i\n", start/8 );
		dump(1,ctx);
	}
	
	w->putNBitInt(scaled,1);
	
	if( scaled ) {
	
		w->putNBitInt(bitsScale,5);
	w->putNBitFixed(scaleX,bitsScale,16,true);
	w->putNBitFixed(scaleY,bitsScale,16,true);
	
	}
w->putNBitInt(skewed,1);
	
	if( skewed ) {
	
		w->putNBitInt(bitsSkew,5);
	w->putNBitFixed(skewX,bitsSkew,16,true);
	w->putNBitFixed(skewY,bitsSkew,16,true);
	
	}
w->putNBitInt(bitsTranslate,5);
	w->putNBitInt(transX,bitsTranslate,true);
	w->putNBitInt(transY,bitsTranslate,true);
	
	w->byteAlign();


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: Transform has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// ColorTransform2

void ColorTransform2::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE ColorTransform2 @%i\n", start/8 );
		dump(1,ctx);
	}
	
	w->putNBitInt(hasOffset,1);
	w->putNBitInt(hasFactor,1);
	w->putNBitInt(bits,4);
	
	if( hasFactor ) {
	
		w->putNBitInt(factorRed,bits,true);
	w->putNBitInt(factorGreen,bits,true);
	w->putNBitInt(factorBlue,bits,true);
	w->putNBitInt(factorAlpha,bits,true);
	
	}

	if( hasOffset ) {
	
		w->putNBitInt(offsetRed,bits,true);
	w->putNBitInt(offsetGreen,bits,true);
	w->putNBitInt(offsetBlue,bits,true);
	w->putNBitInt(offsetAlpha,bits,true);
	
	}

	w->byteAlign();


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: ColorTransform2 has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// Header

void Header::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE Header @%i\n", start/8 );
		dump(1,ctx);
	}
	
	size.write(w,ctx);
w->putNBitInt(framerate,16);
	w->putWord(frames);
	
	{
		int start = w->getPosition();
		Tag *item;
		ListItem<Tag>* i;
		i = tags.first();
		while( i ) {
			if( !i->data() ) {
				printf("WARNING: list tags has an invalid item\n" );
			} else {
				ctx->isLast = i->isLast();
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: Header has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// LineStyle

void LineStyle::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE LineStyle @%i\n", start/8 );
		dump(1,ctx);
	}
	
	w->putWord(width);
	color.write(w,ctx);


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: LineStyle has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// StyleList

void StyleList::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE StyleList @%i\n", start/8 );
		dump(1,ctx);
	}
	
	w->putByte(n_fillStyles);
	
	{
		Style *item;
		ListItem<Style>* i;
		i = fillStyles.first();
		for( int j=0; j<n_fillStyles; j++ ) {
			if( !i || !i->data() ) {
				printf("WARNING: list fillStyles has %i items (%i expected)\n", j, n_fillStyles );
			} else {
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}
w->putByte(n_lineStyles);
	
	{
		LineStyle *item;
		ListItem<LineStyle>* i;
		i = lineStyles.first();
		for( int j=0; j<n_lineStyles; j++ ) {
			if( !i || !i->data() ) {
				printf("WARNING: list lineStyles has %i items (%i expected)\n", j, n_lineStyles );
			} else {
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: StyleList has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// ShapeSetup

void ShapeSetup::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE ShapeSetup @%i\n", start/8 );
		dump(1,ctx);
	}
	
	ShapeItem::writeHeader( w, ctx, getSize(ctx)/8 );
		w->putNBitInt(hasNewStyles,1);
	w->putNBitInt(hasLineStyle,1);
	w->putNBitInt(hasFillStyle1,1);
	w->putNBitInt(hasFillStyle0,1);
	w->putNBitInt(hasMoveTo,1);
	
	if( hasMoveTo ) {
	
		w->putNBitInt(xybits,5);
	w->putNBitInt(x,xybits,true);
	w->putNBitInt(y,xybits,true);
	
	}

	if( hasFillStyle0 ) {
	
		w->putNBitInt(fillStyle0,ctx->fillBits);
	
	}

	if( hasFillStyle1 ) {
	
		w->putNBitInt(fillStyle1,ctx->fillBits);
	
	}

	if( hasLineStyle ) {
	
		w->putNBitInt(lineStyle,ctx->lineBits);
	
	}

	if( hasNewStyles ) {
	
		styles.write(w,ctx);

	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: ShapeSetup has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// CurveTo

void CurveTo::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE CurveTo @%i\n", start/8 );
		dump(1,ctx);
	}
	
	ShapeItem::writeHeader( w, ctx, getSize(ctx)/8 );
		w->putNBitInt(bits,4);
	w->putNBitInt(x1,bits+2,true);
	w->putNBitInt(y1,bits+2,true);
	w->putNBitInt(x2,bits+2,true);
	w->putNBitInt(y2,bits+2,true);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: CurveTo has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// Shape

void Shape::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE Shape @%i\n", start/8 );
		dump(1,ctx);
	}
	
	w->putNBitInt(fillBits,4);
	
		ctx->fillBits = fillBits;
	w->putNBitInt(lineBits,4);
	
		ctx->lineBits = lineBits;
	
	{
		int start = w->getPosition();
		ShapeItem *item;
		ListItem<ShapeItem>* i;
		i = edges.first();
		while( i ) {
			if( !i->data() ) {
				printf("WARNING: list edges has an invalid item\n" );
			} else {
				ctx->isLast = i->isLast();
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: Shape has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// GradientItem

void GradientItem::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE GradientItem @%i\n", start/8 );
		dump(1,ctx);
	}
	
	w->putByte(position);
	color.write(w,ctx);


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: GradientItem has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// Symbol

void Symbol::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE Symbol @%i\n", start/8 );
		dump(1,ctx);
	}
	
	w->putWord(objectID);
	w->putString(name);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: Symbol has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// Parameter

void Parameter::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE Parameter @%i\n", start/8 );
		dump(1,ctx);
	}
	
	w->putByte(reg);
	w->putString(name);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: Parameter has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// UChar

void UChar::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE UChar @%i\n", start/8 );
		dump(1,ctx);
	}
	
	w->putByte(value);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: UChar has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// UShort

void UShort::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE UShort @%i\n", start/8 );
		dump(1,ctx);
	}
	
	w->putWord(value);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: UShort has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// ULong

void ULong::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE ULong @%i\n", start/8 );
		dump(1,ctx);
	}
	
	w->putNBitInt(value,32);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: ULong has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// Short

void Short::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE Short @%i\n", start/8 );
		dump(1,ctx);
	}
	
	w->putWord(value);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: Short has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// Kerning

void Kerning::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE Kerning @%i\n", start/8 );
		dump(1,ctx);
	}
	
	w->putByte(a);
	w->putByte(b);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: Kerning has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// WideKerning

void WideKerning::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE WideKerning @%i\n", start/8 );
		dump(1,ctx);
	}
	
	w->putWord(a);
	w->putWord(b);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: WideKerning has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// TextEntry

void TextEntry::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE TextEntry @%i\n", start/8 );
		dump(1,ctx);
	}
	
	w->putNBitInt(glyph,ctx->glyphBits);
	w->putNBitInt(advance,ctx->advanceBits,true);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: TextEntry has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// TextRecord6

void TextRecord6::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE TextRecord6 @%i\n", start/8 );
		dump(1,ctx);
	}
	
	w->putNBitInt(isSetup,1);
	
	if( isSetup ) {
	
		w->putNBitInt(reserved,3);
	w->putNBitInt(hasFont,1);
	w->putNBitInt(hasColor,1);
	w->putNBitInt(hasMoveX,1);
	w->putNBitInt(hasMoveY,1);
	
	if( hasFont ) {
	
		w->putWord(objectID);
	
	}

	if( hasColor ) {
	
		color.write(w,ctx);

	}

	if( hasMoveX ) {
	
		w->putWord(x);
	
	}

	if( hasMoveY ) {
	
		w->putWord(y);
	
	}

	if( hasFont ) {
	
		w->putWord(fontHeight);
	
	}

	}

	if( !isSetup ) {
	
		w->putNBitInt(nGlyphs,7);
	
	{
		TextEntry *item;
		ListItem<TextEntry>* i;
		i = glyphs.first();
		for( int j=0; j<nGlyphs; j++ ) {
			if( !i || !i->data() ) {
				printf("WARNING: list glyphs has %i items (%i expected)\n", j, nGlyphs );
			} else {
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}

	w->byteAlign();

	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: TextRecord6 has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// TextRecord7

void TextRecord7::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE TextRecord7 @%i\n", start/8 );
		dump(1,ctx);
	}
	
	w->putNBitInt(isSetup,1);
	w->putNBitInt(reserved,3);
	w->putNBitInt(hasFont,1);
	w->putNBitInt(hasColor,1);
	w->putNBitInt(hasMoveX,1);
	w->putNBitInt(hasMoveY,1);
	
	if( hasFont ) {
	
		w->putWord(objectID);
	
	}

	if( hasColor ) {
	
		color.write(w,ctx);

	}

	if( hasMoveX ) {
	
		w->putWord(x);
	
	}

	if( hasMoveY ) {
	
		w->putWord(y);
	
	}

	if( hasFont ) {
	
		w->putWord(fontHeight);
	
	}

	if( isSetup ) {
	
		w->putByte(nGlyphs);
	
	{
		TextEntry *item;
		ListItem<TextEntry>* i;
		i = glyphs.first();
		for( int j=0; j<nGlyphs; j++ ) {
			if( !i || !i->data() ) {
				printf("WARNING: list glyphs has %i items (%i expected)\n", j, nGlyphs );
			} else {
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}

	}

	w->byteAlign();


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: TextRecord7 has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// TextRecord

void TextRecord::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE TextRecord @%i\n", start/8 );
		dump(1,ctx);
	}
	
	
	if( ctx->swfVersion < 7 ) {
		
	{
		int start = w->getPosition();
		TextRecord6 *item;
		ListItem<TextRecord6>* i;
		i = records.first();
		while( i ) {
			if( !i->data() ) {
				printf("WARNING: list records has an invalid item\n" );
			} else {
				ctx->isLast = i->isLast();
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}

	}

	if( ctx->swfVersion >= 7 ) {
		string.write(w,ctx);

	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: TextRecord has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// Button

void Button::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE Button @%i\n", start/8 );
		dump(1,ctx);
	}
	
	w->putNBitInt(reserved,4);
	w->putNBitInt(hitTest,1);
	w->putNBitInt(down,1);
	w->putNBitInt(over,1);
	w->putNBitInt(up,1);
	
	if( hitTest || down || over || up ) {
		w->putWord(button);
	w->putWord(depth);
	transform.write(w,ctx);
colorTransform.write(w,ctx);

	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: Button has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// Condition

void Condition::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE Condition @%i\n", start/8 );
		dump(1,ctx);
	}
	
	
		if( !ctx->isLast ) {
			int r = 0;
			
	r += 7;

	r++;

	r++;

	r++;

	r++;

	r++;

	r++;

	r++;

	r++;

	r++;

	{
		Action* item;
		ListItem<Action>* i;
		i = actions.first();
		while( i ) {
			item = i->data();
			if( item ) {
				r += item->getSize(ctx);
			}
			i = i->next();
		}
	}
next = (r/8) - (-2);
		} else {
			next = 0;
		}
	w->putWord(next);
	w->putNBitInt(key,7);
	w->putNBitInt(menuLeave,1);
	w->putNBitInt(menuEnter,1);
	w->putNBitInt(pointerReleaseOutside,1);
	w->putNBitInt(pointerDragEnter,1);
	w->putNBitInt(pointerDragLeave,1);
	w->putNBitInt(pointerReleaseInside,1);
	w->putNBitInt(pointerPush,1);
	w->putNBitInt(pointerLeave,1);
	w->putNBitInt(pointerEnter,1);
	
	{
		int start = w->getPosition();
		Action *item;
		ListItem<Action>* i;
		i = actions.first();
		while( i ) {
			if( !i->data() ) {
				printf("WARNING: list actions has an invalid item\n" );
			} else {
				ctx->isLast = i->isLast();
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: Condition has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// Solid

void Solid::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE Solid @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Style::writeHeader( w, ctx, getSize(ctx)/8 );
		color.write(w,ctx);


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: Solid has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// LinearGradient

void LinearGradient::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE LinearGradient @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Style::writeHeader( w, ctx, getSize(ctx)/8 );
		matrix.write(w,ctx);
w->putByte(count);
	
	{
		GradientItem *item;
		ListItem<GradientItem>* i;
		i = gradientColors.first();
		for( int j=0; j<count; j++ ) {
			if( !i || !i->data() ) {
				printf("WARNING: list gradientColors has %i items (%i expected)\n", j, count );
			} else {
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: LinearGradient has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// RadialGradient

void RadialGradient::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE RadialGradient @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Style::writeHeader( w, ctx, getSize(ctx)/8 );
		matrix.write(w,ctx);
w->putByte(count);
	
	{
		GradientItem *item;
		ListItem<GradientItem>* i;
		i = gradientColors.first();
		for( int j=0; j<count; j++ ) {
			if( !i || !i->data() ) {
				printf("WARNING: list gradientColors has %i items (%i expected)\n", j, count );
			} else {
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: RadialGradient has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// TiledBitmap

void TiledBitmap::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE TiledBitmap @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Style::writeHeader( w, ctx, getSize(ctx)/8 );
		w->putWord(objectID);
	matrix.write(w,ctx);


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: TiledBitmap has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// ClippedBitmap

void ClippedBitmap::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE ClippedBitmap @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Style::writeHeader( w, ctx, getSize(ctx)/8 );
		w->putWord(objectID);
	matrix.write(w,ctx);


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: ClippedBitmap has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// UnknownTag

void UnknownTag::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE UnknownTag @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Tag::writeHeader( w, ctx, getSize(ctx)/8 );
		
	if( len && data ) {
		w->putData( data, len );
	}
	w->byteAlign();


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: UnknownTag has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// End

void End::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE End @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Tag::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: End has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// ShowFrame

void ShowFrame::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE ShowFrame @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Tag::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: ShowFrame has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// DefineShape

void DefineShape::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE DefineShape @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Tag::writeHeader( w, ctx, getSize(ctx)/8 );
		w->putWord(objectID);
	bounds.write(w,ctx);
styles.write(w,ctx);
shapes.write(w,ctx);

	w->byteAlign();


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: DefineShape has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// RemoveObject

void RemoveObject::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE RemoveObject @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Tag::writeHeader( w, ctx, getSize(ctx)/8 );
		w->putWord(objectID);
	w->putWord(depth);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: RemoveObject has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// SetBackgroundColor

void SetBackgroundColor::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE SetBackgroundColor @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Tag::writeHeader( w, ctx, getSize(ctx)/8 );
		color.write(w,ctx);


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: SetBackgroundColor has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// DefineText

void DefineText::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE DefineText @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Tag::writeHeader( w, ctx, getSize(ctx)/8 );
		w->putWord(objectID);
	bounds.write(w,ctx);
transform.write(w,ctx);
w->putByte(glyphBits);
	
		ctx->glyphBits = glyphBits;
	w->putByte(advanceBits);
	
		ctx->advanceBits = advanceBits;
	
	{
		int start = w->getPosition();
		TextRecord *item;
		ListItem<TextRecord>* i;
		i = records.first();
		while( i ) {
			if( !i->data() ) {
				printf("WARNING: list records has an invalid item\n" );
			} else {
				ctx->isLast = i->isLast();
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: DefineText has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// DoAction

void DoAction::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE DoAction @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Tag::writeHeader( w, ctx, getSize(ctx)/8 );
		
	{
		int start = w->getPosition();
		Action *item;
		ListItem<Action>* i;
		i = actions.first();
		while( i ) {
			if( !i->data() ) {
				printf("WARNING: list actions has an invalid item\n" );
			} else {
				ctx->isLast = i->isLast();
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: DoAction has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// DefineFontInfo

void DefineFontInfo::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE DefineFontInfo @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Tag::writeHeader( w, ctx, getSize(ctx)/8 );
		w->putWord(objectID);
	w->putByte(nameLength);
	
	if( nameLength && nameData ) {
		w->putData( nameData, nameLength );
	}
	w->byteAlign();
w->putNBitInt(reserved,2);
	w->putNBitInt(smallTextOrUnicode,1);
	w->putNBitInt(isShiftJIS,1);
	w->putNBitInt(isANSII,1);
	w->putNBitInt(isItalic,1);
	w->putNBitInt(isBold,1);
	w->putNBitInt(isWide,1);
	
	if( ctx->swfVersion>=6 ) {
		w->putByte(language);
	
	}
map.write(w,ctx);


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: DefineFontInfo has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// DefineFontInfo2

void DefineFontInfo2::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE DefineFontInfo2 @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Tag::writeHeader( w, ctx, getSize(ctx)/8 );
		w->putWord(objectID);
	w->putByte(nameLength);
	
	if( nameLength && nameData ) {
		w->putData( nameData, nameLength );
	}
	w->byteAlign();
w->putNBitInt(reserved,2);
	w->putNBitInt(smallTextOrUnicode,1);
	w->putNBitInt(isShiftJIS,1);
	w->putNBitInt(isANSII,1);
	w->putNBitInt(isItalic,1);
	w->putNBitInt(isBold,1);
	w->putNBitInt(isWide,1);
	
	if( ctx->swfVersion>=6 ) {
		w->putByte(language);
	
	}
map.write(w,ctx);


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: DefineFontInfo2 has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// SoundStreamHead

void SoundStreamHead::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE SoundStreamHead @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Tag::writeHeader( w, ctx, getSize(ctx)/8 );
		w->putNBitInt(reserved,4);
	w->putNBitInt(playbackRate,2);
	w->putNBitInt(playbackSize,1);
	w->putNBitInt(playbackStereo,1);
	w->putNBitInt(compression,4);
	w->putNBitInt(soundRate,2);
	w->putNBitInt(soundSize,1);
	w->putNBitInt(soundStereo,1);
	w->putWord(sampleSize);
	
	if( compression==2 ) {
		latencySeek.write(w,ctx);

	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: SoundStreamHead has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// DefineBitsLossless

void DefineBitsLossless::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE DefineBitsLossless @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Tag::writeHeader( w, ctx, getSize(ctx)/8 );
		w->putWord(objectID);
	w->putByte(format);
	w->putWord(width);
	w->putWord(height);
	data.write(w,ctx);


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: DefineBitsLossless has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// DefineBitsJPEG2

void DefineBitsJPEG2::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE DefineBitsJPEG2 @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Tag::writeHeader( w, ctx, getSize(ctx)/8 );
		w->putWord(objectID);
	data.write(w,ctx);


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: DefineBitsJPEG2 has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// DefineBitsLossless2

void DefineBitsLossless2::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE DefineBitsLossless2 @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Tag::writeHeader( w, ctx, getSize(ctx)/8 );
		w->putWord(objectID);
	w->putByte(format);
	w->putWord(width);
	w->putWord(height);
	data.write(w,ctx);


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: DefineBitsLossless2 has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// PlaceObject2

void PlaceObject2::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE PlaceObject2 @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Tag::writeHeader( w, ctx, getSize(ctx)/8 );
		w->putNBitInt(hasEventHandler,1);
	w->putNBitInt(hasClipDepth,1);
	w->putNBitInt(hasName,1);
	w->putNBitInt(hasMorph,1);
	w->putNBitInt(hasColorTransform,1);
	w->putNBitInt(hasTransform,1);
	w->putNBitInt(hasID,1);
	w->putNBitInt(replace,1);
	w->putWord(depth);
	
	if( hasID ) {
	
		w->putWord(objectID);
	
	}

	if( hasTransform ) {
	
		transform.write(w,ctx);

	}

	if( hasColorTransform ) {
	
		colorTransform.write(w,ctx);

	}

	if( hasMorph ) {
	
		w->putWord(morph);
	
	}

	if( hasName ) {
	
		w->putString(name);
	
	}

	if( hasClipDepth ) {
	
		w->putWord(clipDepth);
	
	}

	if( hasEventHandler ) {
	
		events.write(w,ctx);

	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: PlaceObject2 has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// RemoveObject2

void RemoveObject2::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE RemoveObject2 @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Tag::writeHeader( w, ctx, getSize(ctx)/8 );
		w->putWord(depth);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: RemoveObject2 has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// DefineEditText

void DefineEditText::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE DefineEditText @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Tag::writeHeader( w, ctx, getSize(ctx)/8 );
		w->putWord(objectID);
	size.write(w,ctx);
w->putNBitInt(hasText,1);
	w->putNBitInt(wordWrap,1);
	w->putNBitInt(multiLine,1);
	w->putNBitInt(password,1);
	w->putNBitInt(readOnly,1);
	w->putNBitInt(hasColor,1);
	w->putNBitInt(hasMaxLength,1);
	w->putNBitInt(hasFont,1);
	w->putNBitInt(reserved,1);
	w->putNBitInt(autoSize,1);
	w->putNBitInt(hasLayout,1);
	w->putNBitInt(notSelectable,1);
	w->putNBitInt(hasBorder,1);
	w->putNBitInt(reserved2,1);
	w->putNBitInt(isHTML,1);
	w->putNBitInt(useOutlines,1);
	
	if( hasFont ) {
	
		w->putWord(fontRef);
	w->putWord(fontHeight);
	
	}

	if( hasColor ) {
	
		color.write(w,ctx);

	}

	if( hasMaxLength ) {
	
		w->putWord(maxLength);
	
	}

	if( hasLayout ) {
	
		w->putByte(align);
	w->putWord(leftMargin);
	w->putWord(rightMargin);
	w->putWord(indent);
	w->putWord(leading);
	
	}
w->putString(variableName);
	
	if( hasText ) {
	
		w->putString(initialText);
	
	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: DefineEditText has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// DefineSprite

void DefineSprite::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE DefineSprite @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Tag::writeHeader( w, ctx, getSize(ctx)/8 );
		w->putWord(objectID);
	w->putWord(frames);
	
	{
		int start = w->getPosition();
		Tag *item;
		ListItem<Tag>* i;
		i = tags.first();
		while( i ) {
			if( !i->data() ) {
				printf("WARNING: list tags has an invalid item\n" );
			} else {
				ctx->isLast = i->isLast();
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: DefineSprite has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// FrameLabel

void FrameLabel::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE FrameLabel @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Tag::writeHeader( w, ctx, getSize(ctx)/8 );
		w->putString(label);
	flags.write(w,ctx);


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: FrameLabel has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// SoundStreamHead2

void SoundStreamHead2::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE SoundStreamHead2 @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Tag::writeHeader( w, ctx, getSize(ctx)/8 );
		w->putNBitInt(reserved,4);
	w->putNBitInt(playbackRate,2);
	w->putNBitInt(playbackSize,1);
	w->putNBitInt(playbackStereo,1);
	w->putNBitInt(compression,4);
	w->putNBitInt(soundRate,2);
	w->putNBitInt(soundSize,1);
	w->putNBitInt(soundStereo,1);
	w->putWord(sampleSize);
	
	if( compression==2 ) {
		latencySeek.write(w,ctx);

	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: SoundStreamHead2 has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// DefineFont

void DefineFont::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE DefineFont @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Tag::writeHeader( w, ctx, getSize(ctx)/8 );
		
	ctx->tagVersion = 1;

	ctx->wideGlyphOffsets = 0;
w->putWord(objectID);
	glyphs.write(w,ctx);


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: DefineFont has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// DefineFont2

void DefineFont2::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE DefineFont2 @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Tag::writeHeader( w, ctx, getSize(ctx)/8 );
		
	ctx->tagVersion = 2;
w->putWord(objectID);
	w->putNBitInt(hasLayout,1);
	w->putNBitInt(isShiftJIS,1);
	w->putNBitInt(isUnicode,1);
	w->putNBitInt(isANSII,1);
	w->putNBitInt(wideGlyphOffsets,1);
	
		ctx->wideGlyphOffsets = wideGlyphOffsets;
	w->putNBitInt(wideMap,1);
	
		ctx->wideMap = wideMap;
	w->putNBitInt(italic,1);
	w->putNBitInt(bold,1);
	w->putByte(language);
	w->putPString(name);
	w->putWord(glyphCount);
	
		ctx->glyphCount = glyphCount;
	glyphs.write(w,ctx);

	if( hasLayout ) {
	
		w->putWord(ascent);
	w->putWord(descent);
	w->putWord(leading);
	
	{
		Short *item;
		ListItem<Short>* i;
		i = advance.first();
		for( int j=0; j<glyphCount; j++ ) {
			if( !i || !i->data() ) {
				printf("WARNING: list advance has %i items (%i expected)\n", j, glyphCount );
			} else {
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}

	{
		Rectangle *item;
		ListItem<Rectangle>* i;
		i = bounds.first();
		for( int j=0; j<glyphCount; j++ ) {
			if( !i || !i->data() ) {
				printf("WARNING: list bounds has %i items (%i expected)\n", j, glyphCount );
			} else {
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}
w->putWord(kerningCount);
	
	if( wideMap ) {
	
		
	{
		WideKerning *item;
		ListItem<WideKerning>* i;
		i = wideKerning.first();
		for( int j=0; j<kerningCount; j++ ) {
			if( !i || !i->data() ) {
				printf("WARNING: list wideKerning has %i items (%i expected)\n", j, kerningCount );
			} else {
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}

	}

	if( !wideMap ) {
	
		
	{
		Kerning *item;
		ListItem<Kerning>* i;
		i = kerning.first();
		for( int j=0; j<kerningCount; j++ ) {
			if( !i || !i->data() ) {
				printf("WARNING: list kerning has %i items (%i expected)\n", j, kerningCount );
			} else {
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}

	}

	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: DefineFont2 has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// DefineButton2

void DefineButton2::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE DefineButton2 @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Tag::writeHeader( w, ctx, getSize(ctx)/8 );
		
		{
			int r = 0;
			
	{
		Button* item;
		ListItem<Button>* i;
		i = buttons.first();
		while( i ) {
			item = i->data();
			if( item ) {
				r += item->getSize(ctx);
			}
			i = i->next();
		}
	}
buttonsSize = (r/8) - (-2);
		}
	w->putWord(objectID);
	w->putNBitInt(reserved,7);
	w->putNBitInt(menu,1);
	w->putWord(buttonsSize);
	
	{
		int start = w->getPosition();
		Button *item;
		ListItem<Button>* i;
		i = buttons.first();
		while( i ) {
			if( !i->data() ) {
				printf("WARNING: list buttons has an invalid item\n" );
			} else {
				ctx->isLast = i->isLast();
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}

	{
		int start = w->getPosition();
		Condition *item;
		ListItem<Condition>* i;
		i = conditions.first();
		while( i ) {
			if( !i->data() ) {
				printf("WARNING: list conditions has an invalid item\n" );
			} else {
				ctx->isLast = i->isLast();
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: DefineButton2 has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// Export

void Export::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE Export @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Tag::writeHeader( w, ctx, getSize(ctx)/8 );
		w->putWord(count);
	
	{
		Symbol *item;
		ListItem<Symbol>* i;
		i = symbols.first();
		for( int j=0; j<count; j++ ) {
			if( !i || !i->data() ) {
				printf("WARNING: list symbols has %i items (%i expected)\n", j, count );
			} else {
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: Export has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// DoInitAction

void DoInitAction::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE DoInitAction @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Tag::writeHeader( w, ctx, getSize(ctx)/8 );
		w->putWord(sprite);
	
	{
		int start = w->getPosition();
		Action *item;
		ListItem<Action>* i;
		i = actions.first();
		while( i ) {
			if( !i->data() ) {
				printf("WARNING: list actions has an invalid item\n" );
			} else {
				ctx->isLast = i->isLast();
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: DoInitAction has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// SoundStreamBlock

void SoundStreamBlock::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE SoundStreamBlock @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Tag::writeHeader( w, ctx, getSize(ctx)/8 );
		
	if( len && data ) {
		w->putData( data, len );
	}
	w->byteAlign();


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: SoundStreamBlock has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// DefineVideoStream

void DefineVideoStream::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE DefineVideoStream @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Tag::writeHeader( w, ctx, getSize(ctx)/8 );
		w->putWord(objectID);
	w->putWord(frames);
	w->putWord(width);
	w->putWord(height);
	w->putNBitInt(reserved,5);
	w->putNBitInt(deblocking,2);
	w->putNBitInt(smoothing,1);
	w->putByte(codec);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: DefineVideoStream has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// VideoFrame

void VideoFrame::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE VideoFrame @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Tag::writeHeader( w, ctx, getSize(ctx)/8 );
		w->putWord(objectID);
	w->putWord(frame);
	data.write(w,ctx);


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: VideoFrame has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// StackString

void StackString::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE StackString @%i\n", start/8 );
		dump(1,ctx);
	}
	
	StackItem::writeHeader( w, ctx, getSize(ctx)/8 );
		w->putString(value);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: StackString has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// StackFloat

void StackFloat::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE StackFloat @%i\n", start/8 );
		dump(1,ctx);
	}
	
	StackItem::writeHeader( w, ctx, getSize(ctx)/8 );
		w->putNBitInt(value,32);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: StackFloat has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// StackNull

void StackNull::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE StackNull @%i\n", start/8 );
		dump(1,ctx);
	}
	
	StackItem::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: StackNull has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// StackUndefined

void StackUndefined::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE StackUndefined @%i\n", start/8 );
		dump(1,ctx);
	}
	
	StackItem::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: StackUndefined has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// StackRegister

void StackRegister::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE StackRegister @%i\n", start/8 );
		dump(1,ctx);
	}
	
	StackItem::writeHeader( w, ctx, getSize(ctx)/8 );
		w->putByte(reg);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: StackRegister has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// StackBoolean

void StackBoolean::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE StackBoolean @%i\n", start/8 );
		dump(1,ctx);
	}
	
	StackItem::writeHeader( w, ctx, getSize(ctx)/8 );
		w->putByte(value);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: StackBoolean has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// StackDouble

void StackDouble::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE StackDouble @%i\n", start/8 );
		dump(1,ctx);
	}
	
	StackItem::writeHeader( w, ctx, getSize(ctx)/8 );
		w->putNBitInt(value,64);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: StackDouble has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// StackInteger

void StackInteger::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE StackInteger @%i\n", start/8 );
		dump(1,ctx);
	}
	
	StackItem::writeHeader( w, ctx, getSize(ctx)/8 );
		w->putNBitInt(value,32);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: StackInteger has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// StackDictionaryLookup

void StackDictionaryLookup::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE StackDictionaryLookup @%i\n", start/8 );
		dump(1,ctx);
	}
	
	StackItem::writeHeader( w, ctx, getSize(ctx)/8 );
		w->putByte(index);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: StackDictionaryLookup has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// StackLargeDictionaryLookup

void StackLargeDictionaryLookup::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE StackLargeDictionaryLookup @%i\n", start/8 );
		dump(1,ctx);
	}
	
	StackItem::writeHeader( w, ctx, getSize(ctx)/8 );
		w->putWord(index);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: StackLargeDictionaryLookup has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// UnknownAction

void UnknownAction::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE UnknownAction @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		
	if( len && data ) {
		w->putData( data, len );
	}
	w->byteAlign();


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: UnknownAction has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// EndAction

void EndAction::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE EndAction @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: EndAction has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// NextFrame

void NextFrame::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE NextFrame @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: NextFrame has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// PreviousFrame

void PreviousFrame::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE PreviousFrame @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: PreviousFrame has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// Play

void Play::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE Play @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: Play has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// Stop

void Stop::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE Stop @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: Stop has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// ToggleQuality

void ToggleQuality::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE ToggleQuality @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: ToggleQuality has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// StopSound

void StopSound::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE StopSound @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: StopSound has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// AddCast

void AddCast::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE AddCast @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: AddCast has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// Substract

void Substract::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE Substract @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: Substract has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// Mulitply

void Mulitply::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE Mulitply @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: Mulitply has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// Divide

void Divide::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE Divide @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: Divide has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// EqualCast

void EqualCast::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE EqualCast @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: EqualCast has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// LessThanCast

void LessThanCast::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE LessThanCast @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: LessThanCast has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// LogicalAND

void LogicalAND::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE LogicalAND @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: LogicalAND has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// LogicalOR

void LogicalOR::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE LogicalOR @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: LogicalOR has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// LogicalNOT

void LogicalNOT::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE LogicalNOT @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: LogicalNOT has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// StringEqual

void StringEqual::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE StringEqual @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: StringEqual has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// StringLength

void StringLength::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE StringLength @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: StringLength has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// SubString

void SubString::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE SubString @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: SubString has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// Pop

void Pop::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE Pop @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: Pop has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// IntegralPart

void IntegralPart::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE IntegralPart @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: IntegralPart has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// GetVariable

void GetVariable::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE GetVariable @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: GetVariable has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// SetVariable

void SetVariable::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE SetVariable @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: SetVariable has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// SetTargetDynamic

void SetTargetDynamic::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE SetTargetDynamic @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: SetTargetDynamic has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// ConcatenateString

void ConcatenateString::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE ConcatenateString @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: ConcatenateString has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// GetProperty

void GetProperty::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE GetProperty @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: GetProperty has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// SetProperty

void SetProperty::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE SetProperty @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: SetProperty has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// DuplicateSprite

void DuplicateSprite::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE DuplicateSprite @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: DuplicateSprite has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// RemoveSprite

void RemoveSprite::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE RemoveSprite @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: RemoveSprite has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// Trace

void Trace::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE Trace @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: Trace has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// StartDrag

void StartDrag::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE StartDrag @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: StartDrag has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// StopDrag

void StopDrag::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE StopDrag @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: StopDrag has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// StringLessThan

void StringLessThan::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE StringLessThan @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: StringLessThan has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// Throw

void Throw::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE Throw @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: Throw has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// CastObject

void CastObject::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE CastObject @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: CastObject has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// Implements

void Implements::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE Implements @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: Implements has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// Random

void Random::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE Random @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: Random has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// MultibyteStringLength

void MultibyteStringLength::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE MultibyteStringLength @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: MultibyteStringLength has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// ORD

void ORD::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE ORD @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: ORD has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// CHR

void CHR::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE CHR @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: CHR has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// GetTimer

void GetTimer::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE GetTimer @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: GetTimer has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// MultibyteSubString

void MultibyteSubString::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE MultibyteSubString @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: MultibyteSubString has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// MultibyteORD

void MultibyteORD::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE MultibyteORD @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: MultibyteORD has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// MultibyteCHR

void MultibyteCHR::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE MultibyteCHR @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: MultibyteCHR has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// Delete

void Delete::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE Delete @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: Delete has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// DeleteAll

void DeleteAll::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE DeleteAll @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: DeleteAll has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// SetLocalVariable

void SetLocalVariable::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE SetLocalVariable @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: SetLocalVariable has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// CallFunction

void CallFunction::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE CallFunction @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: CallFunction has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// Return

void Return::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE Return @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: Return has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// Modulo

void Modulo::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE Modulo @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: Modulo has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// New

void New::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE New @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: New has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// DeclareLocalVariable

void DeclareLocalVariable::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE DeclareLocalVariable @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: DeclareLocalVariable has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// DeclareArray

void DeclareArray::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE DeclareArray @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: DeclareArray has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// DeclareObject

void DeclareObject::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE DeclareObject @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: DeclareObject has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// TypeOf

void TypeOf::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE TypeOf @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: TypeOf has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// GetTarget

void GetTarget::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE GetTarget @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: GetTarget has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// Enumerate

void Enumerate::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE Enumerate @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: Enumerate has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// AddTyped

void AddTyped::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE AddTyped @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: AddTyped has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// LessThanTyped

void LessThanTyped::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE LessThanTyped @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: LessThanTyped has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// EqualTyped

void EqualTyped::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE EqualTyped @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: EqualTyped has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// DefineNumber

void DefineNumber::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE DefineNumber @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: DefineNumber has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// DefineString

void DefineString::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE DefineString @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: DefineString has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// Duplicate

void Duplicate::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE Duplicate @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: Duplicate has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// Swap

void Swap::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE Swap @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: Swap has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// GetMember

void GetMember::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE GetMember @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: GetMember has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// SetMember

void SetMember::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE SetMember @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: SetMember has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// Increment

void Increment::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE Increment @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: Increment has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// Decrement

void Decrement::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE Decrement @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: Decrement has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// CallMethod

void CallMethod::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE CallMethod @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: CallMethod has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// NewMethod

void NewMethod::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE NewMethod @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: NewMethod has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// InstanceOf

void InstanceOf::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE InstanceOf @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: InstanceOf has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// EnumerateObject

void EnumerateObject::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE EnumerateObject @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: EnumerateObject has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// AND

void AND::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE AND @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: AND has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// OR

void OR::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE OR @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: OR has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// XOR

void XOR::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE XOR @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: XOR has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// ShiftLeft

void ShiftLeft::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE ShiftLeft @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: ShiftLeft has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// ShiftRight

void ShiftRight::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE ShiftRight @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: ShiftRight has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// ShiftRightUnsigned

void ShiftRightUnsigned::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE ShiftRightUnsigned @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: ShiftRightUnsigned has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// StrictEqual

void StrictEqual::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE StrictEqual @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: StrictEqual has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// GreaterThanTyped

void GreaterThanTyped::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE GreaterThanTyped @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: GreaterThanTyped has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// StringGreaterThan

void StringGreaterThan::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE StringGreaterThan @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: StringGreaterThan has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// Extends

void Extends::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE Extends @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: Extends has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// GotoFrame

void GotoFrame::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE GotoFrame @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		w->putWord(frame);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: GotoFrame has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// GetURL

void GetURL::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE GetURL @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		w->putString(url);
	w->putString(target);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: GetURL has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// StoreRegister

void StoreRegister::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE StoreRegister @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		w->putByte(reg);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: StoreRegister has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// Dictionary

void Dictionary::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE Dictionary @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		w->putWord(length);
	
	{
		String *item;
		ListItem<String>* i;
		i = strings.first();
		for( int j=0; j<length; j++ ) {
			if( !i || !i->data() ) {
				printf("WARNING: list strings has %i items (%i expected)\n", j, length );
			} else {
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: Dictionary has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// WaitForFrame

void WaitForFrame::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE WaitForFrame @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		w->putWord(frame);
	w->putByte(skip);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: WaitForFrame has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// SetTarget

void SetTarget::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE SetTarget @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		w->putString(label);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: SetTarget has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// GotoLabel

void GotoLabel::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE GotoLabel @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		w->putString(label);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: GotoLabel has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// WaitForFrameDynamic

void WaitForFrameDynamic::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE WaitForFrameDynamic @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		w->putWord(frame);
	w->putByte(skip);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: WaitForFrameDynamic has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// DeclareFunction2

void DeclareFunction2::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE DeclareFunction2 @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		w->putString(name);
	w->putWord(argc);
	w->putByte(regc);
	w->putNBitInt(reserved,7);
	w->putNBitInt(preloadGlobal,1);
	w->putNBitInt(preloadParent,1);
	w->putNBitInt(preloadRoot,1);
	w->putNBitInt(suppressSuper,1);
	w->putNBitInt(preloadSuper,1);
	w->putNBitInt(suppressArguments,1);
	w->putNBitInt(preloadArguments,1);
	w->putNBitInt(suppressThis,1);
	w->putNBitInt(preloadThis,1);
	
	{
		Parameter *item;
		ListItem<Parameter>* i;
		i = args.first();
		for( int j=0; j<argc; j++ ) {
			if( !i || !i->data() ) {
				printf("WARNING: list args has %i items (%i expected)\n", j, argc );
			} else {
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}
w->putWord(length);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: DeclareFunction2 has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// Try

void Try::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE Try @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		w->putNBitInt(reserved,5);
	w->putNBitInt(catchInRegister,1);
	w->putNBitInt(doFinally,1);
	w->putNBitInt(doCatch,1);
	w->putWord(trySize);
	w->putWord(catchSize);
	w->putWord(finallySize);
	
	if( catchInRegister ) {
	
		w->putByte(reg);
	
	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: Try has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// With

void With::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE With @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		w->putWord(size);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: With has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// PushData

void PushData::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE PushData @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		
	{
		int start = w->getPosition();
		StackItem *item;
		ListItem<StackItem>* i;
		i = items.first();
		while( i ) {
			if( !i->data() ) {
				printf("WARNING: list items has an invalid item\n" );
			} else {
				ctx->isLast = i->isLast();
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}


	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: PushData has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// GetURL2

void GetURL2::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE GetURL2 @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		w->putByte(method);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: GetURL2 has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// DeclareFunction

void DeclareFunction::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE DeclareFunction @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		w->putString(name);
	w->putWord(argc);
	
	{
		String *item;
		ListItem<String>* i;
		i = args.first();
		for( int j=0; j<argc; j++ ) {
			if( !i || !i->data() ) {
				printf("WARNING: list args has %i items (%i expected)\n", j, argc );
			} else {
				i->data()->write( w, ctx );
			}
			i = i->next();
		}
	}
w->putWord(length);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: DeclareFunction has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// BranchAlways

void BranchAlways::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE BranchAlways @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		w->putWord(byteOffset);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: BranchAlways has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// BranchIfTrue

void BranchIfTrue::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE BranchIfTrue @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		w->putWord(byteOffset);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: BranchIfTrue has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// CallFrame

void CallFrame::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE CallFrame @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: CallFrame has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}


//////////////////////////////////// GotoExpression

void GotoExpression::write( Writer *w, Context *ctx ) {
	int start=w->getBitPosition();
	
	if( ctx->debugTrace ) {
		printf("WRITE GotoExpression @%i\n", start/8 );
		dump(1,ctx);
	}
	
	Action::writeHeader( w, ctx, getSize(ctx)/8 );
		w->putByte(play);
	

	int l = w->getBitPosition()-start;
	if( l != getSize(ctx)) {
		printf("WARNING: GotoExpression has different size than expected: %i bits instead of %i\n", l, getSize(ctx) );
	}

}



}

