

#include "SWF.h"
#include <string.h>
#include <ctype.h>
#include "base64.h"

namespace SWF {


void Rectangle::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("Rectangle::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"left" );
	if( tmp ) {
		sscanf( (char *)tmp, "%i", &left);
		xmlFree( tmp );
		
				int b = SWFBitsNeeded( left, true );
				
				if( b > bits ) bits = b;
			
	} else {
		fprintf(stderr,"WARNING: no left property in %s element\n", (const char *)node->name );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"right" );
	if( tmp ) {
		sscanf( (char *)tmp, "%i", &right);
		xmlFree( tmp );
		
				int b = SWFBitsNeeded( right, true );
				
				if( b > bits ) bits = b;
			
	} else {
		fprintf(stderr,"WARNING: no right property in %s element\n", (const char *)node->name );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"top" );
	if( tmp ) {
		sscanf( (char *)tmp, "%i", &top);
		xmlFree( tmp );
		
				int b = SWFBitsNeeded( top, true );
				
				if( b > bits ) bits = b;
			
	} else {
		fprintf(stderr,"WARNING: no top property in %s element\n", (const char *)node->name );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"bottom" );
	if( tmp ) {
		sscanf( (char *)tmp, "%i", &bottom);
		xmlFree( tmp );
		
				int b = SWFBitsNeeded( bottom, true );
				
				if( b > bits ) bits = b;
			
	} else {
		fprintf(stderr,"WARNING: no bottom property in %s element\n", (const char *)node->name );
	}

}

void Color::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("Color::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"red" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		red = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"green" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		green = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"blue" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		blue = tmp_int;
		xmlFree( tmp );
	}

}

void ColorRGBA::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("ColorRGBA::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"red" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		red = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"green" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		green = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"blue" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		blue = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"alpha" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		alpha = tmp_int;
		xmlFree( tmp );
	}

}

void String::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("String::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"value" );
	if( tmp ) {
		value = strdup((const char *)tmp);
	} else {
		fprintf(stderr,"WARNING: no value property in %s element\n", (const char *)node->name );
		value = strdup("[undefined]");
	}

}

void Transform::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("Transform::parseXML\n");

	
	{
		bool has = false;
		
	if( xmlHasProp( node, (const xmlChar *)"scaleX" ) ) has = true;

					if( has ) scaled = true;
				
	if( xmlHasProp( node, (const xmlChar *)"scaleY" ) ) has = true;

					if( has ) scaled = true;
				
		
		if( has ) {
			
	tmp = xmlGetProp( node, (const xmlChar *)"scaleX" );
	if( tmp ) {
		float t;
		sscanf( (char *)tmp, "%f", &t);
		scaleX = t;
		xmlFree( tmp );
		
				int b = SWFBitsNeeded( (long)(scaleX*(1<< 16)), true );
				
				if( b > bitsScale ) bitsScale = b;
			
	} else {
		fprintf(stderr,"WARNING: no scaleX property in %s element\n", (const char *)node->name );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"scaleY" );
	if( tmp ) {
		float t;
		sscanf( (char *)tmp, "%f", &t);
		scaleY = t;
		xmlFree( tmp );
		
				int b = SWFBitsNeeded( (long)(scaleY*(1<< 16)), true );
				
				if( b > bitsScale ) bitsScale = b;
			
	} else {
		fprintf(stderr,"WARNING: no scaleY property in %s element\n", (const char *)node->name );
	}

		}
	
		
	}

	{
		bool has = false;
		
	if( xmlHasProp( node, (const xmlChar *)"skewX" ) ) has = true;

					if( has ) skewed = true;
				
	if( xmlHasProp( node, (const xmlChar *)"skewY" ) ) has = true;

					if( has ) skewed = true;
				
		
		if( has ) {
			
	tmp = xmlGetProp( node, (const xmlChar *)"skewX" );
	if( tmp ) {
		float t;
		sscanf( (char *)tmp, "%f", &t);
		skewX = t;
		xmlFree( tmp );
		
				int b = SWFBitsNeeded( (long)(skewX*(1<< 16)), true );
				
				if( b > bitsSkew ) bitsSkew = b;
			
	} else {
		fprintf(stderr,"WARNING: no skewX property in %s element\n", (const char *)node->name );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"skewY" );
	if( tmp ) {
		float t;
		sscanf( (char *)tmp, "%f", &t);
		skewY = t;
		xmlFree( tmp );
		
				int b = SWFBitsNeeded( (long)(skewY*(1<< 16)), true );
				
				if( b > bitsSkew ) bitsSkew = b;
			
	} else {
		fprintf(stderr,"WARNING: no skewY property in %s element\n", (const char *)node->name );
	}

		}
	
		
	}

	tmp = xmlGetProp( node, (const xmlChar *)"transX" );
	if( tmp ) {
		sscanf( (char *)tmp, "%i", &transX);
		xmlFree( tmp );
		
				int b = SWFBitsNeeded( transX, true );
				
				if( b > bitsTranslate ) bitsTranslate = b;
			
	} else {
		fprintf(stderr,"WARNING: no transX property in %s element\n", (const char *)node->name );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"transY" );
	if( tmp ) {
		sscanf( (char *)tmp, "%i", &transY);
		xmlFree( tmp );
		
				int b = SWFBitsNeeded( transY, true );
				
				if( b > bitsTranslate ) bitsTranslate = b;
			
	} else {
		fprintf(stderr,"WARNING: no transY property in %s element\n", (const char *)node->name );
	}

}

void ColorTransform2::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("ColorTransform2::parseXML\n");

	
	{
		bool has = false;
		
	if( xmlHasProp( node, (const xmlChar *)"factorRed" ) ) has = true;

					if( has ) hasFactor = true;
				
	if( xmlHasProp( node, (const xmlChar *)"factorGreen" ) ) has = true;

					if( has ) hasFactor = true;
				
	if( xmlHasProp( node, (const xmlChar *)"factorBlue" ) ) has = true;

					if( has ) hasFactor = true;
				
	if( xmlHasProp( node, (const xmlChar *)"factorAlpha" ) ) has = true;

					if( has ) hasFactor = true;
				
		
		if( has ) {
			
	tmp = xmlGetProp( node, (const xmlChar *)"factorRed" );
	if( tmp ) {
		sscanf( (char *)tmp, "%i", &factorRed);
		xmlFree( tmp );
		
				int b = SWFBitsNeeded( factorRed, true );
				
				if( b > bits ) bits = b;
			
	} else {
		fprintf(stderr,"WARNING: no factorRed property in %s element\n", (const char *)node->name );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"factorGreen" );
	if( tmp ) {
		sscanf( (char *)tmp, "%i", &factorGreen);
		xmlFree( tmp );
		
				int b = SWFBitsNeeded( factorGreen, true );
				
				if( b > bits ) bits = b;
			
	} else {
		fprintf(stderr,"WARNING: no factorGreen property in %s element\n", (const char *)node->name );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"factorBlue" );
	if( tmp ) {
		sscanf( (char *)tmp, "%i", &factorBlue);
		xmlFree( tmp );
		
				int b = SWFBitsNeeded( factorBlue, true );
				
				if( b > bits ) bits = b;
			
	} else {
		fprintf(stderr,"WARNING: no factorBlue property in %s element\n", (const char *)node->name );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"factorAlpha" );
	if( tmp ) {
		sscanf( (char *)tmp, "%i", &factorAlpha);
		xmlFree( tmp );
		
				int b = SWFBitsNeeded( factorAlpha, true );
				
				if( b > bits ) bits = b;
			
	} else {
		fprintf(stderr,"WARNING: no factorAlpha property in %s element\n", (const char *)node->name );
	}

		}
	
		
	}

	{
		bool has = false;
		
	if( xmlHasProp( node, (const xmlChar *)"offsetRed" ) ) has = true;

					if( has ) hasOffset = true;
				
	if( xmlHasProp( node, (const xmlChar *)"offsetGreen" ) ) has = true;

					if( has ) hasOffset = true;
				
	if( xmlHasProp( node, (const xmlChar *)"offsetBlue" ) ) has = true;

					if( has ) hasOffset = true;
				
	if( xmlHasProp( node, (const xmlChar *)"offsetAlpha" ) ) has = true;

					if( has ) hasOffset = true;
				
		
		if( has ) {
			
	tmp = xmlGetProp( node, (const xmlChar *)"offsetRed" );
	if( tmp ) {
		sscanf( (char *)tmp, "%i", &offsetRed);
		xmlFree( tmp );
		
				int b = SWFBitsNeeded( offsetRed, true );
				
				if( b > bits ) bits = b;
			
	} else {
		fprintf(stderr,"WARNING: no offsetRed property in %s element\n", (const char *)node->name );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"offsetGreen" );
	if( tmp ) {
		sscanf( (char *)tmp, "%i", &offsetGreen);
		xmlFree( tmp );
		
				int b = SWFBitsNeeded( offsetGreen, true );
				
				if( b > bits ) bits = b;
			
	} else {
		fprintf(stderr,"WARNING: no offsetGreen property in %s element\n", (const char *)node->name );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"offsetBlue" );
	if( tmp ) {
		sscanf( (char *)tmp, "%i", &offsetBlue);
		xmlFree( tmp );
		
				int b = SWFBitsNeeded( offsetBlue, true );
				
				if( b > bits ) bits = b;
			
	} else {
		fprintf(stderr,"WARNING: no offsetBlue property in %s element\n", (const char *)node->name );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"offsetAlpha" );
	if( tmp ) {
		sscanf( (char *)tmp, "%i", &offsetAlpha);
		xmlFree( tmp );
		
				int b = SWFBitsNeeded( offsetAlpha, true );
				
				if( b > bits ) bits = b;
			
	} else {
		fprintf(stderr,"WARNING: no offsetAlpha property in %s element\n", (const char *)node->name );
	}

		}
	
		
	}

}

void Header::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("Header::parseXML\n");

	
	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "size" ) ) {

		xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					size.parseXML( child, ctx );
					node2 = child = NULL;
					node2 = NULL;
				} else {
					child = child->next;
				}
			}
		}
		if( node2 ) node2 = node2->next;
	}

	tmp = xmlGetProp( node, (const xmlChar *)"framerate" );
	if( tmp ) {
		sscanf( (char *)tmp, "%i", &framerate);
		xmlFree( tmp );
		
	} else {
		fprintf(stderr,"WARNING: no framerate property in %s element\n", (const char *)node->name );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"frames" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		frames = tmp_int;
		xmlFree( tmp );
	}

	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "tags" ) ) {
			
			
			xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					Tag* item = Tag::getByName( (const char *)child->name );
					if( item ) {
						item->parseXML( child, ctx );
						tags.append( item );
						
					}
				}
				child = child->next;
			}
			
			node2=NULL;
		} else {
			node2 = node2->next;
		}
	}

}

void LineStyle::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("LineStyle::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"width" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		width = tmp_int;
		xmlFree( tmp );
	}

	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "color" ) ) {

		xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					color.parseXML( child, ctx );
					node2 = child = NULL;
					node2 = NULL;
				} else {
					child = child->next;
				}
			}
		}
		if( node2 ) node2 = node2->next;
	}

}

void StyleList::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("StyleList::parseXML\n");

	
	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "fillStyles" ) ) {
			n_fillStyles=0;
			
			
			xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					Style* item = Style::getByName( (const char *)child->name );
					if( item ) {
						item->parseXML( child, ctx );
						fillStyles.append( item );
						n_fillStyles++;
						
					}
				}
				child = child->next;
			}
			
			node2=NULL;
		} else {
			node2 = node2->next;
		}
	}

	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "lineStyles" ) ) {
			n_lineStyles=0;
			
			
			xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					LineStyle* item = LineStyle::getByName( (const char *)child->name );
					if( item ) {
						item->parseXML( child, ctx );
						lineStyles.append( item );
						n_lineStyles++;
						
					}
				}
				child = child->next;
			}
			
			node2=NULL;
		} else {
			node2 = node2->next;
		}
	}

}

void ShapeSetup::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("ShapeSetup::parseXML\n");

	
	{
		bool has = false;
		
	if( xmlHasProp( node, (const xmlChar *)"x" ) ) has = true;

					if( has ) hasMoveTo = true;
				
	if( xmlHasProp( node, (const xmlChar *)"y" ) ) has = true;

					if( has ) hasMoveTo = true;
				
		
		if( has ) {
			
	tmp = xmlGetProp( node, (const xmlChar *)"x" );
	if( tmp ) {
		sscanf( (char *)tmp, "%i", &x);
		xmlFree( tmp );
		
				int b = SWFBitsNeeded( x, true );
				
				if( b > xybits ) xybits = b;
			
	} else {
		fprintf(stderr,"WARNING: no x property in %s element\n", (const char *)node->name );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"y" );
	if( tmp ) {
		sscanf( (char *)tmp, "%i", &y);
		xmlFree( tmp );
		
				int b = SWFBitsNeeded( y, true );
				
				if( b > xybits ) xybits = b;
			
	} else {
		fprintf(stderr,"WARNING: no y property in %s element\n", (const char *)node->name );
	}

		}
	
		
	}

	{
		bool has = false;
		
	if( xmlHasProp( node, (const xmlChar *)"fillStyle0" ) ) has = true;

					if( has ) hasFillStyle0 = true;
				
		
		if( has ) {
			
	tmp = xmlGetProp( node, (const xmlChar *)"fillStyle0" );
	if( tmp ) {
		sscanf( (char *)tmp, "%i", &fillStyle0);
		xmlFree( tmp );
		
				int b = SWFBitsNeeded( fillStyle0 );
				
				if( b > ctx->fillBits ) ctx->fillBits = b;
			
	} else {
		fprintf(stderr,"WARNING: no fillStyle0 property in %s element\n", (const char *)node->name );
	}

		}
	
		
	}

	{
		bool has = false;
		
	if( xmlHasProp( node, (const xmlChar *)"fillStyle1" ) ) has = true;

					if( has ) hasFillStyle1 = true;
				
		
		if( has ) {
			
	tmp = xmlGetProp( node, (const xmlChar *)"fillStyle1" );
	if( tmp ) {
		sscanf( (char *)tmp, "%i", &fillStyle1);
		xmlFree( tmp );
		
				int b = SWFBitsNeeded( fillStyle1 );
				
				if( b > ctx->fillBits ) ctx->fillBits = b;
			
	} else {
		fprintf(stderr,"WARNING: no fillStyle1 property in %s element\n", (const char *)node->name );
	}

		}
	
		
	}

	{
		bool has = false;
		
	if( xmlHasProp( node, (const xmlChar *)"lineStyle" ) ) has = true;

					if( has ) hasLineStyle = true;
				
		
		if( has ) {
			
	tmp = xmlGetProp( node, (const xmlChar *)"lineStyle" );
	if( tmp ) {
		sscanf( (char *)tmp, "%i", &lineStyle);
		xmlFree( tmp );
		
				int b = SWFBitsNeeded( lineStyle );
				
				if( b > ctx->lineBits ) ctx->lineBits = b;
			
	} else {
		fprintf(stderr,"WARNING: no lineStyle property in %s element\n", (const char *)node->name );
	}

		}
	
		
	}

	{
		bool has = false;
		
	{
		xmlNodePtr child = node->children;
		while( child && !has ) {
			if( !strcmp( (const char *)child->name, "styles" ) ) has = true;
			child = child->next;
		}
	}

					if( has ) hasNewStyles = true;
				
		
		if( has ) {
			
	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "styles" ) ) {

		xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					styles.parseXML( child, ctx );
					node2 = child = NULL;
					node2 = NULL;
				} else {
					child = child->next;
				}
			}
		}
		if( node2 ) node2 = node2->next;
	}

		}
	
		
	}

}

void CurveTo::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("CurveTo::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"x1" );
	if( tmp ) {
		sscanf( (char *)tmp, "%i", &x1);
		xmlFree( tmp );
		
				int b = SWFBitsNeeded( x1, true );
				b -= 2;
				if( b > bits ) bits = b;
			
	} else {
		fprintf(stderr,"WARNING: no x1 property in %s element\n", (const char *)node->name );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"y1" );
	if( tmp ) {
		sscanf( (char *)tmp, "%i", &y1);
		xmlFree( tmp );
		
				int b = SWFBitsNeeded( y1, true );
				b -= 2;
				if( b > bits ) bits = b;
			
	} else {
		fprintf(stderr,"WARNING: no y1 property in %s element\n", (const char *)node->name );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"x2" );
	if( tmp ) {
		sscanf( (char *)tmp, "%i", &x2);
		xmlFree( tmp );
		
				int b = SWFBitsNeeded( x2, true );
				b -= 2;
				if( b > bits ) bits = b;
			
	} else {
		fprintf(stderr,"WARNING: no x2 property in %s element\n", (const char *)node->name );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"y2" );
	if( tmp ) {
		sscanf( (char *)tmp, "%i", &y2);
		xmlFree( tmp );
		
				int b = SWFBitsNeeded( y2, true );
				b -= 2;
				if( b > bits ) bits = b;
			
	} else {
		fprintf(stderr,"WARNING: no y2 property in %s element\n", (const char *)node->name );
	}

}

void Shape::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("Shape::parseXML\n");

	
		ctx->fillBits = 0;
	
		ctx->lineBits = 0;
	
	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "edges" ) ) {
			
			
			xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					ShapeItem* item = ShapeItem::getByName( (const char *)child->name );
					if( item ) {
						item->parseXML( child, ctx );
						edges.append( item );
						
					}
				}
				child = child->next;
			}
			
			node2=NULL;
		} else {
			node2 = node2->next;
		}
	}
fillBits = ctx->fillBits;
	lineBits = ctx->lineBits;
	
}

void GradientItem::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("GradientItem::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"position" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		position = tmp_int;
		xmlFree( tmp );
	}

	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "color" ) ) {

		xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					color.parseXML( child, ctx );
					node2 = child = NULL;
					node2 = NULL;
				} else {
					child = child->next;
				}
			}
		}
		if( node2 ) node2 = node2->next;
	}

}

void Symbol::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("Symbol::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"objectID" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		objectID = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"name" );
	if( tmp ) {
		name = strdup((const char *)tmp);
	} else {
		fprintf(stderr,"WARNING: no name property in %s element\n", (const char *)node->name );
		name = strdup("[undefined]");
	}

}

void Parameter::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("Parameter::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"reg" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		reg = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"name" );
	if( tmp ) {
		name = strdup((const char *)tmp);
	} else {
		fprintf(stderr,"WARNING: no name property in %s element\n", (const char *)node->name );
		name = strdup("[undefined]");
	}

}

void UChar::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("UChar::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"value" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		value = tmp_int;
		xmlFree( tmp );
	}

}

void UShort::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("UShort::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"value" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		value = tmp_int;
		xmlFree( tmp );
	}

}

void ULong::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("ULong::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"value" );
	if( tmp ) {
		sscanf( (char *)tmp, "%i", &value);
		xmlFree( tmp );
		
	} else {
		fprintf(stderr,"WARNING: no value property in %s element\n", (const char *)node->name );
	}

}

void Short::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("Short::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"value" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		value = tmp_int;
		xmlFree( tmp );
	}

}

void Kerning::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("Kerning::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"a" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		a = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"b" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		b = tmp_int;
		xmlFree( tmp );
	}

}

void WideKerning::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("WideKerning::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"a" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		a = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"b" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		b = tmp_int;
		xmlFree( tmp );
	}

}

void TextEntry::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("TextEntry::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"glyph" );
	if( tmp ) {
		sscanf( (char *)tmp, "%i", &glyph);
		xmlFree( tmp );
		
				int b = SWFBitsNeeded( glyph );
				
				if( b > ctx->glyphBits ) ctx->glyphBits = b;
			
	} else {
		fprintf(stderr,"WARNING: no glyph property in %s element\n", (const char *)node->name );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"advance" );
	if( tmp ) {
		sscanf( (char *)tmp, "%i", &advance);
		xmlFree( tmp );
		
				int b = SWFBitsNeeded( advance, true );
				
				if( b > ctx->advanceBits ) ctx->advanceBits = b;
			
	} else {
		fprintf(stderr,"WARNING: no advance property in %s element\n", (const char *)node->name );
	}

}

void TextRecord6::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("TextRecord6::parseXML\n");

	
	{
		bool has = false;
		
	if( xmlHasProp( node, (const xmlChar *)"objectID" ) ) has = true;

					if( has ) isSetup = true;
				
	{
		xmlNodePtr child = node->children;
		while( child && !has ) {
			if( !strcmp( (const char *)child->name, "color" ) ) has = true;
			child = child->next;
		}
	}

					if( has ) isSetup = true;
				
	if( xmlHasProp( node, (const xmlChar *)"x" ) ) has = true;

					if( has ) isSetup = true;
				
	if( xmlHasProp( node, (const xmlChar *)"y" ) ) has = true;

					if( has ) isSetup = true;
				
	if( xmlHasProp( node, (const xmlChar *)"fontHeight" ) ) has = true;

					if( has ) isSetup = true;
				
		
		if( has ) {
			
	{
		bool has = false;
		
	if( xmlHasProp( node, (const xmlChar *)"objectID" ) ) has = true;

					if( has ) hasFont = true;
				
		
		if( has ) {
			
	tmp = xmlGetProp( node, (const xmlChar *)"objectID" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		objectID = tmp_int;
		xmlFree( tmp );
	}

		}
	
		
	}

	{
		bool has = false;
		
	{
		xmlNodePtr child = node->children;
		while( child && !has ) {
			if( !strcmp( (const char *)child->name, "color" ) ) has = true;
			child = child->next;
		}
	}

					if( has ) hasColor = true;
				
		
		if( has ) {
			
	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "color" ) ) {

		xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					color.parseXML( child, ctx );
					node2 = child = NULL;
					node2 = NULL;
				} else {
					child = child->next;
				}
			}
		}
		if( node2 ) node2 = node2->next;
	}

		}
	
		
	}

	{
		bool has = false;
		
	if( xmlHasProp( node, (const xmlChar *)"x" ) ) has = true;

					if( has ) hasMoveX = true;
				
		
		if( has ) {
			
	tmp = xmlGetProp( node, (const xmlChar *)"x" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		x = tmp_int;
		xmlFree( tmp );
	}

		}
	
		
	}

	{
		bool has = false;
		
	if( xmlHasProp( node, (const xmlChar *)"y" ) ) has = true;

					if( has ) hasMoveY = true;
				
		
		if( has ) {
			
	tmp = xmlGetProp( node, (const xmlChar *)"y" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		y = tmp_int;
		xmlFree( tmp );
	}

		}
	
		
	}

	{
		bool has = false;
		
	if( xmlHasProp( node, (const xmlChar *)"fontHeight" ) ) has = true;

					if( has ) hasFont = true;
				
		
		if( has ) {
			
	tmp = xmlGetProp( node, (const xmlChar *)"fontHeight" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		fontHeight = tmp_int;
		xmlFree( tmp );
	}

		}
	
		
	}

		}
	
		
	}

	{
		bool has = false;
		
	{
		xmlNodePtr child = node->children;
		while( child && !has ) {
			if( !strcmp( (const char *)child->name, "glyphs" ) ) has = true;
			child = child->next;
		}
	}

					if( has ) isSetup = !true;
				
		
		if( has ) {
			
	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "glyphs" ) ) {
			nGlyphs=0;
			
			
			xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					TextEntry* item = TextEntry::getByName( (const char *)child->name );
					if( item ) {
						item->parseXML( child, ctx );
						glyphs.append( item );
						nGlyphs++;
						
					}
				}
				child = child->next;
			}
			
			node2=NULL;
		} else {
			node2 = node2->next;
		}
	}

		}
	
		
	}

}

void TextRecord7::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("TextRecord7::parseXML\n");

	
	{
		bool has = false;
		
	if( xmlHasProp( node, (const xmlChar *)"objectID" ) ) has = true;

					if( has ) hasFont = true;
				
		
		if( has ) {
			
	tmp = xmlGetProp( node, (const xmlChar *)"objectID" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		objectID = tmp_int;
		xmlFree( tmp );
	}

		}
	
		
	}

	{
		bool has = false;
		
	{
		xmlNodePtr child = node->children;
		while( child && !has ) {
			if( !strcmp( (const char *)child->name, "color" ) ) has = true;
			child = child->next;
		}
	}

					if( has ) hasColor = true;
				
		
		if( has ) {
			
	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "color" ) ) {

		xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					color.parseXML( child, ctx );
					node2 = child = NULL;
					node2 = NULL;
				} else {
					child = child->next;
				}
			}
		}
		if( node2 ) node2 = node2->next;
	}

		}
	
		
	}

	{
		bool has = false;
		
	if( xmlHasProp( node, (const xmlChar *)"x" ) ) has = true;

					if( has ) hasMoveX = true;
				
		
		if( has ) {
			
	tmp = xmlGetProp( node, (const xmlChar *)"x" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		x = tmp_int;
		xmlFree( tmp );
	}

		}
	
		
	}

	{
		bool has = false;
		
	if( xmlHasProp( node, (const xmlChar *)"y" ) ) has = true;

					if( has ) hasMoveY = true;
				
		
		if( has ) {
			
	tmp = xmlGetProp( node, (const xmlChar *)"y" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		y = tmp_int;
		xmlFree( tmp );
	}

		}
	
		
	}

	{
		bool has = false;
		
	if( xmlHasProp( node, (const xmlChar *)"fontHeight" ) ) has = true;

					if( has ) hasFont = true;
				
		
		if( has ) {
			
	tmp = xmlGetProp( node, (const xmlChar *)"fontHeight" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		fontHeight = tmp_int;
		xmlFree( tmp );
	}

		}
	
		
	}

	{
		bool has = false;
		
	{
		xmlNodePtr child = node->children;
		while( child && !has ) {
			if( !strcmp( (const char *)child->name, "glyphs" ) ) has = true;
			child = child->next;
		}
	}

					if( has ) isSetup = true;
				
		
		if( has ) {
			
	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "glyphs" ) ) {
			nGlyphs=0;
			
			
			xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					TextEntry* item = TextEntry::getByName( (const char *)child->name );
					if( item ) {
						item->parseXML( child, ctx );
						glyphs.append( item );
						nGlyphs++;
						
					}
				}
				child = child->next;
			}
			
			node2=NULL;
		} else {
			node2 = node2->next;
		}
	}

		}
	
		
	}

}

void TextRecord::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("TextRecord::parseXML\n");

	
	if( ctx->swfVersion < 7 ) {
		
	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "records" ) ) {
			
			
			xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					TextRecord6* item = TextRecord6::getByName( (const char *)child->name );
					if( item ) {
						item->parseXML( child, ctx );
						records.append( item );
						
					}
				}
				child = child->next;
			}
			
			node2=NULL;
		} else {
			node2 = node2->next;
		}
	}

	}

	if( ctx->swfVersion >= 7 ) {
		
	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "string" ) ) {

		xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					string.parseXML( child, ctx );
					node2 = child = NULL;
					node2 = NULL;
				} else {
					child = child->next;
				}
			}
		}
		if( node2 ) node2 = node2->next;
	}

	}

}

void Button::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("Button::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"hitTest" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		hitTest = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"down" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		down = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"over" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		over = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"up" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		up = tmp_int;
		xmlFree( tmp );
	}

	if( hitTest || down || over || up ) {
		
	tmp = xmlGetProp( node, (const xmlChar *)"button" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		button = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"depth" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		depth = tmp_int;
		xmlFree( tmp );
	}

	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "transform" ) ) {

		xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					transform.parseXML( child, ctx );
					node2 = child = NULL;
					node2 = NULL;
				} else {
					child = child->next;
				}
			}
		}
		if( node2 ) node2 = node2->next;
	}

	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "colorTransform" ) ) {

		xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					colorTransform.parseXML( child, ctx );
					node2 = child = NULL;
					node2 = NULL;
				} else {
					child = child->next;
				}
			}
		}
		if( node2 ) node2 = node2->next;
	}

	}

}

void Condition::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("Condition::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"next" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		next = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"key" );
	if( tmp ) {
		sscanf( (char *)tmp, "%i", &key);
		xmlFree( tmp );
		
	} else {
		fprintf(stderr,"WARNING: no key property in %s element\n", (const char *)node->name );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"menuLeave" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		menuLeave = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"menuEnter" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		menuEnter = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"pointerReleaseOutside" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		pointerReleaseOutside = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"pointerDragEnter" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		pointerDragEnter = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"pointerDragLeave" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		pointerDragLeave = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"pointerReleaseInside" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		pointerReleaseInside = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"pointerPush" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		pointerPush = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"pointerLeave" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		pointerLeave = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"pointerEnter" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		pointerEnter = tmp_int;
		xmlFree( tmp );
	}

	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "actions" ) ) {
			
			
			xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					Action* item = Action::getByName( (const char *)child->name );
					if( item ) {
						item->parseXML( child, ctx );
						actions.append( item );
						
					}
				}
				child = child->next;
			}
			
			node2=NULL;
		} else {
			node2 = node2->next;
		}
	}

}

void Solid::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("Solid::parseXML\n");

	
	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "color" ) ) {

		xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					color.parseXML( child, ctx );
					node2 = child = NULL;
					node2 = NULL;
				} else {
					child = child->next;
				}
			}
		}
		if( node2 ) node2 = node2->next;
	}

}

void LinearGradient::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("LinearGradient::parseXML\n");

	
	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "matrix" ) ) {

		xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					matrix.parseXML( child, ctx );
					node2 = child = NULL;
					node2 = NULL;
				} else {
					child = child->next;
				}
			}
		}
		if( node2 ) node2 = node2->next;
	}

	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "gradientColors" ) ) {
			count=0;
			
			
			xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					GradientItem* item = GradientItem::getByName( (const char *)child->name );
					if( item ) {
						item->parseXML( child, ctx );
						gradientColors.append( item );
						count++;
						
					}
				}
				child = child->next;
			}
			
			node2=NULL;
		} else {
			node2 = node2->next;
		}
	}

}

void RadialGradient::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("RadialGradient::parseXML\n");

	
	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "matrix" ) ) {

		xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					matrix.parseXML( child, ctx );
					node2 = child = NULL;
					node2 = NULL;
				} else {
					child = child->next;
				}
			}
		}
		if( node2 ) node2 = node2->next;
	}

	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "gradientColors" ) ) {
			count=0;
			
			
			xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					GradientItem* item = GradientItem::getByName( (const char *)child->name );
					if( item ) {
						item->parseXML( child, ctx );
						gradientColors.append( item );
						count++;
						
					}
				}
				child = child->next;
			}
			
			node2=NULL;
		} else {
			node2 = node2->next;
		}
	}

}

void TiledBitmap::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("TiledBitmap::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"objectID" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		objectID = tmp_int;
		xmlFree( tmp );
	}

	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "matrix" ) ) {

		xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					matrix.parseXML( child, ctx );
					node2 = child = NULL;
					node2 = NULL;
				} else {
					child = child->next;
				}
			}
		}
		if( node2 ) node2 = node2->next;
	}

}

void ClippedBitmap::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("ClippedBitmap::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"objectID" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		objectID = tmp_int;
		xmlFree( tmp );
	}

	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "matrix" ) ) {

		xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					matrix.parseXML( child, ctx );
					node2 = child = NULL;
					node2 = NULL;
				} else {
					child = child->next;
				}
			}
		}
		if( node2 ) node2 = node2->next;
	}

}

void UnknownTag::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("UnknownTag::parseXML\n");

	
	{
		data = NULL;
		len = 0;

		xmlChar *xmld = xmlNodeGetContent( node );
		char *d = (char *)xmld;
		if( d ) {
			// unsure if this is neccessary
			for( int i=strlen(d)-1; i>0 && isspace(d[i]); i-- ) d[i]=0;
			while( isspace(d[0]) ) d++;
			int l = strlen(d); //BASE64_GET_MAX_DECODED_LEN(strlen( d ));
			char *dst = new char[ l ];
			int lout = base64_decode( dst, (char*)d, l );
			if( lout > 0 ) {
				len = lout;
				data = new unsigned char[ lout ];
				memcpy( data, dst, lout );
			}
			delete dst;
			xmlFree( xmld );
		} 
	}

		tmp = xmlGetProp( node, (const xmlChar *)"id" );
		if( tmp ) { 
			sscanf( (char *)tmp, "%X", &type ); 
			xmlFree( (xmlChar *)tmp ); 
		}
	
}

void End::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("End::parseXML\n");

	
}

void ShowFrame::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("ShowFrame::parseXML\n");

	
}

void DefineShape::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("DefineShape::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"objectID" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		objectID = tmp_int;
		xmlFree( tmp );
	}

	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "bounds" ) ) {

		xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					bounds.parseXML( child, ctx );
					node2 = child = NULL;
					node2 = NULL;
				} else {
					child = child->next;
				}
			}
		}
		if( node2 ) node2 = node2->next;
	}

	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "styles" ) ) {

		xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					styles.parseXML( child, ctx );
					node2 = child = NULL;
					node2 = NULL;
				} else {
					child = child->next;
				}
			}
		}
		if( node2 ) node2 = node2->next;
	}

	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "shapes" ) ) {

		xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					shapes.parseXML( child, ctx );
					node2 = child = NULL;
					node2 = NULL;
				} else {
					child = child->next;
				}
			}
		}
		if( node2 ) node2 = node2->next;
	}

}

void RemoveObject::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("RemoveObject::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"objectID" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		objectID = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"depth" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		depth = tmp_int;
		xmlFree( tmp );
	}

}

void SetBackgroundColor::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("SetBackgroundColor::parseXML\n");

	
	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "color" ) ) {

		xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					color.parseXML( child, ctx );
					node2 = child = NULL;
					node2 = NULL;
				} else {
					child = child->next;
				}
			}
		}
		if( node2 ) node2 = node2->next;
	}

}

void DefineText::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("DefineText::parseXML\n");

	
		ctx->glyphBits = 0;
	
		ctx->advanceBits = 0;
	
	tmp = xmlGetProp( node, (const xmlChar *)"objectID" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		objectID = tmp_int;
		xmlFree( tmp );
	}

	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "bounds" ) ) {

		xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					bounds.parseXML( child, ctx );
					node2 = child = NULL;
					node2 = NULL;
				} else {
					child = child->next;
				}
			}
		}
		if( node2 ) node2 = node2->next;
	}

	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "transform" ) ) {

		xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					transform.parseXML( child, ctx );
					node2 = child = NULL;
					node2 = NULL;
				} else {
					child = child->next;
				}
			}
		}
		if( node2 ) node2 = node2->next;
	}

	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "records" ) ) {
			
			
			xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					TextRecord* item = TextRecord::getByName( (const char *)child->name );
					if( item ) {
						item->parseXML( child, ctx );
						records.append( item );
						
					}
				}
				child = child->next;
			}
			
			node2=NULL;
		} else {
			node2 = node2->next;
		}
	}
glyphBits = ctx->glyphBits;
	advanceBits = ctx->advanceBits;
	
}

void DoAction::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("DoAction::parseXML\n");

	
	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "actions" ) ) {
			
			
			xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					Action* item = Action::getByName( (const char *)child->name );
					if( item ) {
						item->parseXML( child, ctx );
						actions.append( item );
						
					}
				}
				child = child->next;
			}
			
			node2=NULL;
		} else {
			node2 = node2->next;
		}
	}

}

void DefineFontInfo::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("DefineFontInfo::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"objectID" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		objectID = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"smallTextOrUnicode" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		smallTextOrUnicode = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"isShiftJIS" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		isShiftJIS = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"isANSII" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		isANSII = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"isItalic" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		isItalic = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"isBold" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		isBold = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"isWide" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		isWide = tmp_int;
		xmlFree( tmp );
	}

	if( ctx->swfVersion>=6 ) {
		
	tmp = xmlGetProp( node, (const xmlChar *)"language" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		language = tmp_int;
		xmlFree( tmp );
	}

	}

	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "map" ) ) {

		xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					map.parseXML( child, ctx );
					node2 = child = NULL;
					node2 = NULL;
				} else {
					child = child->next;
				}
			}
		}
		if( node2 ) node2 = node2->next;
	}

}

void DefineFontInfo2::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("DefineFontInfo2::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"objectID" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		objectID = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"smallTextOrUnicode" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		smallTextOrUnicode = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"isShiftJIS" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		isShiftJIS = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"isANSII" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		isANSII = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"isItalic" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		isItalic = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"isBold" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		isBold = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"isWide" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		isWide = tmp_int;
		xmlFree( tmp );
	}

	if( ctx->swfVersion>=6 ) {
		
	tmp = xmlGetProp( node, (const xmlChar *)"language" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		language = tmp_int;
		xmlFree( tmp );
	}

	}

	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "map" ) ) {

		xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					map.parseXML( child, ctx );
					node2 = child = NULL;
					node2 = NULL;
				} else {
					child = child->next;
				}
			}
		}
		if( node2 ) node2 = node2->next;
	}

}

void SoundStreamHead::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("SoundStreamHead::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"playbackRate" );
	if( tmp ) {
		sscanf( (char *)tmp, "%i", &playbackRate);
		xmlFree( tmp );
		
	} else {
		fprintf(stderr,"WARNING: no playbackRate property in %s element\n", (const char *)node->name );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"playbackSize" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		playbackSize = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"playbackStereo" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		playbackStereo = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"compression" );
	if( tmp ) {
		sscanf( (char *)tmp, "%i", &compression);
		xmlFree( tmp );
		
	} else {
		fprintf(stderr,"WARNING: no compression property in %s element\n", (const char *)node->name );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"soundRate" );
	if( tmp ) {
		sscanf( (char *)tmp, "%i", &soundRate);
		xmlFree( tmp );
		
	} else {
		fprintf(stderr,"WARNING: no soundRate property in %s element\n", (const char *)node->name );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"soundSize" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		soundSize = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"soundStereo" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		soundStereo = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"sampleSize" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		sampleSize = tmp_int;
		xmlFree( tmp );
	}

	if( compression==2 ) {
		
	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "latencySeek" ) ) {

		xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					latencySeek.parseXML( child, ctx );
					node2 = child = NULL;
					node2 = NULL;
				} else {
					child = child->next;
				}
			}
		}
		if( node2 ) node2 = node2->next;
	}

	}

}

void DefineBitsLossless::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("DefineBitsLossless::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"objectID" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		objectID = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"format" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		format = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"width" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		width = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"height" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		height = tmp_int;
		xmlFree( tmp );
	}

	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "data" ) ) {

		xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					data.parseXML( child, ctx );
					node2 = child = NULL;
					node2 = NULL;
				} else {
					child = child->next;
				}
			}
		}
		if( node2 ) node2 = node2->next;
	}

}

void DefineBitsJPEG2::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("DefineBitsJPEG2::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"objectID" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		objectID = tmp_int;
		xmlFree( tmp );
	}

	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "data" ) ) {

		xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					data.parseXML( child, ctx );
					node2 = child = NULL;
					node2 = NULL;
				} else {
					child = child->next;
				}
			}
		}
		if( node2 ) node2 = node2->next;
	}

}

void DefineBitsLossless2::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("DefineBitsLossless2::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"objectID" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		objectID = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"format" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		format = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"width" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		width = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"height" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		height = tmp_int;
		xmlFree( tmp );
	}

	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "data" ) ) {

		xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					data.parseXML( child, ctx );
					node2 = child = NULL;
					node2 = NULL;
				} else {
					child = child->next;
				}
			}
		}
		if( node2 ) node2 = node2->next;
	}

}

void PlaceObject2::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("PlaceObject2::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"replace" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		replace = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"depth" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		depth = tmp_int;
		xmlFree( tmp );
	}

	{
		bool has = false;
		
	if( xmlHasProp( node, (const xmlChar *)"objectID" ) ) has = true;

					if( has ) hasID = true;
				
		
		if( has ) {
			
	tmp = xmlGetProp( node, (const xmlChar *)"objectID" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		objectID = tmp_int;
		xmlFree( tmp );
	}

		}
	
		
	}

	{
		bool has = false;
		
	{
		xmlNodePtr child = node->children;
		while( child && !has ) {
			if( !strcmp( (const char *)child->name, "transform" ) ) has = true;
			child = child->next;
		}
	}

					if( has ) hasTransform = true;
				
		
		if( has ) {
			
	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "transform" ) ) {

		xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					transform.parseXML( child, ctx );
					node2 = child = NULL;
					node2 = NULL;
				} else {
					child = child->next;
				}
			}
		}
		if( node2 ) node2 = node2->next;
	}

		}
	
		
	}

	{
		bool has = false;
		
	{
		xmlNodePtr child = node->children;
		while( child && !has ) {
			if( !strcmp( (const char *)child->name, "colorTransform" ) ) has = true;
			child = child->next;
		}
	}

					if( has ) hasColorTransform = true;
				
		
		if( has ) {
			
	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "colorTransform" ) ) {

		xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					colorTransform.parseXML( child, ctx );
					node2 = child = NULL;
					node2 = NULL;
				} else {
					child = child->next;
				}
			}
		}
		if( node2 ) node2 = node2->next;
	}

		}
	
		
	}

	{
		bool has = false;
		
	if( xmlHasProp( node, (const xmlChar *)"morph" ) ) has = true;

					if( has ) hasMorph = true;
				
		
		if( has ) {
			
	tmp = xmlGetProp( node, (const xmlChar *)"morph" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		morph = tmp_int;
		xmlFree( tmp );
	}

		}
	
		
	}

	{
		bool has = false;
		
	if( xmlHasProp( node, (const xmlChar *)"name" ) ) has = true;

					if( has ) hasName = true;
				
		
		if( has ) {
			
	tmp = xmlGetProp( node, (const xmlChar *)"name" );
	if( tmp ) {
		name = strdup((const char *)tmp);
	} else {
		fprintf(stderr,"WARNING: no name property in %s element\n", (const char *)node->name );
		name = strdup("[undefined]");
	}

		}
	
		
	}

	{
		bool has = false;
		
	if( xmlHasProp( node, (const xmlChar *)"clipDepth" ) ) has = true;

					if( has ) hasClipDepth = true;
				
		
		if( has ) {
			
	tmp = xmlGetProp( node, (const xmlChar *)"clipDepth" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		clipDepth = tmp_int;
		xmlFree( tmp );
	}

		}
	
		
	}

	{
		bool has = false;
		
	{
		xmlNodePtr child = node->children;
		while( child && !has ) {
			if( !strcmp( (const char *)child->name, "events" ) ) has = true;
			child = child->next;
		}
	}

					if( has ) hasEventHandler = true;
				
		
		if( has ) {
			
	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "events" ) ) {

		xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					events.parseXML( child, ctx );
					node2 = child = NULL;
					node2 = NULL;
				} else {
					child = child->next;
				}
			}
		}
		if( node2 ) node2 = node2->next;
	}

		}
	
		
	}

}

void RemoveObject2::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("RemoveObject2::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"depth" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		depth = tmp_int;
		xmlFree( tmp );
	}

}

void DefineEditText::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("DefineEditText::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"objectID" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		objectID = tmp_int;
		xmlFree( tmp );
	}

	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "size" ) ) {

		xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					size.parseXML( child, ctx );
					node2 = child = NULL;
					node2 = NULL;
				} else {
					child = child->next;
				}
			}
		}
		if( node2 ) node2 = node2->next;
	}

	tmp = xmlGetProp( node, (const xmlChar *)"wordWrap" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		wordWrap = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"multiLine" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		multiLine = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"password" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		password = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"readOnly" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		readOnly = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"autoSize" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		autoSize = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"hasLayout" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		hasLayout = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"notSelectable" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		notSelectable = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"hasBorder" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		hasBorder = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"isHTML" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		isHTML = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"useOutlines" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		useOutlines = tmp_int;
		xmlFree( tmp );
	}

	{
		bool has = false;
		
	if( xmlHasProp( node, (const xmlChar *)"fontRef" ) ) has = true;

					if( has ) hasFont = true;
				
	if( xmlHasProp( node, (const xmlChar *)"fontHeight" ) ) has = true;

					if( has ) hasFont = true;
				
		
		if( has ) {
			
	tmp = xmlGetProp( node, (const xmlChar *)"fontRef" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		fontRef = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"fontHeight" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		fontHeight = tmp_int;
		xmlFree( tmp );
	}

		}
	
		
	}

	{
		bool has = false;
		
	{
		xmlNodePtr child = node->children;
		while( child && !has ) {
			if( !strcmp( (const char *)child->name, "color" ) ) has = true;
			child = child->next;
		}
	}

					if( has ) hasColor = true;
				
		
		if( has ) {
			
	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "color" ) ) {

		xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					color.parseXML( child, ctx );
					node2 = child = NULL;
					node2 = NULL;
				} else {
					child = child->next;
				}
			}
		}
		if( node2 ) node2 = node2->next;
	}

		}
	
		
	}

	{
		bool has = false;
		
	if( xmlHasProp( node, (const xmlChar *)"maxLength" ) ) has = true;

					if( has ) hasMaxLength = true;
				
		
		if( has ) {
			
	tmp = xmlGetProp( node, (const xmlChar *)"maxLength" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		maxLength = tmp_int;
		xmlFree( tmp );
	}

		}
	
		
	}

	{
		bool has = false;
		
	if( xmlHasProp( node, (const xmlChar *)"align" ) ) has = true;

					if( has ) hasLayout = true;
				
	if( xmlHasProp( node, (const xmlChar *)"leftMargin" ) ) has = true;

					if( has ) hasLayout = true;
				
	if( xmlHasProp( node, (const xmlChar *)"rightMargin" ) ) has = true;

					if( has ) hasLayout = true;
				
	if( xmlHasProp( node, (const xmlChar *)"indent" ) ) has = true;

					if( has ) hasLayout = true;
				
	if( xmlHasProp( node, (const xmlChar *)"leading" ) ) has = true;

					if( has ) hasLayout = true;
				
		
		if( has ) {
			
	tmp = xmlGetProp( node, (const xmlChar *)"align" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		align = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"leftMargin" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		leftMargin = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"rightMargin" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		rightMargin = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"indent" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		indent = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"leading" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		leading = tmp_int;
		xmlFree( tmp );
	}

		}
	
		
	}

	tmp = xmlGetProp( node, (const xmlChar *)"variableName" );
	if( tmp ) {
		variableName = strdup((const char *)tmp);
	} else {
		fprintf(stderr,"WARNING: no variableName property in %s element\n", (const char *)node->name );
		variableName = strdup("[undefined]");
	}

	{
		bool has = false;
		
	if( xmlHasProp( node, (const xmlChar *)"initialText" ) ) has = true;

					if( has ) hasText = true;
				
		
		if( has ) {
			
	tmp = xmlGetProp( node, (const xmlChar *)"initialText" );
	if( tmp ) {
		initialText = strdup((const char *)tmp);
	} else {
		fprintf(stderr,"WARNING: no initialText property in %s element\n", (const char *)node->name );
		initialText = strdup("[undefined]");
	}

		}
	
		
	}

}

void DefineSprite::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("DefineSprite::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"objectID" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		objectID = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"frames" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		frames = tmp_int;
		xmlFree( tmp );
	}

	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "tags" ) ) {
			
			
			xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					Tag* item = Tag::getByName( (const char *)child->name );
					if( item ) {
						item->parseXML( child, ctx );
						tags.append( item );
						
					}
				}
				child = child->next;
			}
			
			node2=NULL;
		} else {
			node2 = node2->next;
		}
	}

}

void FrameLabel::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("FrameLabel::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"label" );
	if( tmp ) {
		label = strdup((const char *)tmp);
	} else {
		fprintf(stderr,"WARNING: no label property in %s element\n", (const char *)node->name );
		label = strdup("[undefined]");
	}

	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "flags" ) ) {

		xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					flags.parseXML( child, ctx );
					node2 = child = NULL;
					node2 = NULL;
				} else {
					child = child->next;
				}
			}
		}
		if( node2 ) node2 = node2->next;
	}

}

void SoundStreamHead2::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("SoundStreamHead2::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"playbackRate" );
	if( tmp ) {
		sscanf( (char *)tmp, "%i", &playbackRate);
		xmlFree( tmp );
		
	} else {
		fprintf(stderr,"WARNING: no playbackRate property in %s element\n", (const char *)node->name );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"playbackSize" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		playbackSize = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"playbackStereo" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		playbackStereo = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"compression" );
	if( tmp ) {
		sscanf( (char *)tmp, "%i", &compression);
		xmlFree( tmp );
		
	} else {
		fprintf(stderr,"WARNING: no compression property in %s element\n", (const char *)node->name );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"soundRate" );
	if( tmp ) {
		sscanf( (char *)tmp, "%i", &soundRate);
		xmlFree( tmp );
		
	} else {
		fprintf(stderr,"WARNING: no soundRate property in %s element\n", (const char *)node->name );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"soundSize" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		soundSize = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"soundStereo" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		soundStereo = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"sampleSize" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		sampleSize = tmp_int;
		xmlFree( tmp );
	}

	if( compression==2 ) {
		
	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "latencySeek" ) ) {

		xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					latencySeek.parseXML( child, ctx );
					node2 = child = NULL;
					node2 = NULL;
				} else {
					child = child->next;
				}
			}
		}
		if( node2 ) node2 = node2->next;
	}

	}

}

void DefineFont::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("DefineFont::parseXML\n");

	
	ctx->tagVersion = 1;

	ctx->wideGlyphOffsets = 0;

	tmp = xmlGetProp( node, (const xmlChar *)"objectID" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		objectID = tmp_int;
		xmlFree( tmp );
	}

	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "glyphs" ) ) {

		xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					glyphs.parseXML( child, ctx );
					node2 = child = NULL;
					node2 = NULL;
				} else {
					child = child->next;
				}
			}
		}
		if( node2 ) node2 = node2->next;
	}

}

void DefineFont2::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("DefineFont2::parseXML\n");

	
		ctx->wideGlyphOffsets = 0;
	
		ctx->wideMap = 0;
	
		ctx->glyphCount = 0;
	
	ctx->tagVersion = 2;

	tmp = xmlGetProp( node, (const xmlChar *)"objectID" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		objectID = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"isShiftJIS" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		isShiftJIS = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"isUnicode" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		isUnicode = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"isANSII" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		isANSII = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"wideGlyphOffsets" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		wideGlyphOffsets = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"italic" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		italic = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"bold" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		bold = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"language" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		language = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"name" );
	if( tmp ) {
		name = strdup((const char *)tmp);
	} else {
		fprintf(stderr,"WARNING: no name property in %s element\n", (const char *)node->name );
		name = strdup("[undefined]");
	}

	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "glyphs" ) ) {

		xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					glyphs.parseXML( child, ctx );
					node2 = child = NULL;
					node2 = NULL;
				} else {
					child = child->next;
				}
			}
		}
		if( node2 ) node2 = node2->next;
	}

	{
		bool has = false;
		
	if( xmlHasProp( node, (const xmlChar *)"ascent" ) ) has = true;

					if( has ) hasLayout = true;
				
	if( xmlHasProp( node, (const xmlChar *)"descent" ) ) has = true;

					if( has ) hasLayout = true;
				
	if( xmlHasProp( node, (const xmlChar *)"leading" ) ) has = true;

					if( has ) hasLayout = true;
				
	{
		xmlNodePtr child = node->children;
		while( child && !has ) {
			if( !strcmp( (const char *)child->name, "advance" ) ) has = true;
			child = child->next;
		}
	}

					if( has ) hasLayout = true;
				
	{
		xmlNodePtr child = node->children;
		while( child && !has ) {
			if( !strcmp( (const char *)child->name, "bounds" ) ) has = true;
			child = child->next;
		}
	}

					if( has ) hasLayout = true;
				
	{
		xmlNodePtr child = node->children;
		while( child && !has ) {
			if( !strcmp( (const char *)child->name, "wideKerning" ) ) has = true;
			child = child->next;
		}
	}

					if( has ) hasLayout = true;
				
	{
		xmlNodePtr child = node->children;
		while( child && !has ) {
			if( !strcmp( (const char *)child->name, "kerning" ) ) has = true;
			child = child->next;
		}
	}

					if( has ) hasLayout = true;
				
		
		if( has ) {
			
	tmp = xmlGetProp( node, (const xmlChar *)"ascent" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		ascent = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"descent" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		descent = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"leading" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		leading = tmp_int;
		xmlFree( tmp );
	}

	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "advance" ) ) {
			glyphCount=0;
			
			
			xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					Short* item = Short::getByName( (const char *)child->name );
					if( item ) {
						item->parseXML( child, ctx );
						advance.append( item );
						glyphCount++;
						
					}
				}
				child = child->next;
			}
			
			node2=NULL;
		} else {
			node2 = node2->next;
		}
	}

	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "bounds" ) ) {
			glyphCount=0;
			
			
			xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					Rectangle* item = Rectangle::getByName( (const char *)child->name );
					if( item ) {
						item->parseXML( child, ctx );
						bounds.append( item );
						glyphCount++;
						
					}
				}
				child = child->next;
			}
			
			node2=NULL;
		} else {
			node2 = node2->next;
		}
	}

	{
		bool has = false;
		
	{
		xmlNodePtr child = node->children;
		while( child && !has ) {
			if( !strcmp( (const char *)child->name, "wideKerning" ) ) has = true;
			child = child->next;
		}
	}

					if( has ) wideMap = true;
				
		
		if( has ) {
			
	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "wideKerning" ) ) {
			kerningCount=0;
			
			
			xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					WideKerning* item = WideKerning::getByName( (const char *)child->name );
					if( item ) {
						item->parseXML( child, ctx );
						wideKerning.append( item );
						kerningCount++;
						
					}
				}
				child = child->next;
			}
			
			node2=NULL;
		} else {
			node2 = node2->next;
		}
	}

		}
	
		
	}

	{
		bool has = false;
		
	{
		xmlNodePtr child = node->children;
		while( child && !has ) {
			if( !strcmp( (const char *)child->name, "kerning" ) ) has = true;
			child = child->next;
		}
	}

					if( has ) wideMap = !true;
				
		
		if( has ) {
			
	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "kerning" ) ) {
			kerningCount=0;
			
			
			xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					Kerning* item = Kerning::getByName( (const char *)child->name );
					if( item ) {
						item->parseXML( child, ctx );
						kerning.append( item );
						kerningCount++;
						
					}
				}
				child = child->next;
			}
			
			node2=NULL;
		} else {
			node2 = node2->next;
		}
	}

		}
	
		
	}

		}
	
		
	}
wideGlyphOffsets = ctx->wideGlyphOffsets;
	wideMap = ctx->wideMap;
	glyphCount = ctx->glyphCount;
	
}

void DefineButton2::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("DefineButton2::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"objectID" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		objectID = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"menu" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		menu = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"buttonsSize" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		buttonsSize = tmp_int;
		xmlFree( tmp );
	}

	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "buttons" ) ) {
			
			
			xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					Button* item = Button::getByName( (const char *)child->name );
					if( item ) {
						item->parseXML( child, ctx );
						buttons.append( item );
						
					}
				}
				child = child->next;
			}
			
			node2=NULL;
		} else {
			node2 = node2->next;
		}
	}

	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "conditions" ) ) {
			
			
			xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					Condition* item = Condition::getByName( (const char *)child->name );
					if( item ) {
						item->parseXML( child, ctx );
						conditions.append( item );
						
					}
				}
				child = child->next;
			}
			
			node2=NULL;
		} else {
			node2 = node2->next;
		}
	}

}

void Export::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("Export::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"count" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		count = tmp_int;
		xmlFree( tmp );
	}

	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "symbols" ) ) {
			count=0;
			
			
			xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					Symbol* item = Symbol::getByName( (const char *)child->name );
					if( item ) {
						item->parseXML( child, ctx );
						symbols.append( item );
						count++;
						
					}
				}
				child = child->next;
			}
			
			node2=NULL;
		} else {
			node2 = node2->next;
		}
	}

}

void DoInitAction::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("DoInitAction::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"sprite" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		sprite = tmp_int;
		xmlFree( tmp );
	}

	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "actions" ) ) {
			
			
			xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					Action* item = Action::getByName( (const char *)child->name );
					if( item ) {
						item->parseXML( child, ctx );
						actions.append( item );
						
					}
				}
				child = child->next;
			}
			
			node2=NULL;
		} else {
			node2 = node2->next;
		}
	}

}

void SoundStreamBlock::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("SoundStreamBlock::parseXML\n");

	
	{
		data = NULL;
		len = 0;

		xmlChar *xmld = xmlNodeGetContent( node );
		char *d = (char *)xmld;
		if( d ) {
			// unsure if this is neccessary
			for( int i=strlen(d)-1; i>0 && isspace(d[i]); i-- ) d[i]=0;
			while( isspace(d[0]) ) d++;
			int l = strlen(d); //BASE64_GET_MAX_DECODED_LEN(strlen( d ));
			char *dst = new char[ l ];
			int lout = base64_decode( dst, (char*)d, l );
			if( lout > 0 ) {
				len = lout;
				data = new unsigned char[ lout ];
				memcpy( data, dst, lout );
			}
			delete dst;
			xmlFree( xmld );
		} 
	}

}

void DefineVideoStream::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("DefineVideoStream::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"objectID" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		objectID = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"frames" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		frames = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"width" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		width = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"height" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		height = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"deblocking" );
	if( tmp ) {
		sscanf( (char *)tmp, "%i", &deblocking);
		xmlFree( tmp );
		
	} else {
		fprintf(stderr,"WARNING: no deblocking property in %s element\n", (const char *)node->name );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"smoothing" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		smoothing = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"codec" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		codec = tmp_int;
		xmlFree( tmp );
	}

}

void VideoFrame::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("VideoFrame::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"objectID" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		objectID = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"frame" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		frame = tmp_int;
		xmlFree( tmp );
	}

	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "data" ) ) {

		xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					data.parseXML( child, ctx );
					node2 = child = NULL;
					node2 = NULL;
				} else {
					child = child->next;
				}
			}
		}
		if( node2 ) node2 = node2->next;
	}

}

void StackString::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("StackString::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"value" );
	if( tmp ) {
		value = strdup((const char *)tmp);
	} else {
		fprintf(stderr,"WARNING: no value property in %s element\n", (const char *)node->name );
		value = strdup("[undefined]");
	}

}

void StackFloat::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("StackFloat::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"value" );
	if( tmp ) {
		sscanf( (char *)tmp, "%i", &value);
		xmlFree( tmp );
		
	} else {
		fprintf(stderr,"WARNING: no value property in %s element\n", (const char *)node->name );
	}

}

void StackNull::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("StackNull::parseXML\n");

	
}

void StackUndefined::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("StackUndefined::parseXML\n");

	
}

void StackRegister::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("StackRegister::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"reg" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		reg = tmp_int;
		xmlFree( tmp );
	}

}

void StackBoolean::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("StackBoolean::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"value" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		value = tmp_int;
		xmlFree( tmp );
	}

}

void StackDouble::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("StackDouble::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"value" );
	if( tmp ) {
		sscanf( (char *)tmp, "%i", &value);
		xmlFree( tmp );
		
	} else {
		fprintf(stderr,"WARNING: no value property in %s element\n", (const char *)node->name );
	}

}

void StackInteger::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("StackInteger::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"value" );
	if( tmp ) {
		sscanf( (char *)tmp, "%i", &value);
		xmlFree( tmp );
		
	} else {
		fprintf(stderr,"WARNING: no value property in %s element\n", (const char *)node->name );
	}

}

void StackDictionaryLookup::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("StackDictionaryLookup::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"index" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		index = tmp_int;
		xmlFree( tmp );
	}

}

void StackLargeDictionaryLookup::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("StackLargeDictionaryLookup::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"index" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		index = tmp_int;
		xmlFree( tmp );
	}

}

void UnknownAction::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("UnknownAction::parseXML\n");

	
	{
		data = NULL;
		len = 0;

		xmlChar *xmld = xmlNodeGetContent( node );
		char *d = (char *)xmld;
		if( d ) {
			// unsure if this is neccessary
			for( int i=strlen(d)-1; i>0 && isspace(d[i]); i-- ) d[i]=0;
			while( isspace(d[0]) ) d++;
			int l = strlen(d); //BASE64_GET_MAX_DECODED_LEN(strlen( d ));
			char *dst = new char[ l ];
			int lout = base64_decode( dst, (char*)d, l );
			if( lout > 0 ) {
				len = lout;
				data = new unsigned char[ lout ];
				memcpy( data, dst, lout );
			}
			delete dst;
			xmlFree( xmld );
		} 
	}

		tmp = xmlGetProp( node, (const xmlChar *)"id" );
		if( tmp ) { 
			sscanf( (char *)tmp, "%X", &type ); 
			xmlFree( (xmlChar *)tmp ); 
		}
	
}

void EndAction::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("EndAction::parseXML\n");

	
}

void NextFrame::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("NextFrame::parseXML\n");

	
}

void PreviousFrame::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("PreviousFrame::parseXML\n");

	
}

void Play::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("Play::parseXML\n");

	
}

void Stop::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("Stop::parseXML\n");

	
}

void ToggleQuality::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("ToggleQuality::parseXML\n");

	
}

void StopSound::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("StopSound::parseXML\n");

	
}

void AddCast::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("AddCast::parseXML\n");

	
}

void Substract::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("Substract::parseXML\n");

	
}

void Mulitply::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("Mulitply::parseXML\n");

	
}

void Divide::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("Divide::parseXML\n");

	
}

void EqualCast::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("EqualCast::parseXML\n");

	
}

void LessThanCast::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("LessThanCast::parseXML\n");

	
}

void LogicalAND::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("LogicalAND::parseXML\n");

	
}

void LogicalOR::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("LogicalOR::parseXML\n");

	
}

void LogicalNOT::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("LogicalNOT::parseXML\n");

	
}

void StringEqual::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("StringEqual::parseXML\n");

	
}

void StringLength::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("StringLength::parseXML\n");

	
}

void SubString::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("SubString::parseXML\n");

	
}

void Pop::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("Pop::parseXML\n");

	
}

void IntegralPart::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("IntegralPart::parseXML\n");

	
}

void GetVariable::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("GetVariable::parseXML\n");

	
}

void SetVariable::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("SetVariable::parseXML\n");

	
}

void SetTargetDynamic::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("SetTargetDynamic::parseXML\n");

	
}

void ConcatenateString::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("ConcatenateString::parseXML\n");

	
}

void GetProperty::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("GetProperty::parseXML\n");

	
}

void SetProperty::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("SetProperty::parseXML\n");

	
}

void DuplicateSprite::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("DuplicateSprite::parseXML\n");

	
}

void RemoveSprite::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("RemoveSprite::parseXML\n");

	
}

void Trace::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("Trace::parseXML\n");

	
}

void StartDrag::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("StartDrag::parseXML\n");

	
}

void StopDrag::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("StopDrag::parseXML\n");

	
}

void StringLessThan::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("StringLessThan::parseXML\n");

	
}

void Throw::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("Throw::parseXML\n");

	
}

void CastObject::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("CastObject::parseXML\n");

	
}

void Implements::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("Implements::parseXML\n");

	
}

void Random::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("Random::parseXML\n");

	
}

void MultibyteStringLength::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("MultibyteStringLength::parseXML\n");

	
}

void ORD::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("ORD::parseXML\n");

	
}

void CHR::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("CHR::parseXML\n");

	
}

void GetTimer::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("GetTimer::parseXML\n");

	
}

void MultibyteSubString::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("MultibyteSubString::parseXML\n");

	
}

void MultibyteORD::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("MultibyteORD::parseXML\n");

	
}

void MultibyteCHR::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("MultibyteCHR::parseXML\n");

	
}

void Delete::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("Delete::parseXML\n");

	
}

void DeleteAll::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("DeleteAll::parseXML\n");

	
}

void SetLocalVariable::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("SetLocalVariable::parseXML\n");

	
}

void CallFunction::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("CallFunction::parseXML\n");

	
}

void Return::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("Return::parseXML\n");

	
}

void Modulo::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("Modulo::parseXML\n");

	
}

void New::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("New::parseXML\n");

	
}

void DeclareLocalVariable::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("DeclareLocalVariable::parseXML\n");

	
}

void DeclareArray::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("DeclareArray::parseXML\n");

	
}

void DeclareObject::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("DeclareObject::parseXML\n");

	
}

void TypeOf::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("TypeOf::parseXML\n");

	
}

void GetTarget::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("GetTarget::parseXML\n");

	
}

void Enumerate::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("Enumerate::parseXML\n");

	
}

void AddTyped::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("AddTyped::parseXML\n");

	
}

void LessThanTyped::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("LessThanTyped::parseXML\n");

	
}

void EqualTyped::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("EqualTyped::parseXML\n");

	
}

void DefineNumber::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("DefineNumber::parseXML\n");

	
}

void DefineString::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("DefineString::parseXML\n");

	
}

void Duplicate::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("Duplicate::parseXML\n");

	
}

void Swap::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("Swap::parseXML\n");

	
}

void GetMember::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("GetMember::parseXML\n");

	
}

void SetMember::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("SetMember::parseXML\n");

	
}

void Increment::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("Increment::parseXML\n");

	
}

void Decrement::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("Decrement::parseXML\n");

	
}

void CallMethod::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("CallMethod::parseXML\n");

	
}

void NewMethod::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("NewMethod::parseXML\n");

	
}

void InstanceOf::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("InstanceOf::parseXML\n");

	
}

void EnumerateObject::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("EnumerateObject::parseXML\n");

	
}

void AND::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("AND::parseXML\n");

	
}

void OR::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("OR::parseXML\n");

	
}

void XOR::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("XOR::parseXML\n");

	
}

void ShiftLeft::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("ShiftLeft::parseXML\n");

	
}

void ShiftRight::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("ShiftRight::parseXML\n");

	
}

void ShiftRightUnsigned::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("ShiftRightUnsigned::parseXML\n");

	
}

void StrictEqual::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("StrictEqual::parseXML\n");

	
}

void GreaterThanTyped::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("GreaterThanTyped::parseXML\n");

	
}

void StringGreaterThan::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("StringGreaterThan::parseXML\n");

	
}

void Extends::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("Extends::parseXML\n");

	
}

void GotoFrame::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("GotoFrame::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"frame" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		frame = tmp_int;
		xmlFree( tmp );
	}

}

void GetURL::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("GetURL::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"url" );
	if( tmp ) {
		url = strdup((const char *)tmp);
	} else {
		fprintf(stderr,"WARNING: no url property in %s element\n", (const char *)node->name );
		url = strdup("[undefined]");
	}

	tmp = xmlGetProp( node, (const xmlChar *)"target" );
	if( tmp ) {
		target = strdup((const char *)tmp);
	} else {
		fprintf(stderr,"WARNING: no target property in %s element\n", (const char *)node->name );
		target = strdup("[undefined]");
	}

}

void StoreRegister::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("StoreRegister::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"reg" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		reg = tmp_int;
		xmlFree( tmp );
	}

}

void Dictionary::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("Dictionary::parseXML\n");

	
	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "strings" ) ) {
			length=0;
			
			
			xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					String* item = String::getByName( (const char *)child->name );
					if( item ) {
						item->parseXML( child, ctx );
						strings.append( item );
						length++;
						
					}
				}
				child = child->next;
			}
			
			node2=NULL;
		} else {
			node2 = node2->next;
		}
	}

}

void WaitForFrame::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("WaitForFrame::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"frame" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		frame = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"skip" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		skip = tmp_int;
		xmlFree( tmp );
	}

}

void SetTarget::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("SetTarget::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"label" );
	if( tmp ) {
		label = strdup((const char *)tmp);
	} else {
		fprintf(stderr,"WARNING: no label property in %s element\n", (const char *)node->name );
		label = strdup("[undefined]");
	}

}

void GotoLabel::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("GotoLabel::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"label" );
	if( tmp ) {
		label = strdup((const char *)tmp);
	} else {
		fprintf(stderr,"WARNING: no label property in %s element\n", (const char *)node->name );
		label = strdup("[undefined]");
	}

}

void WaitForFrameDynamic::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("WaitForFrameDynamic::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"frame" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		frame = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"skip" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		skip = tmp_int;
		xmlFree( tmp );
	}

}

void DeclareFunction2::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("DeclareFunction2::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"name" );
	if( tmp ) {
		name = strdup((const char *)tmp);
	} else {
		fprintf(stderr,"WARNING: no name property in %s element\n", (const char *)node->name );
		name = strdup("[undefined]");
	}

	tmp = xmlGetProp( node, (const xmlChar *)"argc" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		argc = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"regc" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		regc = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"preloadGlobal" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		preloadGlobal = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"preloadParent" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		preloadParent = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"preloadRoot" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		preloadRoot = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"suppressSuper" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		suppressSuper = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"preloadSuper" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		preloadSuper = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"suppressArguments" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		suppressArguments = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"preloadArguments" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		preloadArguments = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"suppressThis" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		suppressThis = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"preloadThis" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		preloadThis = tmp_int;
		xmlFree( tmp );
	}

	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "args" ) ) {
			argc=0;
			
			
			xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					Parameter* item = Parameter::getByName( (const char *)child->name );
					if( item ) {
						item->parseXML( child, ctx );
						args.append( item );
						argc++;
						
					}
				}
				child = child->next;
			}
			
			node2=NULL;
		} else {
			node2 = node2->next;
		}
	}

	tmp = xmlGetProp( node, (const xmlChar *)"length" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		length = tmp_int;
		xmlFree( tmp );
	}

}

void Try::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("Try::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"doFinally" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		doFinally = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"doCatch" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		doCatch = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"trySize" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		trySize = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"catchSize" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		catchSize = tmp_int;
		xmlFree( tmp );
	}

	tmp = xmlGetProp( node, (const xmlChar *)"finallySize" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		finallySize = tmp_int;
		xmlFree( tmp );
	}

	{
		bool has = false;
		
	if( xmlHasProp( node, (const xmlChar *)"reg" ) ) has = true;

					if( has ) catchInRegister = true;
				
		
		if( has ) {
			
	tmp = xmlGetProp( node, (const xmlChar *)"reg" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		reg = tmp_int;
		xmlFree( tmp );
	}

		}
	
		
	}

}

void With::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("With::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"size" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		size = tmp_int;
		xmlFree( tmp );
	}

}

void PushData::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("PushData::parseXML\n");

	
	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "items" ) ) {
			
			
			xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					StackItem* item = StackItem::getByName( (const char *)child->name );
					if( item ) {
						item->parseXML( child, ctx );
						items.append( item );
						
					}
				}
				child = child->next;
			}
			
			node2=NULL;
		} else {
			node2 = node2->next;
		}
	}

}

void GetURL2::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("GetURL2::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"method" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		method = tmp_int;
		xmlFree( tmp );
	}

}

void DeclareFunction::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("DeclareFunction::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"name" );
	if( tmp ) {
		name = strdup((const char *)tmp);
	} else {
		fprintf(stderr,"WARNING: no name property in %s element\n", (const char *)node->name );
		name = strdup("[undefined]");
	}

	tmp = xmlGetProp( node, (const xmlChar *)"argc" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		argc = tmp_int;
		xmlFree( tmp );
	}

	node2 = node->children;
	while( node2 ) {
		if( !strcmp( (const char *)node2->name, "args" ) ) {
			argc=0;
			
			
			xmlNodePtr child = node2->children;
			while( child ) {
				if( !xmlNodeIsText( child ) ) {
					String* item = String::getByName( (const char *)child->name );
					if( item ) {
						item->parseXML( child, ctx );
						args.append( item );
						argc++;
						
					}
				}
				child = child->next;
			}
			
			node2=NULL;
		} else {
			node2 = node2->next;
		}
	}

	tmp = xmlGetProp( node, (const xmlChar *)"length" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		length = tmp_int;
		xmlFree( tmp );
	}

}

void BranchAlways::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("BranchAlways::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"byteOffset" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		byteOffset = tmp_int;
		xmlFree( tmp );
	}

}

void BranchIfTrue::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("BranchIfTrue::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"byteOffset" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		byteOffset = tmp_int;
		xmlFree( tmp );
	}

}

void CallFrame::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("CallFrame::parseXML\n");

	
}

void GotoExpression::parseXML( xmlNodePtr node, Context *ctx ) {
	xmlNodePtr node2;
	xmlChar *tmp;
	
//	printf("GotoExpression::parseXML\n");

	
	tmp = xmlGetProp( node, (const xmlChar *)"play" );
	if( tmp ) {
		int tmp_int;
		sscanf( (char *)tmp, "%i", &tmp_int );
		play = tmp_int;
		xmlFree( tmp );
	}

}


}

